/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileItemLoader;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileItemLoaderAdvanced
extends TileItemLoader {
    private ForgeDirection direction = ForgeDirection.NORTH;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ITEM_LOADER_ADVANCED;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    @Override
    public Icon getBlockTexture(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public void onBlockPlacedBy(EntityLiving entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.direction = MiscTools.getSideClosestToPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, entityliving);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public ForgeDirection getOrientation() {
        return this.direction;
    }
}

