/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.PipeManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILiquidTransfer;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankToolkit;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.inventory.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class TileLiquidLoader
extends TileLoaderLiquidBase
implements ISidedInventory,
ISpecialInventory,
IGuiReturnHandler {
    private static final int TRANSFER_RATE = 20;
    private static final int CAPACITY = 8000;
    private static final float MAX_PIPE_LENGTH = 1.0f;
    private static final float PIPE_INCREMENT = 0.01f;
    private boolean waitTillFull = true;
    private boolean waitIfEmpty = true;
    private boolean waitForReset = false;
    private float pipeLenght = 0.0f;
    private final IInventory invInput = new InventoryMapper(this, 0, 1);
    private StandardTank tank = new StandardTank(8000, this);

    public TileLiquidLoader() {
        this.tank.setTankPressure(-1);
        this.tankManager.addTank(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.LIQUID_LOADER;
    }

    public IInventory getInputInventory() {
        return this.invInput;
    }

    private void resetPipe() {
        this.pipeLenght = 0.0f;
    }

    public float getPipeLenght() {
        return this.pipeLenght;
    }

    private void setPipeLength(float y) {
        this.pipeLenght = y;
        this.sendUpdateToClient();
    }

    private void extendPipe() {
        float y = this.pipeLenght + 0.01f;
        if (this.pipeIsExtended()) {
            y = 1.0f;
        }
        this.setPipeLength(y);
    }

    private void retractPipe() {
        float y = this.pipeLenght - 0.01f;
        if (this.pipeIsRetracted()) {
            y = 0.0f;
        }
        this.setPipeLength(y);
    }

    private boolean pipeIsExtended() {
        return this.pipeLenght >= 1.0f;
    }

    private boolean pipeIsRetracted() {
        return this.pipeLenght <= 0.0f;
    }

    @Override
    public Icon getBlockTexture(int side) {
        if (side > 1) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70316_g() {
        EntityLocomotiveSteam loco;
        LiquidStack drained;
        ItemStack bottomSlot;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack topSlot = this.func_70301_a(0);
        if (topSlot != null && !LiquidManager.instance().isContainer(topSlot)) {
            this.func_70299_a(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.func_70301_a(1)) != null && !LiquidManager.instance().isContainer(bottomSlot)) {
            this.func_70299_a(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.clock % 8 == 0) {
            LiquidManager.instance().processContainers(this.tankManager.getTank(0), this, 0, 1, true, false);
        }
        for (ForgeDirection side : ForgeDirection.values()) {
            TileEntity tile;
            if (side == ForgeDirection.UNKNOWN || !((tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, side)) instanceof ITankContainer)) continue;
            ITankContainer nearbyTank = (ITankContainer)tile;
            if (!PipeManager.canExtractLiquids(null, this.field_70331_k, MiscTools.getXOnSide(this.field_70329_l, side), MiscTools.getYOnSide(this.field_70330_m, side), MiscTools.getZOnSide(this.field_70327_n, side))) continue;
            side = side.getOpposite();
            drained = nearbyTank.drain(side, 20, false);
            int used = this.tank.fill(drained, true);
            nearbyTank.drain(side, used, true);
        }
        boolean needsPipe = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.2f, ForgeDirection.DOWN);
        if (cart == null) {
            cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, 0.2f, ForgeDirection.DOWN);
            needsPipe = true;
        }
        if (cart != this.currentCart) {
            if (this.currentCart instanceof ILiquidTransfer) {
                ((EntityCartTank)this.currentCart).setFilling(false);
            }
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
            this.waitForReset = false;
        }
        if (this.waitForReset) {
            if (this.pipeIsRetracted()) {
                this.sendCart(cart);
            } else {
                this.retractPipe();
            }
            return;
        }
        if (cart == null) {
            if (!this.pipeIsRetracted()) {
                this.retractPipe();
            }
            return;
        }
        if (this.isSendCartGateAction()) {
            this.sendCart(cart);
            return;
        }
        if (!(cart instanceof ITankContainer)) {
            this.sendCart(cart);
            return;
        }
        ItemStack minecartSlot1 = this.getCartFilters().func_70301_a(0);
        ItemStack minecartSlot2 = this.getCartFilters().func_70301_a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartTools.doesCartMatchFilter(minecartSlot1, cart) || CartTools.doesCartMatchFilter(minecartSlot2, cart))) {
            this.sendCart(cart);
            return;
        }
        if (cart instanceof EntityLocomotiveSteam && !(loco = (EntityLocomotiveSteam)cart).isSafeToFill()) {
            this.retractPipe();
            return;
        }
        if (this.actions.contains(Actions.PAUSE)) {
            return;
        }
        TankToolkit tankCart = new TankToolkit((ITankContainer)cart);
        boolean cartNeedsFilling = this.cartNeedsFilling(tankCart);
        if (cartNeedsFilling && needsPipe) {
            this.extendPipe();
        } else {
            this.retractPipe();
        }
        this.flow = 0;
        if (cartNeedsFilling && (!needsPipe || this.pipeIsExtended()) && (drained = this.tankManager.drain(0, RailcraftConfig.getTankCartFillRate(), false)) != null) {
            this.flow = tankCart.fill(ForgeDirection.UP, drained, true);
            this.tankManager.drain(0, this.flow, true);
        }
        if (this.flow > 0) {
            if (cart instanceof ILiquidTransfer) {
                ((EntityCartTank)cart).setFilling(true);
            }
            this.setPowered(false);
        } else if (cart instanceof ILiquidTransfer) {
            ((EntityCartTank)cart).setFilling(false);
        }
        if (tankCart.isTankFull(this.tank.getLiquid())) {
            this.waitForReset = true;
        }
        if (this.pipeIsRetracted() && this.flow <= 0 && this.shouldCartLeave(cart, tankCart)) {
            this.sendCart(cart);
        }
    }

    private void sendCart(EntityMinecart cart) {
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            this.setPowered(true);
        }
    }

    private boolean cartNeedsFilling(TankToolkit tankCart) {
        LiquidStack loaderLiquid = this.tank.getLiquid();
        return loaderLiquid != null && loaderLiquid.amount > 0 && tankCart.canPutLiquid(ForgeDirection.UP, loaderLiquid);
    }

    private boolean shouldCartLeave(EntityMinecart cart, TankToolkit tankCart) {
        boolean leave = false;
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (this.tank.getLiquid() != null && this.tank.getLiquid().amount > 0 && !tankCart.canPutLiquid(ForgeDirection.UP, this.tank.getLiquid())) {
                leave = true;
            } else if (!this.waitTillFull && !tankCart.isTankEmpty(this.tank.getLiquid())) {
                leave = true;
            } else if (!this.waitIfEmpty && !this.waitTillFull && tankCart.isTankEmpty(this.tank.getLiquid())) {
                leave = true;
            } else if (tankCart.isTankFull(this.tank.getLiquid())) {
                leave = true;
            }
        }
        return leave;
    }

    @Override
    protected void setPowered(boolean p) {
        if (p) {
            TileTrack trackTile;
            ITrackInstance track;
            TileEntity tile;
            this.resetPipe();
            if (this.field_70331_k != null && (tile = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 2, this.field_70327_n)) instanceof TileTrack && (track = (trackTile = (TileTrack)tile).getTrackInstance()) instanceof ITrackLockdown) {
                ((ITrackLockdown)track).releaseCart();
            }
        }
        super.setPowered(p);
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.resetPipe();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.resetPipe();
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("WaitIfEmpty", this.waitIfEmpty);
        data.func_74757_a("WaitTillFull", this.waitTillFull);
        data.func_74776_a("pipeLenght", this.pipeLenght);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.waitIfEmpty = data.func_74767_n("WaitIfEmpty");
        this.waitTillFull = data.func_74767_n("WaitTillFull");
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.pipeLenght = safe.getFloat("pipeLenght");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        byte bits = 0;
        bits = (byte)(bits | (this.waitIfEmpty ? 1 : 0));
        bits = (byte)(bits | (this.waitTillFull ? 2 : 0));
        data.writeByte(bits);
        data.writeFloat(this.pipeLenght);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte bits = data.readByte();
        this.waitIfEmpty = (bits & 1) != 0;
        this.waitTillFull = (bits & 2) != 0;
        this.setPipeLength(data.readFloat());
    }

    public boolean waitTillFull() {
        return this.waitTillFull;
    }

    public void setWaitTillFull(boolean waitTillFull) {
        this.waitTillFull = waitTillFull;
    }

    public boolean waitIfEmpty() {
        return this.waitIfEmpty;
    }

    public void setWaitIfEmpty(boolean waitIfEmpty) {
        this.waitIfEmpty = waitIfEmpty;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_LIQUID, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (LiquidManager.instance().isFilledContainer(stack)) {
            ItemStack ret;
            Object slot = new InventoryMapper(this, 0, 1);
            if (!doAdd) {
                slot = new InventoryCopy((IInventory)slot);
            }
            if ((ret = InvTools.moveItemStack(stack.func_77946_l(), slot)) != null && stack.field_77994_a != ret.field_77994_a) {
                return stack.field_77994_a - ret.field_77994_a;
            }
            if (ret == null) {
                return stack.field_77994_a;
            }
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        IInventory inv = this;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return new ItemStack[]{inv.func_70298_a(1, maxItemCount)};
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitIfEmpty);
        data.writeBoolean(this.waitTillFull);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.waitIfEmpty = data.readBoolean();
        this.waitTillFull = data.readBoolean();
    }
}

