/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.ore;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import java.util.Random;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockWorldLogic
extends Block {
    private static BlockWorldLogic instance;

    public static BlockWorldLogic getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.worldlogic")) > 0) {
            instance = new BlockWorldLogic(id);
            GameRegistry.registerBlock((Block)instance, (String)instance.func_71917_a());
            RailcraftLanguage.instance().registerItemName(new ItemStack((Block)instance), "ore.saltpeter.gen");
        }
    }

    public BlockWorldLogic(int id) {
        super(id, Material.field_76246_e);
        this.func_71864_b("railcraft.worldlogic");
        this.func_71894_b(6000000.0f);
        this.func_71875_q();
        this.func_71884_a(Block.field_71976_h);
        this.func_71849_a(CreativePlugin.TAB);
        this.func_71896_v();
        this.func_71907_b(true);
    }

    public void func_94332_a(IconRegister iconRegister) {
    }

    public Icon func_71858_a(int side, int meta) {
        return Block.field_71986_z.func_71858_a(side, meta);
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
        if (MiscTools.getRand().nextInt(32) != 0) {
            return;
        }
        BlockOre blockOre = BlockOre.getBlock();
        if (blockOre == null || !EnumOre.SALTPETER.isEnabled() || !RailcraftConfig.isWorldGenEnabled("saltpeter")) {
            return;
        }
        int surfaceY = world.func_72825_h(x, z) - 2;
        if (surfaceY < 50 || surfaceY > 100) {
            return;
        }
        int blockId = world.func_72798_a(x, surfaceY, z);
        if (blockId != Block.field_71939_E.field_71990_ca) {
            return;
        }
        int above = world.func_72798_a(x, surfaceY + 1, z);
        if (above != Block.field_71939_E.field_71990_ca) {
            return;
        }
        int below = world.func_72798_a(x, surfaceY - 1, z);
        if (below != Block.field_71939_E.field_71990_ca && below != Block.field_71957_Q.field_71990_ca) {
            return;
        }
        int airCount = 0;
        BlockOre ore = BlockOre.getBlock();
        for (ForgeDirection side : EnumSet.of(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST)) {
            int id = MiscTools.getBlockIdOnSide((IBlockAccess)world, x, surfaceY, z, side);
            if (id == 0) {
                ++airCount;
            }
            if (airCount > 1) {
                return;
            }
            if (id == 0 || id == Block.field_71939_E.field_71990_ca || id == Block.field_71957_Q.field_71990_ca || id == ore.field_71990_ca) continue;
            return;
        }
        world.func_72832_d(x, surfaceY, z, ore.field_71990_ca, EnumOre.SALTPETER.ordinal(), 3);
    }

    public int func_71859_p_(World world) {
        return 6000;
    }
}

