/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.util.ArrayList;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.client.util.textures.SheetTextureStitched;
import mods.railcraft.common.blocks.tracks.MaterialElevator;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockTrackElevator
extends Block {
    public static double CLIMB_UP_VELOCITY = 0.2;
    public static double CLIMB_DOWN_VELOCITY = -0.3;
    public static double FALL_DOWN_CORRECTION = 0.04f;
    public static final int FACING_EAST_METADATA_VALUE = 2;
    public static final int FACING_WEST_METADATA_VALUE = 3;
    public static final int FACING_NORTH_METADATA_VALUE = 4;
    public static final int FACING_SOUTH_METADATA_VALUE = 5;
    public static final double RIDE_UP_VELOCITY = 0.4;
    public static final double RIDE_DOWN_VELOCITY = -0.4;
    public static final int BLOCK_FACING_DATA_METADATA_MASK = 7;
    private int renderType;
    private Icon[] texture;

    public BlockTrackElevator(int blockId, int renderId) {
        super(blockId, (Material)new MaterialElevator());
        this.func_71848_c(1.05f);
        this.func_71884_a(field_71977_i);
        this.renderType = renderId;
        this.func_71849_a(CreativeTabs.field_78029_e);
    }

    public MovingObjectPosition func_71878_a(World world, int i, int j, int k, Vec3 vec3d, Vec3 vec3d1) {
        this.func_71902_a((IBlockAccess)world, i, j, k);
        return super.func_71878_a(world, i, j, k, vec3d, vec3d1);
    }

    public void func_71902_a(IBlockAccess world, int i, int j, int k) {
        int meta = this.getLadderFacingMetadata(world, i, j, k);
        float f = 0.125f;
        if (meta == 2) {
            this.func_71905_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 3) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (meta == 4) {
            this.func_71905_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 5) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int i, int j, int k) {
        return null;
    }

    public AxisAlignedBB func_71911_a_(World world, int i, int j, int k) {
        this.func_71902_a((IBlockAccess)world, i, j, k);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)i + this.field_72026_ch, (double)j + this.field_72023_ci, (double)k + this.field_72024_cj, (double)i + this.field_72021_ck, (double)j + this.field_72022_cl, (double)k + this.field_72019_cm);
    }

    public int func_71857_b() {
        return this.renderType;
    }

    public boolean isLadder(World world, int i, int j, int k) {
        return true;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public void addCreativeItems(ArrayList itemList) {
        itemList.add(new ItemStack((Block)this));
    }

    public Icon func_71858_a(int side, int meta) {
        boolean powered;
        boolean bl = powered = (meta & 8) != 0;
        if (powered) {
            return this.texture[0];
        }
        return this.texture[1];
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.texture = SheetTextureStitched.unstitchIcons(iconRegister, "railcraft:tracks/track.elevator", 2);
    }

    public boolean func_71930_b(World world, int i, int j, int k) {
        if (world.isBlockSolidOnSide(i - 1, j, k, ForgeDirection.EAST)) {
            return true;
        }
        if (world.isBlockSolidOnSide(i + 1, j, k, ForgeDirection.WEST)) {
            return true;
        }
        if (world.isBlockSolidOnSide(i, j, k - 1, ForgeDirection.SOUTH)) {
            return true;
        }
        return world.isBlockSolidOnSide(i, j, k + 1, ForgeDirection.NORTH);
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        if ((meta == 0 || side == 2) && world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH)) {
            meta = 2;
        }
        if ((meta == 0 || side == 3) && world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH)) {
            meta = 3;
        }
        if ((meta == 0 || side == 4) && world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST)) {
            meta = 4;
        }
        if ((meta == 0 || side == 5) && world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST)) {
            meta = 5;
        }
        return meta;
    }

    public void func_85105_g(World world, int x, int y, int z, int meta) {
        boolean powered;
        int id;
        BlockRailBase railBlock;
        this.func_71902_a((IBlockAccess)world, x, y, z);
        if (BlockRailBase.func_72180_d_((World)world, (int)x, (int)(y - 1), (int)z) && (railBlock = (BlockRailBase)Block.field_71973_m[id = world.func_72798_a(x, y - 1, z)]).canMakeSlopes(world, x, y - 1, z)) {
            int trackMeta = railBlock.getBasicRailMetadata((IBlockAccess)world, null, x, y - 1, z);
            int ladderMeta = this.getLadderFacingMetadata((IBlockAccess)world, x, y, z);
            int outputMeta = 0;
            if (trackMeta == 0 && ladderMeta == 2) {
                outputMeta = 5;
            } else if (trackMeta == 0 && ladderMeta == 3) {
                outputMeta = 4;
            } else if (trackMeta == 1 && ladderMeta == 4) {
                outputMeta = 2;
            } else if (trackMeta == 1 && ladderMeta == 5) {
                outputMeta = 3;
            }
            if (outputMeta != 0) {
                if (railBlock.func_72183_n()) {
                    outputMeta |= world.func_72805_g(x, y - 1, z) & 8;
                }
                world.func_72921_c(x, y - 1, z, outputMeta, 3);
            }
        }
        boolean bl = powered = ((meta = world.func_72805_g(x, y, z)) & 8) != 0;
        if (powered ^ this.isPowered(world, x, y, z)) {
            world.func_72921_c(x, y, z, meta ^ 8, 3);
        }
        world.func_72845_h(x, y, z);
    }

    public void func_71914_a(World world, int i, int j, int k, int l, float f, int i1) {
        super.func_71914_a(world, i, j, k, l, f, i1);
    }

    public void func_71863_a(World world, int i, int j, int k, int l) {
        int meta = world.func_72805_g(i, j, k);
        int ladderMeta = this.getLadderFacingMetadata((IBlockAccess)world, i, j, k);
        boolean valid = false;
        if (ladderMeta == 2 && world.isBlockSolidOnSide(i, j, k + 1, ForgeDirection.NORTH)) {
            valid = true;
        }
        if (ladderMeta == 3 && world.isBlockSolidOnSide(i, j, k - 1, ForgeDirection.SOUTH)) {
            valid = true;
        }
        if (ladderMeta == 4 && world.isBlockSolidOnSide(i + 1, j, k, ForgeDirection.WEST)) {
            valid = true;
        }
        if (ladderMeta == 5 && world.isBlockSolidOnSide(i - 1, j, k, ForgeDirection.EAST)) {
            valid = true;
        }
        if (!valid) {
            this.func_71897_c(world, i, j, k, ladderMeta, 0);
            world.func_94571_i(i, j, k);
        } else {
            boolean powered;
            boolean bl = powered = (meta & 8) != 0;
            if (powered ^ this.isPowered(world, i, j, k)) {
                world.func_72921_c(i, j, k, meta ^ 8, 3);
                world.func_72845_h(i, j, k);
            }
        }
    }

    public void func_71869_a(World world, int i, int j, int k, Entity entity) {
        entity.field_70143_R = 0.0f;
        if (Game.isNotHost(world) || !(entity instanceof EntityMinecart)) {
            return;
        }
        this.minecartInteraction(world, (EntityMinecart)entity, i, j, k);
    }

    public int getLadderFacingMetadata(IBlockAccess world, int i, int j, int k) {
        return world.func_72805_g(i, j, k) & 7;
    }

    public boolean getPoweredBit(World world, int i, int j, int k) {
        return (world.func_72805_g(i, j, k) & 8) != 0;
    }

    protected boolean isPowered(World world, int x, int y, int z) {
        int meta = this.getLadderFacingMetadata((IBlockAccess)world, x, y, z);
        if (world.func_72798_a(x, y - 1, z) == this.field_71990_ca && meta == this.getLadderFacingMetadata((IBlockAccess)world, x, y - 1, z) && PowerPlugin.isBlockBeingPowered(world, x, y - 1, z)) {
            return true;
        }
        if (PowerPlugin.isBlockBeingPowered(world, x, y, z)) {
            return true;
        }
        return world.func_72798_a(x, y + 1, z) == this.field_71990_ca && meta == this.getLadderFacingMetadata((IBlockAccess)world, x, y + 1, z) && this.isPowered(world, x, y + 1, z);
    }

    protected void minecartInteraction(World world, EntityMinecart cart, int i, int j, int k) {
        cart.getEntityData().func_74774_a("elevator", (byte)20);
        boolean powered = this.getPoweredBit(world, i, j, k);
        if (powered) {
            if (world.func_72798_a(i, j + 1, k) == this.field_71990_ca || this.isOffloadRail(world, i, j + 1, k)) {
                boolean empty = true;
                for (EntityMinecart c : CartTools.getMinecartsAt(world, i, j + 1, k, 0.2f)) {
                    if (c == cart) continue;
                    empty = false;
                }
                if ((this.getPoweredBit(world, i, j + 1, k) || this.isOffloadRail(world, i, j + 1, k)) && empty) {
                    cart.field_70181_x = 0.4 + FALL_DOWN_CORRECTION;
                } else {
                    if (this.pushMinecartOntoRail(world, i, j, k, cart)) {
                        return;
                    }
                    cart.func_70107_b(cart.field_70165_t, (double)((float)j + 0.5f), cart.field_70161_v);
                    cart.field_70181_x = FALL_DOWN_CORRECTION;
                }
            } else {
                cart.func_70107_b(cart.field_70165_t, (double)((float)j + 0.5f), cart.field_70161_v);
            }
        } else {
            if (world.func_72798_a(i, j - 1, k) != this.field_71990_ca) {
                this.pushMinecartOntoRail(world, i, j, k, cart);
                return;
            }
            boolean empty = true;
            for (EntityMinecart c : CartTools.getMinecartsAt(world, i, j - 1, k, 0.2f)) {
                if (c == cart) continue;
                empty = false;
            }
            if (empty) {
                cart.field_70181_x = -0.4 + FALL_DOWN_CORRECTION;
            } else {
                cart.func_70107_b(cart.field_70165_t, (double)((float)j + 0.5f), cart.field_70161_v);
                cart.field_70181_x = FALL_DOWN_CORRECTION;
            }
        }
        if (powered || !TrackTools.isRailBlockAt(world, i, j - 1, k)) {
            if (TrackTools.isRailBlockAt(world, i, j - 1, k) || TrackTools.isRailBlockAt(world, i, j - 2, k)) {
                cart.setCanUseRail(false);
            } else {
                cart.setCanUseRail(true);
            }
            this.keepMinecartConnected(world, i, j, k, cart);
        } else {
            cart.setCanUseRail(true);
        }
        if (powered) {
            this.pushMinecartOnSupportingBlockIfPossible(world, i, j, k, cart);
        }
    }

    protected void keepMinecartConnected(World world, int i, int j, int k, EntityMinecart minecart) {
        minecart.field_70159_w = (double)i + 0.5 - minecart.field_70165_t;
        minecart.field_70179_y = (double)k + 0.5 - minecart.field_70161_v;
        this.allignMinecart(world, i, j, k, minecart);
    }

    protected void allignMinecart(World world, int i, int j, int k, EntityMinecart minecart) {
        switch (this.getLadderFacingMetadata((IBlockAccess)world, i, j, k)) {
            case 4: 
            case 5: {
                minecart.field_70177_z = minecart.field_70177_z <= 90.0f || minecart.field_70177_z > 270.0f ? 0.0f : 180.0f;
                return;
            }
            case 2: 
            case 3: {
                minecart.field_70177_z = minecart.field_70177_z > 180.0f ? 270.0f : 90.0f;
                return;
            }
        }
    }

    private boolean isOffloadRail(World world, int i, int j, int k) {
        if (world.func_72798_a(i, j, k) != this.field_71990_ca) {
            switch (world.func_72805_g(i, j - 1, k) & 7) {
                case 2: {
                    if (TrackTools.isRailBlockAt(world, i, j, k + 1)) {
                        return true;
                    }
                }
                case 3: {
                    if (TrackTools.isRailBlockAt(world, i, j, k - 1)) {
                        return true;
                    }
                }
                case 4: {
                    if (TrackTools.isRailBlockAt(world, i + 1, j, k)) {
                        return true;
                    }
                }
                case 5: {
                    if (!TrackTools.isRailBlockAt(world, i - 1, j, k)) break;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean pushMinecartOnSupportingBlockIfPossible(World world, int i, int j, int k, EntityMinecart minecart) {
        if (!world.func_72803_f(i, j, k).func_76220_a()) {
            switch (world.func_72805_g(i, j, k) & 7) {
                case 2: {
                    if (TrackTools.isRailBlockAt(world, i, j + 1, k + 1)) {
                        minecart.field_70181_x = 0.4;
                        minecart.field_70179_y = 0.4;
                    }
                    return true;
                }
                case 3: {
                    if (TrackTools.isRailBlockAt(world, i, j + 1, k - 1)) {
                        minecart.field_70181_x = 0.4;
                        minecart.field_70179_y = -0.4;
                    }
                    return true;
                }
                case 4: {
                    if (TrackTools.isRailBlockAt(world, i + 1, j + 1, k)) {
                        minecart.field_70181_x = 0.4;
                        minecart.field_70159_w = 0.4;
                    }
                    return true;
                }
                case 5: {
                    if (TrackTools.isRailBlockAt(world, i - 1, j + 1, k)) {
                        minecart.field_70181_x = 0.4;
                        minecart.field_70159_w = -0.4;
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean pushMinecartOntoRail(World world, int i, int j, int k, EntityMinecart cart) {
        cart.setCanUseRail(true);
        switch (world.func_72805_g(i, j, k) & 7) {
            case 2: {
                if (!TrackTools.isRailBlockAt(world, i, j, k - 1)) break;
                cart.func_70107_b(cart.field_70165_t, (double)((float)j + 0.6f), cart.field_70161_v);
                cart.field_70181_x = FALL_DOWN_CORRECTION;
                cart.field_70179_y = -0.4;
                return true;
            }
            case 3: {
                if (!TrackTools.isRailBlockAt(world, i, j, k + 1)) break;
                cart.func_70107_b(cart.field_70165_t, (double)((float)j + 0.6f), cart.field_70161_v);
                cart.field_70181_x = FALL_DOWN_CORRECTION;
                cart.field_70179_y = 0.4;
                return true;
            }
            case 4: {
                if (!TrackTools.isRailBlockAt(world, i - 1, j, k)) break;
                cart.func_70107_b(cart.field_70165_t, (double)((float)j + 0.6f), cart.field_70161_v);
                cart.field_70181_x = FALL_DOWN_CORRECTION;
                cart.field_70159_w = -0.4;
                return true;
            }
            case 5: {
                if (!TrackTools.isRailBlockAt(world, i + 1, j, k)) break;
                cart.func_70107_b(cart.field_70165_t, (double)((float)j + 0.6f), cart.field_70161_v);
                cart.field_70181_x = FALL_DOWN_CORRECTION;
                cart.field_70159_w = 0.4;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }
}

