/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackSwitchBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.Icon;

public class TrackWye
extends TrackSwitchBase {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.WYE;
    }

    @Override
    public Icon getIcon() {
        if (this.isSwitched()) {
            this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public int getBasicRailMetadata(EntityMinecart cart) {
        int meta = this.tileEntity.func_70322_n();
        if (cart != null) {
            if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                meta = this.isMirrored() ? (this.isSwitched() ? EnumTrackMeta.WEST_NORTH_CORNER.ordinal() : EnumTrackMeta.WEST_SOUTH_CORNER.ordinal()) : (this.isSwitched() ? EnumTrackMeta.EAST_SOUTH_CORNER.ordinal() : EnumTrackMeta.EAST_NORTH_CORNER.ordinal());
            } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
                meta = this.isMirrored() ? (this.isSwitched() ? EnumTrackMeta.EAST_NORTH_CORNER.ordinal() : EnumTrackMeta.WEST_NORTH_CORNER.ordinal()) : (this.isSwitched() ? EnumTrackMeta.WEST_SOUTH_CORNER.ordinal() : EnumTrackMeta.EAST_SOUTH_CORNER.ordinal());
            }
        }
        return meta;
    }

    @Override
    protected boolean shouldLockSwitch() {
        int x = this.tileEntity.field_70329_l;
        int y = this.tileEntity.field_70330_m;
        int z = this.tileEntity.field_70327_n;
        int meta = this.tileEntity.func_70322_n();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = this.isMirrored() ? --x : ++x;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isMirrored() ? ++z : --z;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    protected boolean shouldSpringSwitch() {
        int x = this.tileEntity.field_70329_l;
        int y = this.tileEntity.field_70330_m;
        int z = this.tileEntity.field_70327_n;
        int meta = this.tileEntity.func_70322_n();
        if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = this.isMirrored() ? ++x : --x;
        } else if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isMirrored() ? --z : ++z;
        }
        return CartTools.isMinecartOnRailAt(this.getWorld(), x, y, z, 0.3f);
    }

    @Override
    public ITrackSwitch.ArrowDirection getRedSignDirection() {
        if (EnumTrackMeta.EAST_WEST.isEqual(this.tileEntity.func_70322_n())) {
            if (this.isSwitched()) {
                if (this.isMirrored()) {
                    return ITrackSwitch.ArrowDirection.WEST;
                }
                return ITrackSwitch.ArrowDirection.EAST;
            }
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.EAST;
            }
            return ITrackSwitch.ArrowDirection.WEST;
        }
        if (this.isSwitched()) {
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.NORTH;
            }
            return ITrackSwitch.ArrowDirection.SOUTH;
        }
        if (this.isMirrored()) {
            return ITrackSwitch.ArrowDirection.SOUTH;
        }
        return ITrackSwitch.ArrowDirection.NORTH;
    }

    @Override
    public ITrackSwitch.ArrowDirection getWhiteSignDirection() {
        if (EnumTrackMeta.EAST_WEST.isEqual(this.tileEntity.func_70322_n())) {
            if (this.isMirrored()) {
                return ITrackSwitch.ArrowDirection.NORTH;
            }
            return ITrackSwitch.ArrowDirection.SOUTH;
        }
        if (this.isMirrored()) {
            return ITrackSwitch.ArrowDirection.EAST;
        }
        return ITrackSwitch.ArrowDirection.WEST;
    }
}

