/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.misc.APIErrorHandler;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.IEnergyDevice;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class EntityCartEnergy
extends CartContainerBase
implements IEnergyDevice,
IEnergyTransfer {
    private static final int ENERGY_DATA_ID = 25;
    private int update;

    public EntityCartEnergy(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)new Integer(0));
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack stack = this.getIC2Item();
        if (RailcraftConfig.doCartsBreakOnDrop() && stack != null) {
            items.add(new ItemStack(Item.field_77773_az));
            items.add(stack);
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    public void func_70071_h_() {
        ItemStack stack;
        ++this.update;
        super.func_70071_h_();
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        if (this.getEnergy() > this.getCapacity()) {
            this.setEnergy(this.getCapacity());
        }
        if (IC2Plugin.isEnergyItem(stack = this.func_70301_a(0)) && this.getEnergy() > 0) {
            this.setEnergy(this.getEnergy() - IC2Plugin.chargeItem(stack, this.getEnergy(), this.getTier()));
        }
        if (IC2Plugin.isEnergyItem(stack = this.func_70301_a(1)) && this.getEnergy() < this.getCapacity()) {
            this.setEnergy(this.getEnergy() + IC2Plugin.dischargeItem(stack, this.getCapacity() - this.getEnergy(), this.getTier()));
        }
    }

    @Override
    public abstract int getTier();

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            GuiHandler.openGui(EnumGui.CART_ENERGY, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }

    public int func_70302_i_() {
        return 2;
    }

    public abstract String func_70303_b();

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setEnergy(nbttagcompound.func_74762_e("energy"));
        this.update = MiscTools.getRand().nextInt();
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("energy", this.getEnergy());
    }

    @Override
    public int injectEnergy(Object source, int amount, int tier, boolean ignoreTransferLimit, boolean simulate, boolean passAlong) {
        int capacity;
        int energy;
        if (tier < this.getTier()) {
            return amount;
        }
        int extra = 0;
        if (!ignoreTransferLimit) {
            extra = Math.max(amount - this.getTransferLimit(), 0);
            amount = Math.min(amount, this.getTransferLimit());
        }
        if ((energy = this.getEnergy() + amount) > (capacity = this.getCapacity())) {
            extra += energy - capacity;
            energy = capacity;
        }
        if (!simulate) {
            this.setEnergy(energy);
        }
        if (!passAlong) {
            return extra;
        }
        try {
            ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
            EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
            if (extra > 0 && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
                extra = ((IEnergyTransfer)linkedCart).injectEnergy(this, extra, tier, ignoreTransferLimit, simulate, true);
            }
            linkedCart = lm.getLinkedCartB((EntityMinecart)this);
            if (extra > 0 && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
                extra = ((IEnergyTransfer)linkedCart).injectEnergy(this, extra, tier, ignoreTransferLimit, simulate, true);
            }
        }
        catch (Throwable t) {
            APIErrorHandler.versionMismatch(IEnergyTransfer.class);
        }
        return extra;
    }

    @Override
    public int extractEnergy(Object source, int amount, int tier, boolean ignoreTransferLimit, boolean simulate, boolean passAlong) {
        if (tier < this.getTier()) {
            return 0;
        }
        if (!ignoreTransferLimit) {
            amount = Math.min(amount, this.getTransferLimit());
        }
        int provide = 0;
        int energy = this.getEnergy();
        if ((energy -= (provide = Math.min(amount, energy))) < 0) {
            energy = 0;
        }
        if (!simulate) {
            this.setEnergy(energy);
        }
        if (!passAlong) {
            return provide;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.field_70170_p);
        EntityMinecart linkedCart = lm.getLinkedCartA((EntityMinecart)this);
        if (provide < amount && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
            provide += ((IEnergyTransfer)linkedCart).extractEnergy(this, amount - provide, tier, ignoreTransferLimit, simulate, true);
        }
        linkedCart = lm.getLinkedCartB((EntityMinecart)this);
        if (provide < amount && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
            provide += ((IEnergyTransfer)linkedCart).extractEnergy(this, amount - provide, tier, ignoreTransferLimit, simulate, true);
        }
        return provide;
    }

    public abstract ItemStack getIC2Item();

    public Block func_94093_n() {
        ItemStack stack = this.getIC2Item();
        if (stack != null) {
            return Block.field_71973_m[stack.field_77993_c];
        }
        return super.func_94093_n();
    }

    public int func_94098_o() {
        ItemStack stack = this.getIC2Item();
        if (stack != null) {
            return stack.func_77960_j();
        }
        return 0;
    }

    @Override
    public abstract int getCapacity();

    @Override
    public abstract int getTransferLimit();

    @Override
    public int getEnergyBarScaled(int scale) {
        return this.getEnergy() * scale / this.getCapacity();
    }

    @Override
    public int getEnergy() {
        return this.field_70180_af.func_75679_c(25);
    }

    protected void setEnergy(int energy) {
        this.field_70180_af.func_75692_b(25, (Object)energy);
    }

    @Override
    public boolean canExtractEnergy() {
        return true;
    }

    @Override
    public boolean canInjectEnergy() {
        return true;
    }
}

