/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.indicator.IIndicatorController;
import mods.railcraft.common.gui.util.ToolTip;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.liquids.LiquidFilter;
import mods.railcraft.common.liquids.LiquidItems;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.FilteredTank;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryCopy;
import mods.railcraft.common.util.inventory.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class EntityLocomotiveSteam
extends EntityLocomotive
implements ITankContainer,
ISpecialInventory {
    private static final String[] TEXTURES = new String[]{"/mods/railcraft/textures/entities/carts/loco_steam_1.png", "/mods/railcraft/textures/entities/carts/loco_steam_2.png", "/mods/railcraft/textures/entities/carts/loco_steam_3.png"};
    private static final String WHISTLE_SOUND = "locomotive.steam.whistle";
    private static final byte TICKS_PER_CONVERSION = 2;
    private static final int FUEL_PER_REQUEST = 3;
    private static final int INEFFICENCY_MULTIPLIER = 4;
    private static final int TANK_WATER = 0;
    private static final int SLOT_LIQUID_INPUT = 0;
    private static final int SLOT_LIQUID_OUTPUT = 1;
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    public static final byte SMOKE_FLAG = 6;
    public static final byte STEAM_FLAG = 7;
    private TankManager tankManager;
    private StandardTank tankWater;
    private StandardTank tankSteam;
    private IInventory invAll = new InventoryMapper(this);
    private InventoryMapper invWaterInput;
    private IInventory invWaterOutput = new InventoryMapper(this, 1, 1);
    private IInventory invBurn = new InventoryMapper(this, 2, 1);
    private IInventory invStock = new InventoryMapper(this, 3, 3);
    private IInventory invFuel = new InventoryMapper(this, 2, 4);
    private int burnCycle;
    private int update = this.field_70146_Z.nextInt();
    public float heat = 20.0f;
    public float burnTime;
    public float currentItemBurnTime;
    private IIndicatorController heatIndicator = new HeatIndicator();

    public IIndicatorController getHeatIndicator() {
        return this.heatIndicator;
    }

    public EntityLocomotiveSteam(World world) {
        super(world);
    }

    public EntityLocomotiveSteam(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.tankManager = new TankManager();
        this.tankWater = new FilteredTank(6000, LiquidFilter.WATER);
        this.tankSteam = new FilteredTank(16000, LiquidFilter.STEAM);
        this.tankManager.addTank(this.tankWater);
        this.tankManager.addTank(this.tankSteam);
        this.invWaterInput = new InventoryMapper(this, 0, 1);
        this.invWaterInput.setStackSizeLimit(4);
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return ItemCart.getCartType(stack) == EnumCart.LOCO_STEAM;
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public String getWhistle() {
        return WHISTLE_SOUND;
    }

    @Override
    protected ItemStack getCartItemBase() {
        return EnumCart.LOCO_STEAM.getCartItem();
    }

    public String func_70303_b() {
        return RailcraftLanguage.translate(EnumCart.LOCO_STEAM.getTag());
    }

    @Override
    public int func_70302_i_() {
        return 6;
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int getBurnProgressScaled(int i) {
        if (this.burnTime <= 0.0f || this.currentItemBurnTime <= 0.0f) {
            return 0;
        }
        int scale = (int)(this.burnTime * (float)i / this.currentItemBurnTime);
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    private int getFuelPerConversion() {
        float fuelUsed = 6.4f;
        fuelUsed += fuelUsed * (4.0f - 4.0f * this.getHeatLevel());
        return Math.round(fuelUsed);
    }

    public float getHeatLevel() {
        return this.heat / 500.0f;
    }

    private void increaseHeat() {
        float heatLevel = this.getHeatLevel();
        this.heat += 0.05f;
        if (heatLevel < 0.25f) {
            this.heat += 0.05f;
        }
        if (heatLevel < 0.5f) {
            this.heat += 0.05f;
        }
        if (heatLevel < 0.75f) {
            this.heat += 0.05f;
        }
        this.heat = Math.min(this.heat, 500.0f);
    }

    private void reduceHeat() {
        float heatLevel = this.getHeatLevel();
        this.heat -= 0.05f;
        if (heatLevel > 0.25f) {
            this.heat -= 0.05f;
        }
        if (heatLevel > 0.5f) {
            this.heat -= 0.05f;
        }
        if (heatLevel > 0.75f) {
            this.heat -= 0.05f;
        }
        this.heat = Math.max(this.heat, 20.0f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isHost(this.field_70170_p)) {
            LiquidStack steam;
            ++this.update;
            InvTools.moveOneItem(this.invStock, this.invBurn);
            InvTools.moveOneItem(this.invBurn, this.invWaterOutput, LiquidContainerRegistry.EMPTY_BUCKET);
            LiquidStack water = this.tankWater.getLiquid();
            if (water == null || water.amount <= 0) {
                this.setMode(EntityLocomotive.LocoMode.SHUTDOWN);
            }
            this.setSteaming((steam = this.tankSteam.getLiquid()) != null && steam.amount > 0);
            if (steam == null || this.tankSteam.getCapacity() - steam.amount >= 160 || this.isShutdown()) {
                ++this.burnCycle;
                if (this.burnCycle >= 2) {
                    LiquidStack drainedWater;
                    boolean addedFuel;
                    this.burnCycle = 0;
                    float fuelNeeded = this.getFuelPerConversion();
                    while (this.burnTime < fuelNeeded && (addedFuel = this.addSolidFuel())) {
                    }
                    this.burnTime -= fuelNeeded;
                    if (this.burnTime <= 0.0f) {
                        this.burnTime = 0.0f;
                    }
                    if (this.heat >= 100.0f && (drainedWater = this.tankWater.drain(1, false)) != null) {
                        this.tankWater.drain(1, true);
                        steam = LiquidItems.getSteamLiquid(160);
                        this.tankSteam.fill(steam, true);
                    }
                }
                this.setSmoking(this.burnTime > 0.0f);
                if (this.burnTime > 0.0f) {
                    this.increaseHeat();
                } else {
                    this.reduceHeat();
                    this.ventSteam();
                }
            }
            if (this.update % 8 == 0) {
                LiquidManager.instance().processContainers(this, 0, this, 0, 1, true, false);
            }
        } else {
            if (this.isSmoking() && this.field_70146_Z.nextInt(3) == 0) {
                double rads = (double)this.renderYaw * Math.PI / 180.0;
                float offset = 0.4f;
                this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t - Math.cos(rads) * (double)offset, this.field_70163_u + (double)1.2f, this.field_70161_v - Math.sin(rads) * (double)offset, 0.0, 0.0, 0.0);
            }
            if (this.isSteaming()) {
                EffectManager.instance.steamEffect(this.field_70170_p, this, this.field_70121_D.field_72338_b - this.field_70163_u - 0.3);
            }
        }
    }

    private void setSmoking(boolean smoke) {
        if (this.func_70083_f(6) != smoke) {
            this.func_70052_a(6, smoke);
        }
    }

    public boolean isSmoking() {
        return this.func_70083_f(6);
    }

    private void setSteaming(boolean steam) {
        if (this.func_70083_f(7) != steam) {
            this.func_70052_a(7, steam);
        }
    }

    public boolean isSteaming() {
        return this.func_70083_f(7);
    }

    private void ventSteam() {
        this.tankSteam.drain(4, true);
    }

    private boolean addSolidFuel() {
        if (this.isShutdown()) {
            return false;
        }
        int newFuel = this.getMoreSoildFuel();
        this.burnTime += (float)newFuel;
        this.currentItemBurnTime = this.burnTime;
        return newFuel > 0;
    }

    private int getMoreSoildFuel() {
        ItemStack burnable = this.func_70301_a(2);
        int burn = FuelPlugin.getBurnTime(burnable);
        if (burn > 0) {
            this.func_70299_a(2, InvTools.depleteItem(burnable));
        }
        return burn;
    }

    @Override
    public int getMoreGoJuice() {
        LiquidStack steam = this.tankSteam.getLiquid();
        if (steam != null && steam.amount >= this.tankSteam.getCapacity() / 2) {
            this.tankSteam.drain(160, true);
            return 3;
        }
        return 0;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (super.doInteract(player)) {
            return true;
        }
        if (Game.isHost(this.getWorld())) {
            if (LiquidManager.instance().handleRightClick(this, 0, player, true, false)) {
                return true;
            }
            GuiHandler.openGui(EnumGui.LOCO_STEAM, player, this.field_70170_p, (Entity)this);
        }
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        this.tankManager.writeTanksToNBT(data);
        data.func_74776_a("heat", this.heat);
        data.func_74776_a("burnTime", this.burnTime);
        data.func_74776_a("currentItemBurnTime", this.currentItemBurnTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.tankManager.readTanksFromNBT(data);
        this.heat = data.func_74760_g("heat");
        this.burnTime = data.func_74760_g("burnTime");
        this.currentItemBurnTime = data.func_74760_g("currentItemBurnTime");
    }

    @Override
    public String[] getLocomotiveTextures() {
        return TEXTURES;
    }

    public boolean isSafeToFill() {
        return this.heat < 300.0f || !this.tankWater.isEmpty();
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        LiquidStack water;
        if (doFill && LiquidFilter.WATER.isLiquidEqual(resource) && this.heat >= 300.0f && ((water = this.tankWater.getLiquid()) == null || water.amount <= 0)) {
            this.explode();
        }
        return this.tankWater.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return this.tankManager.getTanks();
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tankWater;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case 0: {
                return LiquidManager.instance().containsLiquid(stack, LiquidFilter.WATER);
            }
        }
        return false;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        if (FuelPlugin.getBurnTime(stack) > 0) {
            ItemStack remainder;
            IInventory inv = this.invFuel;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.field_77994_a;
            }
            return stack.field_77994_a - remainder.field_77994_a;
        }
        if (LiquidManager.instance().containsLiquid(stack, LiquidFilter.WATER)) {
            ItemStack remainder;
            Object inv = this.invWaterInput;
            if (!doAdd) {
                inv = new InventoryCopy((IInventory)inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.field_77994_a;
            }
            return stack.field_77994_a - remainder.field_77994_a;
        }
        return 0;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        IInventory inv = this.invAll;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }

    private class HeatIndicator
    implements IIndicatorController {
        List tips = new ArrayList();
        ToolTip tip = new ToolTip();

        private HeatIndicator() {
            this.tips.add(this.tip);
        }

        @Override
        public List getToolTip() {
            this.tip.text = String.format("%.0f\u00b0C", Float.valueOf(EntityLocomotiveSteam.this.heat));
            return this.tips;
        }

        @Override
        public int getScaledLevel(int size) {
            return (int)((EntityLocomotiveSteam.this.heat - 20.0f) * (float)size / 480.0f);
        }
    }
}

