/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.List;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class LocomotivePaintingRecipe
implements IRecipe {
    private static List[] dyes = new List[16];
    private final ItemStack locomotive;

    public LocomotivePaintingRecipe(ItemStack locomotive) {
        this.locomotive = locomotive;
    }

    private boolean isDye(ItemStack stack) {
        return this.getDye(stack) != -1;
    }

    private int getDye(ItemStack stack) {
        for (int id = 0; id < 16; ++id) {
            if (!InvTools.isItemEqual(stack, dyes[id])) continue;
            return id;
        }
        return -1;
    }

    private boolean isLocomotive(ItemStack loco) {
        return InvTools.isItemEqualIgnoreNBT(this.locomotive, loco);
    }

    public boolean func_77569_a(InventoryCrafting craftingGrid, World var2) {
        if (craftingGrid.func_70302_i_() < this.func_77570_a()) {
            return false;
        }
        ItemStack dyePrimary = craftingGrid.func_70463_b(1, 0);
        if (!this.isDye(dyePrimary)) {
            return false;
        }
        ItemStack cart = craftingGrid.func_70463_b(1, 1);
        if (!this.isLocomotive(cart)) {
            return false;
        }
        ItemStack dyeSecondary = craftingGrid.func_70463_b(1, 2);
        return this.isDye(dyeSecondary);
    }

    public ItemStack func_77572_b(InventoryCrafting craftingGrid) {
        ItemStack result = this.func_77571_b().func_77946_l();
        ItemStack dyePrimary = craftingGrid.func_70463_b(1, 0);
        ItemStack dyeSecondary = craftingGrid.func_70463_b(1, 2);
        ItemLocomotive.setItemColorData(result, this.getDye(dyePrimary), this.getDye(dyeSecondary));
        return result;
    }

    public int func_77570_a() {
        return 9;
    }

    public ItemStack func_77571_b() {
        return this.locomotive;
    }

    static {
        for (int id = 0; id < 16; ++id) {
            LocomotivePaintingRecipe.dyes[id] = OreDictionary.getOres((String)EnumColor.DYES[id]);
        }
    }
}

