/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import java.util.List;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.items.ItemMaterials;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IArmorTextureProvider;

public class ItemGoggles
extends ItemArmor
implements IArmorTextureProvider {
    private static final String TEXTURE = "/mods/railcraft/textures/entities/armor/goggles.png";
    private static ItemGoggles item;

    public static void registerItem() {
        String tag;
        int id;
        if (item == null && (id = RailcraftConfig.getItemId(tag = "railcraft.armor.goggles")) > 0) {
            item = new ItemGoggles(id);
            item.func_77655_b(tag);
            RailcraftLanguage.instance().registerItemName((Object)item, tag);
            CraftingPlugin.addShapedOreRecipe(new ItemStack((Item)item), true, "GCG", "I I", "LLL", Character.valueOf('C'), ItemCircuit.getReceiverCircuit(), Character.valueOf('I'), "ingotSteel", Character.valueOf('L'), Item.field_77770_aF, Character.valueOf('G'), new ItemStack(Block.field_72003_bq));
            ItemRegistry.registerItem(tag, new ItemStack((Item)item));
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    public static Aura getCurrentAura(ItemStack goggles) {
        NBTTagCompound data;
        Aura aura = Aura.NONE;
        if (goggles != null && goggles.func_77973_b() instanceof ItemGoggles && (data = goggles.func_77978_p()) != null) {
            aura = Aura.AURAS[data.func_74771_c("aura")];
        }
        return aura;
    }

    public static void incrementAura(ItemStack goggles) {
        if (goggles != null && goggles.func_77973_b() instanceof ItemGoggles) {
            NBTTagCompound data = goggles.func_77978_p();
            if (data == null) {
                data = new NBTTagCompound("tag");
                goggles.func_77982_d(data);
            }
            byte aura = data.func_74771_c("aura");
            if ((aura = (byte)(aura + 1)) >= Aura.AURAS.length) {
                aura = 0;
            }
            data.func_74774_a("aura", aura);
        }
    }

    public static boolean areEnabled() {
        return item != null;
    }

    public static ItemStack getGoggles(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        ItemStack helm = player.func_71124_b(4);
        if (helm != null && helm.func_77973_b() instanceof ItemGoggles) {
            return helm;
        }
        return null;
    }

    public static boolean isPlayerWearing(EntityPlayer player) {
        ItemStack helm = player.func_71124_b(4);
        return helm != null && helm.func_77973_b() instanceof ItemGoggles;
    }

    public ItemGoggles(int id) {
        super(id, ItemMaterials.GOGGLES, 0, 0);
        this.func_77637_a(CreativePlugin.TAB);
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemGoggles.incrementAura(stack);
        if (Game.isNotHost(world)) {
            Aura aura = ItemGoggles.getCurrentAura(stack);
            String mode = RailcraftLanguage.translate("gui.goggles.mode");
            player.func_71035_c(String.format(mode, "\u00a75" + (Object)((Object)aura)));
        }
        return stack.func_77946_l();
    }

    public String getArmorTextureFile(ItemStack itemstack) {
        return TEXTURE;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return MiscTools.isOreClass(stack, "ingotSteel");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        NBTTagCompound data = stack.func_77978_p();
        Aura aura = ItemGoggles.getCurrentAura(stack);
        String mode = RailcraftLanguage.translate("gui.goggles.mode");
        String tip = RailcraftLanguage.translate("gui.goggles.tip");
        list.add(String.format(mode, "\u00a75" + (Object)((Object)aura)));
        list.add(tip);
    }

    public static enum Aura {
        NONE("gui.goggles.aura.none"),
        ANCHOR("gui.goggles.aura.anchor"),
        TUNING("gui.goggles.aura.tuning");

        public static final Aura[] AURAS;
        private String name;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Aura() {
            void name;
            this.name = name;
        }

        public String toString() {
            return RailcraftLanguage.translate(this.name);
        }

        static {
            AURAS = new Aura[]{NONE, ANCHOR, TUNING};
        }
    }
}

