/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.client.gui.GuiRoutingTable;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IEditableItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemRoutingTable
extends ItemRailcraft
implements IEditableItem {
    public static final int LINE_LENGTH = 37;
    public static final int LINES_PER_PAGE = 13;
    public static ItemRoutingTable item;

    public static void registerItem() {
        String tag;
        int id;
        if (item == null && (id = RailcraftConfig.getItemId(tag = "railcraft.routing.table")) > 0) {
            item = new ItemRoutingTable(id);
            item.func_77655_b(tag);
            RailcraftLanguage.instance().registerItemName(item, tag);
            CraftingPlugin.addShapelessOreRecipe(new ItemStack((Item)item), Item.field_77821_bF, "dyeBlue");
            ItemRegistry.registerItem(tag, new ItemStack((Item)item));
        }
    }

    @Override
    public boolean validateNBT(NBTTagCompound nbt) {
        return ItemRoutingTable.validBookTagContents(nbt);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemRoutingTable.validBookTagPages(nbt)) {
            return false;
        }
        if (!nbt.func_74764_b("title")) {
            return false;
        }
        String s = nbt.func_74779_i("title");
        return s != null && s.length() <= 16 ? nbt.func_74764_b("author") : false;
    }

    public static boolean validBookTagPages(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_74764_b("pages")) {
            return false;
        }
        NBTTagList pages = (NBTTagList)nbt.func_74781_a("pages");
        for (int pageNum = 0; pageNum < pages.func_74745_c(); ++pageNum) {
            NBTTagList page = (NBTTagList)pages.func_74743_b(pageNum);
            if (page.func_74745_c() > 13) {
                return false;
            }
            for (int lineNum = 0; lineNum < page.func_74745_c(); ++lineNum) {
                NBTTagString line = (NBTTagString)page.func_74743_b(lineNum);
                if (line.field_74751_a == null) {
                    return false;
                }
                if (line.field_74751_a.length() <= 37) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean matches(String destString, ItemStack routingTable) {
        if (routingTable == null || destString == null || routingTable.field_77993_c != ItemRoutingTable.item.field_77779_bT) {
            return false;
        }
        NBTTagCompound nbt = routingTable.func_77978_p();
        if (nbt == null) {
            return false;
        }
        NBTTagList pages = (NBTTagList)nbt.func_74781_a("pages");
        for (int pageNum = 0; pageNum < pages.func_74745_c(); ++pageNum) {
            NBTTagList page = (NBTTagList)pages.func_74743_b(pageNum);
            for (int lineNum = 0; lineNum < page.func_74745_c(); ++lineNum) {
                NBTTagString line = (NBTTagString)page.func_74743_b(lineNum);
                if (line.field_74751_a == null || !destString.startsWith(line.field_74751_a)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemRoutingTable(int id) {
        super(id);
        this.func_77637_a(CreativePlugin.TAB);
    }

    @Override
    public String getOwner(ItemStack ticket) {
        if (ticket == null || !(ticket.func_77973_b() instanceof ItemTicket)) {
            return "";
        }
        NBTTagCompound nbt = ticket.func_77978_p();
        if (nbt == null) {
            return "";
        }
        return nbt.func_74779_i("author");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:routing.table");
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound nbt;
        NBTTagString title;
        if (stack.func_77942_o() && (title = (NBTTagString)(nbt = stack.func_77978_p()).func_74781_a("title")) != null) {
            return super.func_77628_j(stack) + " - " + title.toString();
        }
        return super.func_77628_j(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        NBTTagCompound nbt;
        NBTTagString author;
        if (stack.func_77942_o() && (author = (NBTTagString)(nbt = stack.func_77978_p()).func_74781_a("author")) != null) {
            list.add(EnumChatFormatting.GRAY + String.format(RailcraftLanguage.translate("gui.routing.table.editor"), author.field_74751_a));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (Game.isNotHost(world)) {
            Minecraft.func_71410_x().func_71373_a((GuiScreen)new GuiRoutingTable(player, stack));
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }
}

