/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.lang;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.util.StringTranslate;

public class RailcraftLanguage {
    public static final String ENGLISH = "en_US";
    private Map languageTable = new TreeMap();
    private static RailcraftLanguage instance;

    public RailcraftLanguage() {
        this.loadDefaultLanguage(ENGLISH, "");
        this.loadDefaultLanguage("en_GB", ENGLISH);
        this.loadDefaultLanguage("de_DE", ENGLISH);
        this.loadDefaultLanguage("pt_PT", ENGLISH);
        this.loadDefaultLanguage("pt_BR", "pt_PT");
        this.loadDefaultLanguage("es_ES", ENGLISH);
        this.loadDefaultLanguage("es_AR", "es_ES");
        this.loadDefaultLanguage("es_MX", "es_ES");
        this.loadDefaultLanguage("es_UY", "es_ES");
        this.loadDefaultLanguage("es_VE", "es_ES");
        this.loadDefaultLanguage("ru_RU", ENGLISH);
        this.loadDefaultLanguage("fr_FR", ENGLISH);
        this.loadDefaultLanguage("ja_JP", ENGLISH);
        this.loadDefaultLanguage("it_IT", ENGLISH);
        this.loadDefaultLanguage("zh_TW", ENGLISH);
        this.loadDefaultLanguage("zh_CN", "zh_TW");
        this.loadDefaultLanguage("nl_NL", ENGLISH);
        this.loadDefaultLanguage("pl_PL", ENGLISH);
        this.loadDefaultLanguage("hr_HR", ENGLISH);
        this.loadDefaultLanguage("no_NO", ENGLISH);
        File langFolder = new File(Railcraft.getMod().getConfigFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (File file : langFolder.listFiles()) {
            String lang = file.getName();
            lang = lang.replace(".lang", "");
            this.loadCustomLanguage(file, lang);
        }
    }

    public static RailcraftLanguage instance() {
        if (instance == null) {
            instance = new RailcraftLanguage();
        }
        return instance;
    }

    public static String translate(String tag) {
        return RailcraftLanguage.instance().translate_do(tag);
    }

    private String translate_do(String tag) {
        String lang = StringTranslate.func_74808_a().func_74811_c();
        return this.translate(tag, lang);
    }

    public static boolean hasTag(String tag) {
        return RailcraftLanguage.instance().hasTag_do(tag);
    }

    private boolean hasTag_do(String tag) {
        String lang = StringTranslate.func_74808_a().func_74811_c();
        return this.hasTag(tag, lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultLanguage(String lang, String parent) {
        Properties langFile = new Properties((Properties)this.languageTable.get(parent));
        InputStreamReader reader = null;
        try {
            InputStream inStream = this.getClass().getResourceAsStream(lang + ".lang");
            if (inStream == null) {
                throw new IOException();
            }
            reader = new InputStreamReader(inStream, "UTF-8");
            langFile.load(reader);
        }
        catch (IOException ex) {
            Game.log(Level.WARNING, "Default language file not found: {0}", lang);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {}
        }
        this.languageTable.put(lang, langFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomLanguage(File file, String lang) {
        Properties parent = (Properties)this.languageTable.get(lang);
        if (parent == null) {
            parent = (Properties)this.languageTable.get(ENGLISH);
        }
        Properties langFile = new Properties(parent);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            langFile.load(reader);
            Game.log(Level.INFO, "Custom language file loaded: {0}", lang);
        }
        catch (IOException ex) {
            Game.log(Level.INFO, "Custom language file could not be opened: {0}", lang);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {}
        }
        this.languageTable.put(lang, langFile);
    }

    public String translate(String tag, String lang) {
        String value;
        tag = MiscTools.cleanTag(tag);
        Properties languageSet = (Properties)this.languageTable.get(lang);
        if (languageSet == null) {
            languageSet = (Properties)this.languageTable.get(ENGLISH);
        }
        if ((value = languageSet.getProperty(tag)) == null) {
            Game.log(Level.WARNING, "Language Tag is unknown: {0}, {1}", lang, tag);
            return tag;
        }
        return value;
    }

    public boolean hasTag(String tag, String lang) {
        String value;
        tag = MiscTools.cleanTag(tag);
        Properties languageSet = (Properties)this.languageTable.get(lang);
        if (languageSet == null) {
            languageSet = (Properties)this.languageTable.get(ENGLISH);
        }
        return (value = languageSet.getProperty(tag)) != null;
    }

    public void registerItemName(Object o, String tag) {
        tag = MiscTools.cleanTag(tag);
        for (String lang : this.languageTable.keySet()) {
            LanguageRegistry.instance().addNameForObject(o, lang, this.translate(tag, lang));
        }
    }

    public void registerDepreciatedItemName(Object o, String tag) {
        tag = MiscTools.cleanTag(tag);
        for (String lang : this.languageTable.keySet()) {
            LanguageRegistry.instance().addNameForObject(o, lang, this.translate(tag, lang) + " (" + this.translate("obsolete", lang) + ")");
        }
    }
}

