/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.liquids;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.lang.RailcraftLanguage;
import mods.railcraft.common.liquids.ItemLiquid;
import mods.railcraft.common.liquids.ItemLiquidContainer;
import mods.railcraft.common.liquids.LiquidManager;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.LootPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidItems {
    public static final LiquidItems INSTANCE = new LiquidItems();
    private static LiquidStack liquidCreosoteOil;
    private static LiquidStack liquidSteam;
    private static Item itemCreosoteOil;
    private static Item itemSteam;
    private static Item itemCreosoteOilBucket;
    private static Item itemCreosoteOilBottle;
    private static Item itemSteamBottle;
    private static ItemLiquidContainer itemCreosoteOilCell;
    private static ItemLiquidContainer itemCreosoteOilCan;
    private static ItemLiquidContainer itemCreosoteOilWax;
    private static ItemLiquidContainer itemCreosoteOilRefactory;

    private LiquidItems() {
    }

    public static void initialize() {
        LiquidItems.initCreosoteOil();
        LiquidItems.initSteam();
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map == Minecraft.func_71410_x().field_71446_o.field_94155_m) {
            LiquidDictionary.getCanonicalLiquid((String)"Steam").setRenderingIcon(itemSteam.func_77617_a(0)).setTextureSheet("/gui/items.png");
            LiquidDictionary.getCanonicalLiquid((String)"Creosote Oil").setRenderingIcon(itemCreosoteOil.func_77617_a(0)).setTextureSheet("/gui/items.png");
        }
    }

    public static ItemStack getCreosoteOil() {
        LiquidItems.initCreosoteOil();
        return new ItemStack(itemCreosoteOil);
    }

    private static void initCreosoteOil() {
        if (itemCreosoteOil == null) {
            String tag = "railcraft.liquid.creosote.liquid";
            int id = RailcraftConfig.getItemId(tag);
            Item item = new ItemLiquid(id).setRarity(1).func_77655_b(tag);
            GameRegistry.registerItem((Item)item, (String)tag);
            RailcraftLanguage.instance().registerItemName(item, tag);
            liquidCreosoteOil = LiquidDictionary.getOrCreateLiquid((String)"Creosote Oil", (LiquidStack)new LiquidStack(item.field_77779_bT, 0));
            ItemRegistry.registerItem(tag, new ItemStack(item));
            LiquidStack liquid = liquidCreosoteOil.copy();
            liquid.amount = 1000;
            FuelManager.addBoilerFuel(liquid, 4800);
            itemCreosoteOil = item;
        }
    }

    public static LiquidStack getCreosoteOilLiquid(int qty) {
        LiquidItems.initCreosoteOil();
        LiquidStack liquid = liquidCreosoteOil.copy();
        liquid.amount = qty;
        return liquid;
    }

    public static ItemStack getCreosoteOilBucket() {
        Item item = itemCreosoteOilBucket;
        if (item == null) {
            String tag = "railcraft.liquid.creosote.bucket";
            int id = RailcraftConfig.getItemId(tag);
            item = new ItemLiquidContainer(id).func_77655_b(tag).func_77625_d(1).func_77642_a(Item.field_77788_aw).func_77637_a(CreativePlugin.TAB);
            GameRegistry.registerItem((Item)item, (String)tag);
            RailcraftLanguage.instance().registerItemName(item, tag);
            LiquidManager.instance().registerBucket(LiquidItems.getCreosoteOilLiquid(1000), new ItemStack(item));
            ItemRegistry.registerItem(tag, new ItemStack(item));
            itemCreosoteOilBucket = item;
        }
        return new ItemStack(item);
    }

    public static ItemStack getCreosoteOilBottle() {
        return LiquidItems.getCreosoteOilBottle(1);
    }

    public static ItemStack getCreosoteOilBottle(int qty) {
        Item item = itemCreosoteOilBottle;
        if (item == null) {
            String tag = "railcraft.liquid.creosote.bottle";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id).func_77655_b(tag).func_77637_a(CreativePlugin.TAB);
                GameRegistry.registerItem((Item)item, (String)tag);
                RailcraftLanguage.instance().registerItemName(item, tag);
                LootPlugin.addLootMineshaft(new ItemStack(item), 4, 16, "creosote.bottle");
                LiquidManager.instance().registerBottle(LiquidItems.getCreosoteOilLiquid(1000), new ItemStack(item));
                ItemRegistry.registerItem(tag, new ItemStack(item));
                itemCreosoteOilBottle = item;
            } else {
                return null;
            }
        }
        return new ItemStack(item, qty);
    }

    public static ItemStack getCreosoteOilCan() {
        return LiquidItems.getCreosoteOilCan(1);
    }

    public static ItemStack getCreosoteOilCan(int qty) {
        ItemLiquidContainer item = itemCreosoteOilCan;
        if (item == null) {
            String tag = "railcraft.liquid.creosote.can";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.func_77655_b(tag);
                GameRegistry.registerItem((Item)item, (String)tag);
                RailcraftLanguage.instance().registerItemName((Object)item, tag);
                boolean forestry = LiquidManager.instance().registerCan(LiquidItems.getCreosoteOilLiquid(1000), new ItemStack((Item)item));
                if (forestry) {
                    item.func_77637_a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ItemStack((Item)item));
                itemCreosoteOilCan = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getCreosoteOilWax() {
        return LiquidItems.getCreosoteOilWax(1);
    }

    public static ItemStack getCreosoteOilWax(int qty) {
        ItemLiquidContainer item = itemCreosoteOilWax;
        if (item == null) {
            String tag = "railcraft.liquid.creosote.wax";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.func_77655_b(tag);
                GameRegistry.registerItem((Item)item, (String)tag);
                RailcraftLanguage.instance().registerItemName((Object)item, tag);
                boolean forestry = LiquidManager.instance().registerWax(LiquidItems.getCreosoteOilLiquid(1000), new ItemStack((Item)item));
                if (forestry) {
                    item.func_77637_a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ItemStack((Item)item));
                itemCreosoteOilWax = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getCreosoteOilRefactory() {
        return LiquidItems.getCreosoteOilRefactory(1);
    }

    public static ItemStack getCreosoteOilRefactory(int qty) {
        ItemLiquidContainer item = itemCreosoteOilRefactory;
        if (item == null) {
            String tag = "railcraft.liquid.creosote.refactory";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.func_77655_b(tag);
                GameRegistry.registerItem((Item)item, (String)tag);
                RailcraftLanguage.instance().registerItemName((Object)item, tag);
                boolean forestry = LiquidManager.instance().registerRefactory(LiquidItems.getCreosoteOilLiquid(1000), new ItemStack((Item)item));
                if (forestry) {
                    item.func_77637_a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ItemStack((Item)item));
                itemCreosoteOilRefactory = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getCreosoteOilCell() {
        return LiquidItems.getCreosoteOilCell(1);
    }

    public static ItemStack getCreosoteOilCell(int qty) {
        ItemLiquidContainer item = itemCreosoteOilCell;
        if (item == null) {
            String tag = "railcraft.liquid.creosote.cell";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.func_77655_b(tag);
                GameRegistry.registerItem((Item)item, (String)tag);
                RailcraftLanguage.instance().registerItemName((Object)item, tag);
                boolean ic2 = LiquidManager.instance().registerCell(LiquidItems.getCreosoteOilLiquid(1000), new ItemStack((Item)item));
                if (ic2) {
                    item.func_77637_a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ItemStack((Item)item));
                itemCreosoteOilCell = item;
            } else {
                return null;
            }
        }
        return new ItemStack((Item)item, qty);
    }

    public static ItemStack getSteam() {
        LiquidItems.initSteam();
        return new ItemStack(itemSteam);
    }

    private static void initSteam() {
        String tag;
        int id;
        if (itemSteam == null && (id = RailcraftConfig.getItemId(tag = "railcraft.liquid.steam")) > 0) {
            Item item = new ItemLiquid(id).setRarity(0).func_77655_b(tag);
            GameRegistry.registerItem((Item)item, (String)tag);
            RailcraftLanguage.instance().registerItemName(item, tag);
            liquidSteam = LiquidDictionary.getOrCreateLiquid((String)"Steam", (LiquidStack)new LiquidStack(item.field_77779_bT, 0));
            ItemRegistry.registerItem(tag, new ItemStack(item));
            itemSteam = item;
        }
    }

    public static LiquidStack getSteamLiquid() {
        return LiquidItems.getSteamLiquid(0);
    }

    public static LiquidStack getSteamLiquid(int qty) {
        LiquidItems.initSteam();
        LiquidStack liquid = liquidSteam.copy();
        liquid.amount = qty;
        return liquid;
    }
}

