/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.liquids;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.liquids.ForestryLiquidAdapater;
import mods.railcraft.common.liquids.ForgeLiquidAdapater;
import mods.railcraft.common.liquids.ILiquidAdaptor;
import mods.railcraft.common.liquids.TankManager;
import mods.railcraft.common.liquids.tanks.StandardTank;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public final class LiquidManager
implements ILiquidAdaptor {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int BUCKET_VOLUME = 1000;
    private static LiquidManager instance;
    private List adapters = new ArrayList();

    private LiquidManager() {
        this.adapters.add(ForestryLiquidAdapater.instance());
        this.adapters.add(ForgeLiquidAdapater.getInstance());
    }

    public static LiquidManager instance() {
        if (instance == null) {
            instance = new LiquidManager();
        }
        return instance;
    }

    public boolean handleRightClick(ITankContainer tank, int tankIndex, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            LiquidStack available;
            LiquidStack liquid = this.getLiquidInContainer(current);
            if (fill && liquid != null) {
                int used = tank.fill(tankIndex, liquid, true);
                if (used > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    }
                    return true;
                }
            } else if (drain && (available = tank.getTanks(ForgeDirection.UNKNOWN)[tankIndex].getLiquid()) != null && (liquid = this.getLiquidInContainer(filled = this.fillLiquidContainer(available, current))) != null) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(current));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                }
                tank.drain(tankIndex, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot) {
        this.processContainers(tank, inv, inputSlot, outputSlot, true, true);
    }

    public void processContainers(StandardTank tank, IInventory inv, int inputSlot, int outputSlot, boolean processFilled, boolean processEmpty) {
        TankManager tankManger = new TankManager();
        tankManger.addTank(tank);
        this.processContainers(tankManger, 0, inv, inputSlot, outputSlot, processFilled, processEmpty);
    }

    public void processContainers(ITankContainer tank, int tankIndex, IInventory inv, int inputSlot, int outputSlot) {
        this.processContainers(tank, tankIndex, inv, inputSlot, outputSlot, true, true);
    }

    public void processContainers(ITankContainer tank, int tankIndex, IInventory inv, int inputSlot, int outputSlot, boolean processFilled, boolean processEmpty) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input != null) {
            ItemStack filled;
            LiquidStack bucketLiquid = LiquidManager.instance().getLiquidInContainer(input);
            ItemStack emptyItem = input.func_77973_b().getContainerItemStack(input);
            if (processFilled && bucketLiquid != null && (emptyItem == null || output == null || output.field_77994_a < output.func_77976_d() && InvTools.isItemEqual(output, emptyItem))) {
                int used = tank.fill(tankIndex, bucketLiquid, false);
                if (used >= bucketLiquid.amount) {
                    tank.fill(tankIndex, bucketLiquid, true);
                    if (emptyItem != null) {
                        if (output == null) {
                            inv.func_70299_a(outputSlot, emptyItem);
                        } else {
                            ++output.field_77994_a;
                        }
                    }
                    inv.func_70298_a(inputSlot, 1);
                }
            } else if (processEmpty && LiquidManager.instance().isEmptyContainer(input) && (filled = LiquidManager.instance().fillLiquidContainer(tank.getTanks(ForgeDirection.UNKNOWN)[tankIndex].getLiquid(), input)) != null && (output == null || output.field_77994_a < output.func_77976_d() && InvTools.isItemEqual(filled, output))) {
                LiquidStack liquid = LiquidManager.instance().getLiquidInContainer(filled);
                LiquidStack drain = tank.drain(tankIndex, liquid.amount, false);
                if (drain != null && drain.amount > 0) {
                    tank.drain(tankIndex, liquid.amount, true);
                    if (output == null) {
                        inv.func_70299_a(outputSlot, filled);
                    } else {
                        ++output.field_77994_a;
                    }
                    inv.func_70298_a(inputSlot, 1);
                }
            }
        }
    }

    public boolean isBucket(ItemStack stack) {
        return LiquidContainerRegistry.isBucket((ItemStack)stack);
    }

    public boolean isContainer(ItemStack stack) {
        return LiquidContainerRegistry.isContainer((ItemStack)stack);
    }

    public boolean isFilledContainer(ItemStack stack) {
        return LiquidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    public boolean isEmptyContainer(ItemStack stack) {
        return LiquidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public ItemStack fillLiquidContainer(LiquidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        return LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquid, (ItemStack)empty);
    }

    public ItemStack getFilledLiquidContainer(LiquidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        liquid = liquid.copy();
        liquid.amount = Integer.MAX_VALUE;
        return LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquid, (ItemStack)empty);
    }

    public LiquidStack getLiquidInContainer(ItemStack stack) {
        return LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)stack);
    }

    public boolean containsLiquid(ItemStack stack, LiquidStack liquid) {
        return LiquidContainerRegistry.containsLiquid((ItemStack)stack, (LiquidStack)liquid);
    }

    public boolean isLiquidEqual(LiquidStack L1, LiquidStack L2) {
        if (L1 == null || L2 == null) {
            return false;
        }
        return L1.isLiquidEqual(L2);
    }

    public void registerBucket(LiquidStack liquid, ItemStack filled) {
        ItemStack empty = new ItemStack(Item.field_77788_aw);
        LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
        this.registerContainer(container);
    }

    public boolean registerWax(LiquidStack liquid, ItemStack filled) {
        ItemStack empty = ForestryLiquidAdapater.instance().waxCapsule;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public boolean registerRefactory(LiquidStack liquid, ItemStack filled) {
        ItemStack empty = ForestryLiquidAdapater.instance().refractoryEmpty;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public boolean registerCan(LiquidStack liquid, ItemStack filled) {
        ItemStack empty = ForestryLiquidAdapater.instance().canEmpty;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public boolean registerCell(LiquidStack liquid, ItemStack filled) {
        ItemStack empty = ForestryLiquidAdapater.instance().cellEmpty;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public void registerBottle(LiquidStack liquid, ItemStack filled) {
        ItemStack empty = new ItemStack(Item.field_77729_bt);
        LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
        this.registerContainer(container);
    }

    @Override
    public void registerContainer(LiquidContainerData container) {
        for (ILiquidAdaptor adapter : this.adapters) {
            adapter.registerContainer(container);
        }
    }
}

