/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.liquids.tanks;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.gui.util.ToolTip;
import mods.railcraft.common.liquids.tanks.StandardTank;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class FilteredTank
extends StandardTank {
    private final LiquidStack filter;

    public FilteredTank(int capacity, LiquidStack filter) {
        super(capacity);
        this.filter = filter;
    }

    @Override
    public int fill(LiquidStack resource, boolean doFill) {
        if (this.filter.isLiquidEqual(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack getFilter() {
        return this.filter.copy();
    }

    public boolean liquidMatchesFilter(LiquidStack resource) {
        if (resource == null || this.filter == null) {
            return false;
        }
        return this.filter.isLiquidEqual(resource);
    }

    public List getToolTip() {
        ArrayList<ToolTip> list = new ArrayList<ToolTip>();
        int amount = 0;
        LiquidStack liquidType = this.getFilter();
        if (liquidType != null && liquidType.itemID > 0) {
            ItemStack stack = liquidType.asItemStack();
            if (stack.func_77973_b() == null) {
                return list;
            }
            list.add(new ToolTip(Railcraft.getProxy().getItemDisplayName(stack), Railcraft.getProxy().getItemRarityColor(stack)));
            if (this.getLiquid() != null) {
                amount = this.getLiquid().amount;
            }
        }
        list.add(new ToolTip(String.format("%,d", amount) + " / " + String.format("%,d", this.getCapacity())));
        return list;
    }
}

