/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.io.File;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.modules.ModuleAutomation;
import mods.railcraft.common.modules.ModuleChunkLoading;
import mods.railcraft.common.modules.ModuleCore;
import mods.railcraft.common.modules.ModuleEnergy;
import mods.railcraft.common.modules.ModuleExtras;
import mods.railcraft.common.modules.ModuleFactory;
import mods.railcraft.common.modules.ModuleForestry;
import mods.railcraft.common.modules.ModuleIC2;
import mods.railcraft.common.modules.ModuleLocomotives;
import mods.railcraft.common.modules.ModuleRouting;
import mods.railcraft.common.modules.ModuleSeasonal;
import mods.railcraft.common.modules.ModuleSignals;
import mods.railcraft.common.modules.ModuleStructures;
import mods.railcraft.common.modules.ModuleTrack;
import mods.railcraft.common.modules.ModuleTracksHighSpeed;
import mods.railcraft.common.modules.ModuleTracksReinforced;
import mods.railcraft.common.modules.ModuleTracksWood;
import mods.railcraft.common.modules.ModuleTrain;
import mods.railcraft.common.modules.ModuleTransport;
import mods.railcraft.common.modules.ModuleWorld;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.util.misc.Game;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public abstract class ModuleManager {
    public static final String MODULE_CONFIG_FILE_NAME = "modules.cfg";
    public static final String CATEGORY_MODULES = "modules";
    private static Map modules = new EnumMap(Module.class);
    private static Set loadedModules = EnumSet.noneOf(Module.class);
    private static Set unloadedModules = EnumSet.noneOf(Module.class);

    public static void preInit() {
        ModuleManager.registerModule(Module.CORE, new ModuleCore());
        ModuleManager.registerModule(Module.AUTOMATION, new ModuleAutomation());
        ModuleManager.registerModule(Module.SIGNALS, new ModuleSignals());
        ModuleManager.registerModule(Module.STRUCTURES, new ModuleStructures());
        ModuleManager.registerModule(Module.EXTRAS, new ModuleExtras());
        ModuleManager.registerModule(Module.FACTORY, new ModuleFactory());
        ModuleManager.registerModule(Module.TRANSPORT, new ModuleTransport());
        ModuleManager.registerModule(Module.TRACKS, new ModuleTrack());
        ModuleManager.registerModule(Module.TRACKS_HIGHSPEED, new ModuleTracksHighSpeed());
        ModuleManager.registerModule(Module.TRACKS_WOOD, new ModuleTracksWood());
        ModuleManager.registerModule(Module.TRACKS_REINFORCED, new ModuleTracksReinforced());
        ModuleManager.registerModule(Module.IC2, new ModuleIC2());
        ModuleManager.registerModule(Module.FORESTRY, new ModuleForestry());
        ModuleManager.registerModule(Module.ENERGY, new ModuleEnergy());
        ModuleManager.registerModule(Module.WORLD, new ModuleWorld());
        ModuleManager.registerModule(Module.CHUNK_LOADING, new ModuleChunkLoading());
        ModuleManager.registerModule(Module.SEASONAL, new ModuleSeasonal());
        ModuleManager.registerModule(Module.TRAIN, new ModuleTrain());
        ModuleManager.registerModule(Module.LOCOMOTIVES, new ModuleLocomotives());
        ModuleManager.registerModule(Module.ROUTING, new ModuleRouting());
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        Configuration config = new Configuration(new File(Railcraft.getMod().getConfigFolder(), MODULE_CONFIG_FILE_NAME));
        config.load();
        config.addCustomCategoryComment(CATEGORY_MODULES, "Disabling these modules can greatly change how the mod functions.\nFor example, disabling the Train Module will prevent you from linking carts.\nDisabling the World Module will disable all world gen.\nDisabling the Energy Module will remove the energy requirement from machines, but will only do so if Forestry or Buildcraft are not installed.");
        for (Module m : Module.values()) {
            if (m == Module.CORE || ModuleManager.isEnabled(config, m)) {
                RailcraftModule instance = (RailcraftModule)modules.get((Object)m);
                if (instance.canModuleLoad()) {
                    loadedModules.add(m);
                    continue;
                }
                unloadedModules.add(m);
                instance.printLoadError();
                continue;
            }
            unloadedModules.add(m);
            Game.log(Level.FINER, "Module disabled: {0}", new Object[]{m});
        }
        if (config.hasChanged()) {
            config.save();
        }
        Locale.setDefault(locale);
        for (Module m : loadedModules) {
            ModuleManager.preInit(m);
        }
    }

    public static void init() {
        for (Module m : loadedModules) {
            ModuleManager.initFirst(m);
        }
        for (Module m : loadedModules) {
            ModuleManager.initSecond(m);
        }
    }

    public static void postInit() {
        for (Module m : loadedModules) {
            ModuleManager.postInit(m);
        }
        for (Module m : unloadedModules) {
            ModuleManager.postInitNotLoaded(m);
        }
    }

    private static boolean isEnabled(Configuration config, Module m) {
        boolean defaultValue = true;
        Property prop = config.get(CATEGORY_MODULES, m.toString().toLowerCase(Locale.ENGLISH).replace('_', '.'), defaultValue);
        return prop.getBoolean(true);
    }

    public static boolean isModuleLoaded(Module module) {
        return loadedModules.contains((Object)module);
    }

    private static void registerModule(Module module, RailcraftModule instance) {
        modules.put(module, instance);
    }

    private static void preInit(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("preInit", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Pre-Init Start: {0}", instance);
                instance.preInit();
                Game.log(Level.FINER, "Pre-Init Complete: {0}", instance);
            }
        }
    }

    private static void initFirst(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("initFirst", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Init-First Start: {0}", instance);
                instance.initFirst();
                Game.log(Level.FINER, "Init-First Complete: {0}", instance);
            }
        }
    }

    private static void initSecond(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("initSecond", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Init-Second Start: {0}", instance);
                instance.initSecond();
                Game.log(Level.FINER, "Init-Second Complete: {0}", instance);
            }
        }
    }

    private static void postInit(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("postInit", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Post-Init Start: {0}", instance);
                instance.postInit();
                Game.log(Level.FINER, "Post-Init Complete: {0}", instance);
            }
        }
    }

    private static void postInitNotLoaded(Module module) {
        RailcraftModule instance = (RailcraftModule)modules.get((Object)module);
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("postInitNotLoaded", new Class[0]).getDeclaringClass() != RailcraftModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Disabled-Init Start: {0}", instance);
                instance.postInitNotLoaded();
                Game.log(Level.FINER, "Disabled-Init Complete: {0}", instance);
            }
        }
    }

    public static enum Module {
        CORE,
        FACTORY,
        EXTRAS,
        TRACKS,
        TRACKS_HIGHSPEED,
        TRACKS_WOOD,
        TRACKS_REINFORCED,
        SIGNALS,
        STRUCTURES,
        AUTOMATION,
        TRANSPORT,
        IC2,
        FORESTRY,
        ENERGY,
        WORLD,
        CHUNK_LOADING,
        SEASONAL,
        TRAIN,
        LOCOMOTIVES,
        ROUTING;

    }
}

