/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.util.Icon;

public class FakeBlockRenderInfo {
    public Block template = Block.field_71981_t;
    public Icon[] texture = null;
    public float minX = 0.0f;
    public float minY = 0.0f;
    public float minZ = 0.0f;
    public float maxX = 1.0f;
    public float maxY = 1.0f;
    public float maxZ = 1.0f;
    public boolean[] renderSide = new boolean[6];
    public float light = -1.0f;
    public int brightness = -1;

    public FakeBlockRenderInfo() {
        this.setRenderAllSides();
    }

    public FakeBlockRenderInfo(Block template, Icon[] texture) {
        this();
        this.template = template;
        this.texture = texture;
    }

    public FakeBlockRenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this();
        this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public final void setBlockBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public final void setRenderSingleSide(int side) {
        Arrays.fill(this.renderSide, false);
        this.renderSide[side] = true;
    }

    public final void setRenderAllSides() {
        Arrays.fill(this.renderSide, true);
    }

    public void rotate() {
        float temp = this.minX;
        this.minX = this.minZ;
        this.minZ = temp;
        temp = this.maxX;
        this.maxX = this.maxZ;
        this.maxZ = temp;
    }

    public void reverseX() {
        float temp = this.minX;
        this.minX = 1.0f - this.maxX;
        this.maxX = 1.0f - temp;
    }

    public void reverseZ() {
        float temp = this.minZ;
        this.minZ = 1.0f - this.maxZ;
        this.maxZ = 1.0f - temp;
    }

    public Icon getBlockTextureFromSide(int i) {
        if (this.texture == null || this.texture.length == 0) {
            return this.template.func_71851_a(i);
        }
        if (i >= this.texture.length) {
            i = 0;
        }
        return this.texture[i];
    }
}

