/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.logging.Level;
import java.util.logging.Logger;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.lang.RailcraftLanguage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Game {
    private static final Logger log = Logger.getLogger("Railcraft");

    public static boolean isHost(World world) {
        return !world.field_72995_K;
    }

    public static boolean isNotHost(World world) {
        return world.field_72995_K;
    }

    @SideOnly(value=Side.CLIENT)
    public static World getWorld() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null) {
            return mc.field_71441_e;
        }
        return null;
    }

    public static boolean isObfuscated() {
        return !World.class.getSimpleName().equals("World");
    }

    public static void log(Level level, String msg, Object ... args) {
        String m = msg;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            m = m.replace("{" + i + "}", args[i].toString());
        }
        log.log(level, m);
    }

    public static void logError(Level level, String msg, Object ... args) {
        Game.log(level, msg, args);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTrace.length && i < 6; ++i) {
            Game.log(level, stackTrace[i].toString(), new Object[0]);
        }
    }

    public static void logDebug(Level level, String msg, Object ... args) {
        if (Railcraft.getVersion().endsWith("0")) {
            return;
        }
        String m = msg;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            m = m.replace("{" + i + "}", args[i].toString());
        }
        log.log(level, m);
    }

    public static void logErrorAPI(String mod, Throwable error) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        StackTraceElement[] stackTrace = error.getStackTrace();
        if (stackTrace.length > 0) {
            msg.append(", ").append(stackTrace[0]);
        }
        log.log(Level.SEVERE, msg.toString());
    }

    public static void logError(String msg, Throwable error) {
        log.log(Level.SEVERE, msg, error);
    }

    public static void logErrorFingerprint(String mod) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" failed validation, terminating. Please re-download ").append(mod).append(".");
        log.log(Level.SEVERE, msg.toString());
    }

    public static void sendLocalizedChat(EntityPlayer player, String msg, Object ... args) {
        player.func_71035_c(String.format(RailcraftLanguage.translate(msg), args));
    }

    static {
        log.setParent(FMLCommonHandler.instance().getFMLLogger());
    }
}

