/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IEditableItem;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;

public class PacketCurrentItemNBT
extends RailcraftPacket {
    private ItemStack currentItem;

    public PacketCurrentItemNBT(ItemStack currentItem) {
        this.currentItem = currentItem;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        Packet.func_73270_a((ItemStack)this.currentItem, (DataOutputStream)data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        try {
            ItemStack stack = Packet.func_73276_c((DataInputStream)data);
            if (stack == null || this.currentItem == null) {
                return;
            }
            if (stack.field_77993_c != this.currentItem.field_77993_c) {
                return;
            }
            if (!(this.currentItem.func_77973_b() instanceof IEditableItem)) {
                return;
            }
            if (!((IEditableItem)stack.func_77973_b()).validateNBT(stack.func_77978_p())) {
                Game.log(Level.WARNING, "Item NBT not valid!", new Object[0]);
                return;
            }
            this.currentItem.func_77982_d(stack.func_77978_p());
        }
        catch (Exception exception) {
            Game.logError("Error reading Item NBT packet", exception);
        }
    }

    public void sendPacket() {
        PacketDispatcher.sendPacketToServer((Packet)this.getPacket());
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.ITEM_NBT.ordinal();
    }
}

