/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketCurrentItemNBT;
import mods.railcraft.common.util.network.PacketEffect;
import mods.railcraft.common.util.network.PacketGuiReturn;
import mods.railcraft.common.util.network.PacketGuiUpdate;
import mods.railcraft.common.util.network.PacketPairRequest;
import mods.railcraft.common.util.network.PacketPairUpdate;
import mods.railcraft.common.util.network.PacketTileEntity;
import mods.railcraft.common.util.network.PacketTileExtraData;
import mods.railcraft.common.util.network.PacketTileRequest;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;

public class RailcraftPacketHandler
implements IPacketHandler {
    private static RailcraftPacket.PacketType[] packetTypes = RailcraftPacket.PacketType.values();

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            RailcraftPacket pkt = null;
            byte packetID = data.readByte();
            if (packetID < 0) {
                return;
            }
            RailcraftPacket.PacketType type = packetTypes[packetID];
            switch (type) {
                case TILE_ENTITY: {
                    pkt = new PacketTileEntity();
                    break;
                }
                case GUI_RETURN: {
                    pkt = new PacketGuiReturn();
                    break;
                }
                case TILE_EXTRA_DATA: {
                    pkt = new PacketTileExtraData();
                    break;
                }
                case TILE_REQUEST: {
                    pkt = new PacketTileRequest(player);
                    break;
                }
                case GUI_UPDATE: {
                    pkt = new PacketGuiUpdate();
                    break;
                }
                case EFFECT: {
                    pkt = new PacketEffect();
                    break;
                }
                case CONTROLLER_UPDATE: 
                case RECEIVER_UPDATE: {
                    pkt = new PacketPairUpdate(type);
                    break;
                }
                case CONTROLLER_REQUEST: 
                case RECEIVER_REQUEST: {
                    pkt = new PacketPairRequest(player, type);
                    break;
                }
                case ITEM_NBT: {
                    pkt = new PacketCurrentItemNBT(((EntityPlayer)player).func_71045_bC());
                    break;
                }
                default: {
                    return;
                }
            }
            ((RailcraftPacket)pkt).readData(data);
        }
        catch (IOException e) {
            Game.log(Level.SEVERE, "Exception in PacketHandler.onPacketData {0}", e);
            e.printStackTrace();
        }
    }
}

