/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.core;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.Configuration;
import rebelkeithy.mods.keithyutils.guiregistry.GuiRegistry;
import rebelkeithy.mods.metallurgy.core.CommonProxy;
import rebelkeithy.mods.metallurgy.core.MetalInfoDatabase;
import rebelkeithy.mods.metallurgy.core.metalsets.MetalSet;

@Mod(modid="Metallurgy3Core", name="Metallurgy 3 Core", version="3.2", dependencies="required-after:KeithyUtils@[1.0,]")
@NetworkMod(channels={"MetallurgyCore"}, clientSideRequired=true, serverSideRequired=false)
public class MetallurgyCore {
    @SidedProxy(clientSide="rebelkeithy.mods.metallurgy.core.ClientProxy", serverSide="rebelkeithy.mods.metallurgy.core.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="Metallurgy3Core")
    public static MetallurgyCore instance;
    public static boolean spawnInAir;
    Configuration config;
    List<String> csvFiles;
    List<String> setsToRead;
    private static List<MetalSet> metalSets;
    MetalSet baseSet;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        for (MetalSet metalSet : MetallurgyCore.getMetalSetList()) {
        }
        this.initConfig();
        for (String string : this.csvFiles) {
            if (string.equals("")) continue;
            MetalInfoDatabase.readMetalDataFromFile("/config/Metallurgy3/" + string);
        }
        for (String string : this.setsToRead) {
            if (string.equals("")) continue;
            CreativeTabs tab = new CreativeTabs(string);
            new MetalSet(string, MetalInfoDatabase.getSpreadsheetDataForSet(string), tab);
        }
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)GuiRegistry.instance());
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        for (MetalSet set : MetallurgyCore.getMetalSetList()) {
            set.load();
            proxy.registerNamesForMetalSet(set);
        }
        MetalInfoDatabase.registerItemsWithOreDict();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
    }

    public void initConfig() {
        File fileDir = new File(proxy.getMinecraftDir() + "/config/Metallurgy3");
        fileDir.mkdir();
        File cfgFile = new File(proxy.getMinecraftDir() + "/config/Metallurgy3/MetallurgyCore.cfg");
        try {
            cfgFile.createNewFile();
            System.out.println("[Metallurgy3] Successfully created/read configuration file for Metallurgy 3 Core");
        }
        catch (IOException e) {
            System.out.println("[Metallurgy3] Could not create configuration file for Metallurgy 3 Core, Reason:");
            System.out.println(e);
        }
        this.config = new Configuration(cfgFile);
        this.config.load();
        spawnInAir = this.config.get("Cheats", "Spawn Ore In Air", false).getBoolean(false);
        this.csvFiles = Arrays.asList(this.config.get("Metal Sets", "File List", "").getString().split("\\s*,\\s*"));
        this.setsToRead = Arrays.asList(this.config.get("Metal Sets", "Metal Set List", "").getString().split("\\s*,\\s*"));
        System.out.println("reading sets " + this.setsToRead.size());
        this.config.save();
    }

    public static List<MetalSet> getMetalSetList() {
        if (metalSets == null) {
            metalSets = new ArrayList<MetalSet>();
        }
        return metalSets;
    }

    static {
        spawnInAir = false;
    }
}

