/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.core.metalsets;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.Configuration;
import rebelkeithy.mods.metallurgy.api.IMetalSet;
import rebelkeithy.mods.metallurgy.api.IOreInfo;
import rebelkeithy.mods.metallurgy.core.MetallurgyCore;
import rebelkeithy.mods.metallurgy.core.metalsets.OreInfo;

public class MetalSet
implements IMetalSet {
    private String setName;
    private Map<String, IOreInfo> metals;
    private Configuration config;

    public MetalSet(String setName, Map<String, Map<String, String>> baseData, CreativeTabs tab) {
        this.setName = setName;
        this.metals = new HashMap<String, IOreInfo>();
        for (Map<String, String> metalInfo : baseData.values()) {
            this.metals.put(metalInfo.get("Name"), new OreInfo(metalInfo, tab));
        }
        MetallurgyCore.getMetalSetList().add(this);
        this.initConfig();
        this.init();
    }

    public void initConfig() {
        File fileDir = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3");
        fileDir.mkdir();
        File cfgFile = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3/Metallurgy" + this.setName + ".cfg");
        try {
            cfgFile.createNewFile();
            System.out.println("[Metallurgy3] Successfully created/read configuration file for Metallurgy 3's metal set " + this.setName);
        }
        catch (IOException e) {
            System.out.println("[Metallurgy3] Could not create configuration file for Metallurgy 3 metal set " + this.setName + ". Reason:");
            System.out.println(e);
        }
        this.config = new Configuration(cfgFile);
        this.config.load();
        for (IOreInfo oreInfo : this.metals.values()) {
            ((OreInfo)oreInfo).initConfig(this.config);
        }
        this.config.save();
    }

    public void init() {
        for (IOreInfo oreInfo : this.metals.values()) {
            ((OreInfo)oreInfo).init();
        }
    }

    public void load() {
        for (IOreInfo oreInfo : this.metals.values()) {
            ((OreInfo)oreInfo).load();
        }
    }

    public void registerNames() {
        for (IOreInfo oreInfo : this.metals.values()) {
            ((OreInfo)oreInfo).registerNames();
        }
    }

    @Override
    public OreInfo getOreInfo(String name) {
        if (this.metals.containsKey(name)) {
            return (OreInfo)this.metals.get(name);
        }
        return new OreInfo();
    }

    @Override
    public OreInfo getOreInfo(int meta) {
        for (IOreInfo oreInfo : this.metals.values()) {
            if (((OreInfo)oreInfo).oreMeta != meta) continue;
            return (OreInfo)oreInfo;
        }
        return null;
    }

    @Override
    public Map<String, IOreInfo> getOreList() {
        return this.metals;
    }
}

