/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.machines.abstractor;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import rebelkeithy.mods.metallurgy.core.MetallurgyCore;
import rebelkeithy.mods.metallurgy.machines.ConfigMachines;
import rebelkeithy.mods.metallurgy.machines.abstractor.AbstractorRecipes;
import rebelkeithy.mods.metallurgy.metals.MetallurgyMetals;

public class TileEntityAbstractor
extends TileEntity
implements ISidedInventory {
    private ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    public int furnaceTimeBase = 200;
    public int direction = 0;
    private int ticksSinceSync;

    public void setSpeed(int var1) {
        this.furnaceTimeBase = var1;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.furnaceItemStacks[par1];
    }

    public void setDirection(int par1) {
        this.direction = par1;
    }

    public int getDirection() {
        return this.direction;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.furnaceItemStacks[par1] != null) {
            if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                ItemStack var3 = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return var3;
            }
            ItemStack var3 = this.furnaceItemStacks[par1].func_77979_a(par2);
            if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                this.furnaceItemStacks[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.furnaceItemStacks[par1] != null) {
            ItemStack var2 = this.furnaceItemStacks[par1];
            this.furnaceItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "container.furnace";
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.furnaceBurnTime = par1NBTTagCompound.func_74765_d("BurnTime");
        this.furnaceCookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.direction = par1NBTTagCompound.func_74765_d("Direction");
        this.furnaceTimeBase = par1NBTTagCompound.func_74765_d("TimeBase");
        this.currentItemBurnTime = TileEntityAbstractor.getItemBurnTime(this.furnaceItemStacks[1]);
        this.ticksSinceSync = 40;
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        par1NBTTagCompound.func_74777_a("Direction", (short)this.direction);
        par1NBTTagCompound.func_74777_a("TimeBase", (short)this.furnaceTimeBase);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.furnaceItemStacks.length; ++var3) {
            if (this.furnaceItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.furnaceItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / this.furnaceTimeBase;
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.furnaceTimeBase;
        }
        return this.furnaceBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_70316_g() {
        boolean prevIsBurning = this.furnaceBurnTime > 0;
        boolean var2 = false;
        if (++this.ticksSinceSync > 40) {
            this.sendPacket();
            this.ticksSinceSync = 0;
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityAbstractor.getItemBurnTime(this.furnaceItemStacks[1]);
                if (this.furnaceBurnTime > 0) {
                    var2 = true;
                    if (this.furnaceItemStacks[1] != null) {
                        --this.furnaceItemStacks[1].field_77994_a;
                        if (this.furnaceItemStacks[1].field_77994_a == 0) {
                            this.furnaceItemStacks[1] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime >= this.furnaceTimeBase) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (prevIsBurning != this.furnaceBurnTime > 0) {
                var2 = true;
            }
        }
        if (var2) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.func_70296_d();
            this.sendPacket();
        }
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        int amount = AbstractorRecipes.essence().getEssenceResult(this.furnaceItemStacks[0]);
        return amount != 0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            int var1 = AbstractorRecipes.essence().getEssenceResult(this.furnaceItemStacks[0]);
            int type = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            int totalXP = (int)((double)var1 * ConfigMachines.xpBonus[type]);
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
            int xpPerOrb = 1;
            int orbCount = totalXP;
            if (totalXP > 20) {
                xpPerOrb = 2;
                orbCount = totalXP / 2 + 1;
            }
            if (totalXP > 40) {
                xpPerOrb = 4;
                orbCount = totalXP / 4 + 1;
            }
            if (totalXP > 80) {
                xpPerOrb = 8;
                orbCount = totalXP / 8 + 1;
            }
            for (int n = 0; n < orbCount; ++n) {
                double xOffset = 0.5;
                double zOffset = 0.5;
                double xMotion = 0.0;
                double zMotion = 0.0;
                if (this.direction == 2) {
                    zOffset = 0.0;
                    zOffset = -0.1;
                } else if (this.direction == 3) {
                    zOffset = 1.0;
                    zMotion = 0.1;
                } else if (this.direction == 4) {
                    xOffset = 0.0;
                    xMotion = -0.1;
                } else if (this.direction == 5) {
                    xOffset = 1.0;
                    xMotion = 0.1;
                }
                Random rand = new Random();
                double yMotion = (double)(rand.nextInt(11) - 5) / 200.0;
                MetallurgyCore.proxy.spawnParticle("abstractorSmall", this.field_70331_k, (double)this.field_70329_l + (xOffset += (double)(rand.nextInt(21) - 10) / 100.0), (double)this.field_70330_m + 0.75, (double)this.field_70327_n + (zOffset += (double)(rand.nextInt(21) - 10) / 100.0), (xMotion += (double)(rand.nextInt(11) - 5) / 100.0) * (double)0.7f, yMotion, (zMotion += (double)(rand.nextInt(11) - 5) / 100.0) * (double)0.7f);
                EntityXPOrb orb = new EntityXPOrb(this.field_70331_k, (double)this.field_70329_l + xOffset, (double)((float)this.field_70330_m + 0.5f), (double)this.field_70327_n + zOffset, xpPerOrb);
                orb.field_70159_w = xMotion;
                orb.field_70179_y = zMotion;
                if (this.field_70331_k.field_72995_K) continue;
                this.field_70331_k.func_72838_d((Entity)orb);
                this.field_70331_k.func_72870_g((Entity)orb);
            }
            this.sendPacket();
        }
    }

    public static int getItemBurnTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        int var1 = par0ItemStack.func_77973_b().field_77779_bT;
        Item var2 = par0ItemStack.func_77973_b();
        if (var1 == MetallurgyMetals.fantasySet.getOreInfo((String)"Prometheum").dust.field_77779_bT) {
            return 1760;
        }
        if (var1 == MetallurgyMetals.fantasySet.getOreInfo((String)"Astral Silver").dust.field_77779_bT) {
            return 7040;
        }
        if (var1 == MetallurgyMetals.fantasySet.getOreInfo((String)"Carmot").dust.field_77779_bT) {
            return 14080;
        }
        return AbstractorRecipes.getFuelAmount(par0ItemStack);
    }

    public boolean func_70315_b(int i, int j) {
        if (i == 1) {
            this.direction = j;
        } else if (i == 2) {
            this.furnaceTimeBase = j;
        } else if (i == 3) {
            this.furnaceBurnTime = j;
        } else if (i == 4) {
            this.furnaceCookTime = j;
        } else {
            return false;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityAbstractor.getItemBurnTime(par0ItemStack) > 0;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int getType() {
        return this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void sendPacket() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(140);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeShort(51);
            dos.writeInt(this.field_70329_l);
            dos.writeInt(this.field_70330_m);
            dos.writeInt(this.field_70327_n);
            dos.writeInt(this.direction);
            dos.writeInt(this.furnaceTimeBase);
            dos.writeInt(this.furnaceBurnTime);
        }
        catch (IOException e) {
            // empty catch block
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "M3Machines";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        packet.field_73287_r = true;
        if (packet != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)16.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)packet);
        }
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? TileEntityAbstractor.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_94128_d(int par1) {
        int[] nArray;
        if (par1 == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 2;
        } else if (par1 == 1) {
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 0;
            nArray = nArray3;
            nArray3[2] = 2;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = 1;
            nArray = nArray4;
            nArray4[1] = 2;
        }
        return nArray;
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int slot, ItemStack par2ItemStack, int side) {
        return slot == 2;
    }
}

