/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.machines.forge;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityNetherForge
extends TileEntity
implements ISidedInventory,
IFluidTank {
    private ItemStack[] furnaceItemStacks = new ItemStack[2];
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    public float fuelMultiplier = 0.5f;
    public int furnaceTimeBase = 200;
    public int fuel = 0;
    public int maxFuel = 10000;
    public int fuelPerItem = 100;
    public boolean isBurning;
    public int direction = 0;
    private int ticksSinceSync;

    public void setSpeed(int var1) {
        this.furnaceTimeBase = var1;
    }

    public void setMaxBuckets(int buckets) {
        this.maxFuel = buckets * 1000;
    }

    public void addFuelBucket() {
        this.fuel += 1000;
        int n = this.fuel = this.fuel < this.maxFuel ? this.fuel : this.maxFuel;
        if (!this.field_70331_k.field_72995_K) {
            this.sendPacket();
        }
    }

    public void removeFuelBucket() {
        if (this.fuel >= 1000) {
            this.fuel -= 1000;
        }
        if (!this.field_70331_k.field_72995_K) {
            this.sendPacket();
        }
    }

    public int getFuelScaled(int scale) {
        int retValue = this.fuel * scale / this.maxFuel;
        if (retValue > scale) {
            return scale;
        }
        return retValue;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.furnaceItemStacks[par1];
    }

    public void setDirection(int par1) {
        this.direction = par1;
    }

    public int getDirection() {
        return this.direction;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.furnaceItemStacks[par1] != null) {
            if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                ItemStack var3 = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return var3;
            }
            ItemStack var3 = this.furnaceItemStacks[par1].func_77979_a(par2);
            if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                this.furnaceItemStacks[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.furnaceItemStacks[par1] != null) {
            ItemStack var2 = this.furnaceItemStacks[par1];
            this.furnaceItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "container.furnace";
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.fuel = par1NBTTagCompound.func_74762_e("Fuel");
        this.furnaceCookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.direction = par1NBTTagCompound.func_74765_d("Direction");
        this.furnaceTimeBase = par1NBTTagCompound.func_74765_d("TimeBase");
        this.maxFuel = par1NBTTagCompound.func_74762_e("MaxFuel");
        this.sync();
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Fuel", this.fuel);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        par1NBTTagCompound.func_74777_a("Direction", (short)this.direction);
        par1NBTTagCompound.func_74777_a("TimeBase", (short)this.furnaceTimeBase);
        par1NBTTagCompound.func_74768_a("MaxFuel", this.maxFuel);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.furnaceItemStacks.length; ++var3) {
            if (this.furnaceItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.furnaceItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
        this.sync();
    }

    public void sync() {
        if (this.field_70331_k != null) {
            int id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 1, this.direction);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 2, this.furnaceTimeBase);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 3, this.fuel);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 4, this.maxFuel);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 5, this.furnaceCookTime);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / this.furnaceTimeBase;
    }

    public boolean isBurning() {
        return this.fuel > 0 && this.canSmelt();
    }

    public void func_70316_g() {
        this.furnaceTimeBase = 20;
        if (++this.ticksSinceSync % 80 == 0) {
            this.sendPacket();
        }
        boolean var1 = this.furnaceBurnTime > 0;
        boolean checkBurning = false;
        boolean prevIsBurning = this.isBurning;
        if (this.canSmelt() && this.fuel > 0) {
            ++this.furnaceCookTime;
            this.isBurning = true;
            if (this.furnaceCookTime == this.furnaceTimeBase) {
                this.furnaceCookTime = 0;
                this.fuel -= this.fuelPerItem;
                this.smeltItem();
                checkBurning = true;
            }
        } else {
            this.furnaceCookTime = 0;
            this.isBurning = false;
        }
        if (prevIsBurning != this.isBurning) {
            checkBurning = true;
        }
        if (checkBurning) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.func_70296_d();
            this.sendPacket();
        }
    }

    private boolean canSmelt() {
        ItemStack var1 = FurnaceRecipes.func_77602_a().getSmeltingResult(this.furnaceItemStacks[0]);
        if (var1 == null) {
            return false;
        }
        if (this.furnaceItemStacks[1] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[1].func_77969_a(var1)) {
            return false;
        }
        int result = this.furnaceItemStacks[1].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack var1 = FurnaceRecipes.func_77602_a().getSmeltingResult(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[1] == null) {
                this.furnaceItemStacks[1] = var1.func_77946_l();
            } else if (this.furnaceItemStacks[1].func_77969_a(var1)) {
                ++this.furnaceItemStacks[1].field_77994_a;
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70315_b(int i, int j) {
        return false;
    }

    public int getType() {
        int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return meta < 8 ? meta : meta - 8;
    }

    public int getScaledFuel(int i) {
        int scaledFuel = MathHelper.func_76123_f((float)((float)i * ((float)this.fuel / (float)this.maxFuel)));
        return scaledFuel >= i ? i : scaledFuel;
    }

    public void sendPacket() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeShort(50);
            dos.writeInt(this.field_70329_l);
            dos.writeInt(this.field_70330_m);
            dos.writeInt(this.field_70327_n);
            dos.writeInt(this.direction);
            dos.writeInt(this.furnaceTimeBase);
            dos.writeInt(this.furnaceBurnTime);
            dos.writeInt(this.furnaceCookTime);
            dos.writeInt(this.fuel);
            dos.writeInt(this.maxFuel);
        }
        catch (IOException e) {
            // empty catch block
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "M3Machines";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        packet.field_73287_r = true;
        if (packet != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)16.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)packet);
        }
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 0;
    }

    public int[] func_94128_d(int par1) {
        if (par1 == 1) {
            return new int[]{0, 1};
        }
        if (par1 == 2) {
            return new int[]{1};
        }
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int slot, ItemStack par2ItemStack, int side) {
        return slot == 1;
    }

    public FluidStack getFluid() {
        return new FluidStack(FluidRegistry.LAVA, this.fuel);
    }

    public int getFluidAmount() {
        return this.fuel;
    }

    public int getCapacity() {
        return this.maxFuel;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.maxFuel);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = resource.amount;
        if (amount > this.maxFuel - this.fuel) {
            amount = this.maxFuel - this.fuel;
        }
        if (doFill) {
            this.fuel += amount;
        }
        return amount;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amount = maxDrain;
        if (amount > this.fuel) {
            amount = this.fuel;
        }
        if (doDrain) {
            this.fuel -= amount;
        }
        return new FluidStack(FluidRegistry.LAVA, amount);
    }
}

