/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.machines.furnace;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rebelkeithy.mods.keithyutils.guiregistry.GuiRegistry;
import rebelkeithy.mods.metallurgy.machines.ConfigMachines;
import rebelkeithy.mods.metallurgy.machines.MetallurgyMachines;
import rebelkeithy.mods.metallurgy.machines.furnace.TileEntityMetalFurnace;

public class BlockMetalFurnace
extends BlockContainer {
    private Random furnaceRand = new Random();
    private final boolean isActive;
    private static int front = 0;
    private static int side = 1;
    private static int top = 2;
    private static int active = 3;
    private Map<Integer, Icon[]> iconMap;
    private static boolean keepFurnaceInventory = false;

    public BlockMetalFurnace(int par1, boolean par2) {
        super(par1, Material.field_76246_e);
        this.isActive = par2;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return ConfigMachines.furnaceID;
    }

    public int func_71899_b(int metadata) {
        return metadata < 8 ? metadata : metadata - 8;
    }

    public Icon getFurnaceTexture(int side, int meta, int facing, boolean isActive) {
        if (side == 1 || side == 0) {
            return this.iconMap.get(meta)[top];
        }
        if (side != facing) {
            return this.iconMap.get(meta)[BlockMetalFurnace.side];
        }
        if (isActive) {
            return this.iconMap.get(meta)[active];
        }
        return this.iconMap.get(meta)[front];
    }

    public Icon func_71858_a(int par1, int par2) {
        return this.getFurnaceTexture(par1, par2, 3, false);
    }

    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        TileEntity tileEntity = par1IBlockAccess.func_72796_p(par2, par3, par4);
        int meta = par1IBlockAccess.func_72805_g(par2, par3, par4);
        int type = meta < 8 ? meta : meta - 8;
        int dir = tileEntity instanceof TileEntityMetalFurnace ? ((TileEntityMetalFurnace)tileEntity).getDirection() : 0;
        boolean isBurning = tileEntity instanceof TileEntityMetalFurnace ? ((TileEntityMetalFurnace)tileEntity).isBurning() : false;
        return this.getFurnaceTexture(par5, meta, dir, isBurning);
    }

    public void func_71862_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        TileEntityMetalFurnace tef = (TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4);
        if (tef.isBurning()) {
            int var6 = tef.getDirection();
            float var7 = (float)par2 + 0.5f;
            float var8 = (float)par3 + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
            float var9 = (float)par4 + 0.5f;
            float var10 = 0.52f;
            float var11 = par5Random.nextFloat() * 0.6f - 0.3f;
            if (var6 == 4) {
                par1World.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
            } else if (var6 == 5) {
                par1World.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
            } else if (var6 == 2) {
                par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
            } else if (var6 == 3) {
                par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        try {
            TileEntityMetalFurnace var6 = (TileEntityMetalFurnace)world.func_72796_p(x, y, z);
            if (var6 != null && var6.isBurning()) {
                return 12;
            }
        }
        catch (ClassCastException e) {
            return 0;
        }
        return 0;
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        if (par5EntityPlayer.func_70093_af()) {
            return false;
        }
        TileEntityMetalFurnace var6 = (TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4);
        if (var6 != null) {
            GuiRegistry.openGui((String)"MetalFurnace", (Object)MetallurgyMachines.instance, (EntityPlayer)par5EntityPlayer, (World)par1World, (int)par2, (int)par3, (int)par4);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean par0, World par1World, int x, int y, int z) {
        int meta = par1World.func_72805_g(x, y, z);
        if (!par0 && meta >= 8) {
            par1World.func_72921_c(x, y, z, meta - 8, 2);
        } else if (par0 && meta < 8) {
            par1World.func_72921_c(x, y, z, meta + 8, 2);
        }
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityMetalFurnace();
    }

    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int var6 = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (var6 == 0) {
            ((TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4)).setDirection(2);
        }
        if (var6 == 1) {
            ((TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4)).setDirection(5);
        }
        if (var6 == 2) {
            ((TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4)).setDirection(3);
        }
        if (var6 == 3) {
            ((TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4)).setDirection(4);
        }
        TileEntityMetalFurnace var5 = (TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4);
        int metadata = par1World.func_72805_g(par2, par3, par4);
        switch (metadata) {
            case 0: {
                var5.setSpeed((int)(20.0f * ConfigMachines.copperFurnaceSpeed));
                break;
            }
            case 1: {
                var5.setSpeed((int)(20.0f * ConfigMachines.bronzeFurnaceSpeed));
                break;
            }
            case 2: {
                var5.setSpeed((int)(20.0f * ConfigMachines.ironFurnaceSpeed));
                break;
            }
            case 3: {
                var5.setSpeed((int)(20.0f * ConfigMachines.steelFurnaceSpeed));
                break;
            }
        }
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        TileEntityMetalFurnace var5;
        if (!keepFurnaceInventory && (var5 = (TileEntityMetalFurnace)par1World.func_72796_p(par2, par3, par4)) != null) {
            for (int var6 = 0; var6 < var5.func_70302_i_(); ++var6) {
                ItemStack var7 = var5.func_70301_a(var6);
                if (var7 == null) continue;
                float var8 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float var9 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float var10 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (var7.field_77994_a > 0) {
                    int var11 = this.furnaceRand.nextInt(21) + 10;
                    if (var11 > var7.field_77994_a) {
                        var11 = var7.field_77994_a;
                    }
                    var7.field_77994_a -= var11;
                    EntityItem var12 = new EntityItem(par1World, (double)((float)par2 + var8), (double)((float)par3 + var9), (double)((float)par4 + var10), new ItemStack(var7.field_77993_c, var11, var7.func_77960_j()));
                    if (var7.func_77942_o()) {
                        var12.func_92059_d().func_77982_d((NBTTagCompound)var7.func_77978_p().func_74737_b());
                    }
                    float var13 = 0.05f;
                    var12.field_70159_w = (float)this.furnaceRand.nextGaussian() * var13;
                    var12.field_70181_x = (float)this.furnaceRand.nextGaussian() * var13 + 0.2f;
                    var12.field_70179_y = (float)this.furnaceRand.nextGaussian() * var13;
                    par1World.func_72838_d((Entity)var12);
                }
            }
        }
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.iconMap = new HashMap<Integer, Icon[]>();
        for (int i = 0; i < 4; ++i) {
            Icon[] iArray = new Icon[5];
            iArray[BlockMetalFurnace.front] = par1IconRegister.func_94245_a("Metallurgy:machines/furnace/Furnace" + i + "Front");
            iArray[BlockMetalFurnace.side] = par1IconRegister.func_94245_a("Metallurgy:machines/furnace/Furnace" + i + "Side");
            iArray[BlockMetalFurnace.top] = par1IconRegister.func_94245_a("Metallurgy:machines/furnace/Furnace" + i + "Top");
            iArray[BlockMetalFurnace.active] = par1IconRegister.func_94245_a("Metallurgy:machines/furnace/Furnace" + i + "Active");
            this.iconMap.put(i, iArray);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int n = 0; n < 4; ++n) {
            par3List.add(new ItemStack((Block)this, 1, n));
        }
    }
}

