/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.machines.furnace;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMetalFurnace
extends TileEntity
implements ISidedInventory {
    private ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    public int furnaceTimeBase = 200;
    public int direction = 0;
    private int ticksSinceSync;

    public void setSpeed(int var1) {
        this.furnaceTimeBase = var1;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.furnaceItemStacks[par1];
    }

    public void setDirection(int par1) {
        this.direction = par1;
    }

    public int getDirection() {
        return this.direction;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.furnaceItemStacks[par1] != null) {
            if (this.furnaceItemStacks[par1].field_77994_a <= par2) {
                ItemStack var3 = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return var3;
            }
            ItemStack var3 = this.furnaceItemStacks[par1].func_77979_a(par2);
            if (this.furnaceItemStacks[par1].field_77994_a == 0) {
                this.furnaceItemStacks[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.furnaceItemStacks[par1] != null) {
            ItemStack var2 = this.furnaceItemStacks[par1];
            this.furnaceItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "container.furnace";
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.furnaceBurnTime = par1NBTTagCompound.func_74765_d("BurnTime");
        this.furnaceCookTime = par1NBTTagCompound.func_74765_d("CookTime");
        this.direction = par1NBTTagCompound.func_74765_d("Direction");
        this.furnaceTimeBase = par1NBTTagCompound.func_74765_d("TimeBase");
        this.currentItemBurnTime = TileEntityMetalFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
        this.ticksSinceSync = 80;
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        par1NBTTagCompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        par1NBTTagCompound.func_74777_a("Direction", (short)this.direction);
        par1NBTTagCompound.func_74777_a("TimeBase", (short)this.furnaceTimeBase);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.furnaceItemStacks.length; ++var3) {
            if (this.furnaceItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.furnaceItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getCookProgressScaled(int par1) {
        if (this.furnaceTimeBase == 0) {
            this.furnaceTimeBase = 200;
        }
        return this.furnaceCookTime * par1 / this.furnaceTimeBase;
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.furnaceTimeBase;
        }
        return this.furnaceBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_70316_g() {
        if (++this.ticksSinceSync > 80) {
            int id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 1, this.direction);
            this.sendPacket();
            this.ticksSinceSync = 0;
        }
        boolean var1 = this.furnaceBurnTime > 0;
        boolean var2 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityMetalFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
                if (this.furnaceBurnTime > 0) {
                    var2 = true;
                    if (this.furnaceItemStacks[1] != null) {
                        --this.furnaceItemStacks[1].field_77994_a;
                        if (this.furnaceItemStacks[1].field_77994_a == 0) {
                            this.furnaceItemStacks[1] = this.furnaceItemStacks[1].func_77973_b().getContainerItemStack(this.furnaceItemStacks[1]);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.furnaceTimeBase) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    var2 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (var1 != this.furnaceBurnTime > 0) {
                var2 = true;
            }
        }
        if (var2) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.func_70296_d();
            this.sendPacket();
        }
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack var1 = FurnaceRecipes.func_77602_a().getSmeltingResult(this.furnaceItemStacks[0]);
        if (var1 == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].func_77969_a(var1)) {
            return false;
        }
        int result = this.furnaceItemStacks[2].field_77994_a + var1.field_77994_a;
        return result <= this.func_70297_j_() && result <= var1.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack var1 = FurnaceRecipes.func_77602_a().getSmeltingResult(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = var1.func_77946_l();
            } else if (this.furnaceItemStacks[2].func_77969_a(var1)) {
                ++this.furnaceItemStacks[2].field_77994_a;
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        int var1 = par0ItemStack.func_77973_b().field_77779_bT;
        Item var2 = par0ItemStack.func_77973_b();
        if (par0ItemStack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[var1] != null) {
            Block var3 = Block.field_71973_m[var1];
            if (var3 == Block.field_72092_bO) {
                return 150;
            }
            if (var3.field_72018_cp == Material.field_76245_d) {
                return 300;
            }
        }
        if (var2 instanceof ItemTool && ((ItemTool)var2).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (var2 instanceof ItemSword && ((ItemSword)var2).func_77825_f().equals("WOOD")) {
            return 200;
        }
        if (var2 instanceof ItemHoe && ((ItemHoe)var2).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (var1 == Item.field_77669_D.field_77779_bT) {
            return 100;
        }
        if (var1 == Item.field_77705_m.field_77779_bT) {
            return 1600;
        }
        if (var1 == Item.field_77775_ay.field_77779_bT) {
            return 20000;
        }
        if (var1 == Block.field_71987_y.field_71990_ca) {
            return 100;
        }
        if (var1 == Item.field_77731_bo.field_77779_bT) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)par0ItemStack);
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return TileEntityMetalFurnace.getItemBurnTime(par0ItemStack) > 0;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean func_70315_b(int i, int j) {
        if (i == 11) {
            this.direction = j;
        }
        if (i != 4) {
            return false;
        }
        this.furnaceCookTime = j;
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int getType() {
        int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return meta < 8 ? meta : meta - 8;
    }

    public void sendPacket() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(140);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeShort(53);
            dos.writeInt(this.field_70329_l);
            dos.writeInt(this.field_70330_m);
            dos.writeInt(this.field_70327_n);
            dos.writeInt(this.direction);
            dos.writeInt(this.furnaceTimeBase);
            dos.writeInt(this.furnaceBurnTime);
            dos.writeInt(this.furnaceCookTime);
        }
        catch (IOException e) {
            // empty catch block
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "M3Machines";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        packet.field_73287_r = true;
        if (packet != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)16.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)packet);
        }
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? TileEntityMetalFurnace.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_94128_d(int par1) {
        int[] nArray;
        if (par1 == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 2;
        } else if (par1 == 1) {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = 1;
            nArray = nArray4;
            nArray4[1] = 2;
        }
        return nArray;
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int slot, ItemStack par2ItemStack, int side) {
        return slot == 2 || par2ItemStack.field_77993_c == Item.field_77788_aw.field_77779_bT;
    }
}

