/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.machines.mint;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import rebelkeithy.mods.metallurgy.machines.MetallurgyMachines;
import rebelkeithy.mods.metallurgy.machines.mint.MintRecipes;
import rebelkeithy.mods.metallurgy.machines.mint.TileEntityMintStorage;
import rebelkeithy.mods.metallurgy.metals.MetallurgyMetals;

public class TileEntityMint
extends TileEntity {
    public int direction = 0;
    private int ingotId = 0;
    public int amount = 0;
    public int resetTime = 0;
    public boolean powered = false;
    private int ticksSinceSync;
    private int timeSinceSinc;

    public void setDirection(int par1) {
        this.direction = par1;
    }

    public int getDirection() {
        return this.direction;
    }

    public void power() {
        if (this.ingotId == 0) {
            ItemStack chestItem;
            int i;
            IInventory tei;
            TileEntity te;
            for (int x = -1; x <= 1; x += 2) {
                te = this.field_70331_k.func_72796_p(this.field_70329_l + x, this.field_70330_m, this.field_70327_n);
                if (!(te instanceof TileEntityMintStorage)) continue;
                tei = (IInventory)te;
                for (i = 0; i < tei.func_70302_i_(); ++i) {
                    chestItem = tei.func_70301_a(i);
                    if (chestItem == null || MintRecipes.minting().getMintingResult(chestItem) <= 0) continue;
                    this.setIngot(i, tei);
                    return;
                }
            }
            for (int z = -1; z <= 1; z += 2) {
                te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + z);
                if (!(te instanceof TileEntityMintStorage)) continue;
                tei = (IInventory)te;
                for (i = 0; i < tei.func_70302_i_(); ++i) {
                    chestItem = tei.func_70301_a(i);
                    if (chestItem == null || MintRecipes.minting().getMintingResult(chestItem) <= 0) continue;
                    this.setIngot(i, tei);
                    return;
                }
            }
        }
        if (this.resetTime == 0) {
            this.resetTime = 10;
        }
        this.powered = true;
    }

    public void unpower() {
        this.powered = false;
    }

    public void setIngot(int index, IInventory inv) {
        if (this.ingotId == 0 && this.resetTime == 0) {
            this.amount = MintRecipes.minting().getMintingResult(inv.func_70301_a(index));
            if (this.amount != 0) {
                this.ingotId = inv.func_70301_a((int)index).field_77993_c;
                inv.func_70298_a(index, 1);
                int id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 3, this.ingotId);
            }
        }
    }

    public boolean hasIngot() {
        return this.ingotId > 0;
    }

    public ItemStack currentIngot() {
        ItemStack ret = new ItemStack(this.ingotId, 1, 0);
        if (this.ingotId != 0 && this.amount == MintRecipes.minting().getMintingResult(ret)) {
            return ret;
        }
        return null;
    }

    public void removeIngot() {
        this.ingotId = 0;
        this.amount = 0;
        int id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 3, this.ingotId);
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.direction = par1NBTTagCompound.func_74765_d("Direction");
        this.ingotId = par1NBTTagCompound.func_74765_d("Ingot");
        this.amount = par1NBTTagCompound.func_74765_d("Amount");
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("Direction", (short)this.direction);
        par1NBTTagCompound.func_74777_a("Ingot", (short)this.ingotId);
        par1NBTTagCompound.func_74777_a("Amount", (short)this.amount);
    }

    public void func_70316_g() {
        int id;
        if (this.timeSinceSinc-- == 0 && !this.field_70331_k.field_72995_K) {
            this.timeSinceSinc = 80;
            id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 2, this.resetTime);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 3, this.ingotId);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 4, this.amount);
        }
        int n = this.timeSinceSinc = this.timeSinceSinc < 0 ? 0 : this.timeSinceSinc;
        if (this.resetTime > 0) {
            --this.resetTime;
            id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 2, this.resetTime);
            if (this.resetTime == 6) {
                this.mint();
            }
        }
    }

    public boolean func_70315_b(int i, int j) {
        if (i == 1) {
            this.direction = j;
        } else if (i == 2) {
            this.resetTime = j;
        } else if (i == 3) {
            this.ingotId = j;
        } else if (i == 4) {
            this.amount = j;
        } else {
            return false;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void sendPacket() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(140);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(2);
            dos.writeInt(this.field_70329_l);
            dos.writeInt(this.field_70330_m);
            dos.writeInt(this.field_70327_n);
            dos.writeInt(this.direction);
        }
        catch (IOException e) {
            // empty catch block
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "MetallurgyFantas";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        packet.field_73287_r = true;
        if (packet != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)16.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)packet);
        }
    }

    public void mint() {
        ItemStack var7 = new ItemStack(MetallurgyMachines.coin, 1, 0);
        Random rand = new Random();
        if (!this.field_70331_k.field_72995_K && this.hasIngot()) {
            ItemStack chestItem;
            int i;
            IInventory tei;
            TileEntity te;
            for (int x = -1; x <= 1; x += 2) {
                te = this.field_70331_k.func_72796_p(this.field_70329_l + x, this.field_70330_m, this.field_70327_n);
                if (!(te instanceof IInventory) || te instanceof TileEntityMintStorage) continue;
                tei = (IInventory)te;
                for (i = 0; i < tei.func_70302_i_(); ++i) {
                    chestItem = tei.func_70301_a(i);
                    if (chestItem == null) {
                        tei.func_70299_a(i, var7);
                        this.increaseIngotMintCount();
                        return;
                    }
                    if (chestItem.field_77993_c != var7.field_77993_c || chestItem.field_77994_a >= 64) continue;
                    ++chestItem.field_77994_a;
                    this.increaseIngotMintCount();
                    return;
                }
            }
            for (int z = -1; z <= 1; z += 2) {
                te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + z);
                if (!(te instanceof IInventory) || te instanceof TileEntityMintStorage) continue;
                tei = (IInventory)te;
                for (i = 0; i < tei.func_70302_i_(); ++i) {
                    chestItem = tei.func_70301_a(i);
                    if (chestItem == null) {
                        tei.func_70299_a(i, var7);
                        this.increaseIngotMintCount();
                        return;
                    }
                    if (chestItem.field_77993_c != var7.field_77993_c || chestItem.field_77994_a >= 64) continue;
                    ++chestItem.field_77994_a;
                    this.increaseIngotMintCount();
                    return;
                }
            }
            System.out.println("mint");
            float var8 = rand.nextFloat() * 0.8f + 0.1f;
            float var9 = rand.nextFloat() * 0.8f + 0.1f;
            float var10 = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem var12 = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + var8), (double)((float)this.field_70330_m + var9), (double)((float)this.field_70327_n + var10), new ItemStack(var7.field_77993_c, 1, var7.func_77960_j()));
            if (var7.func_77942_o()) {
                var12.func_92059_d().func_77982_d((NBTTagCompound)var7.func_77978_p().func_74737_b());
            }
            float var13 = 0.05f;
            var12.field_70159_w = (float)rand.nextGaussian() * var13;
            var12.field_70181_x = (float)rand.nextGaussian() * var13 + 0.2f;
            var12.field_70179_y = (float)rand.nextGaussian() * var13;
            var12.field_70293_c = 20;
            this.field_70331_k.func_72838_d((Entity)var12);
            this.increaseIngotMintCount();
        }
    }

    public void increaseIngotMintCount() {
        if (this.amount > MintRecipes.minting().getMintingResult(new ItemStack(this.ingotId, 1, 0))) {
            this.amount = MintRecipes.minting().getMintingResult(new ItemStack(this.ingotId, 1, 0));
        }
        if (--this.amount <= 0) {
            this.ingotId = 0;
            int id = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, id, 3, this.ingotId);
        }
    }

    public String getIngotImage() {
        if (this.ingotId == MetallurgyMetals.preciousSet.getOreInfo((String)"Silver").ingot.field_77779_bT) {
            return "metallurgy:textures/blocks/machines/mint/MintSilver.png";
        }
        if (this.ingotId == MetallurgyMetals.preciousSet.getOreInfo((String)"Brass").ingot.field_77779_bT) {
            return "metallurgy:textures/blocks/machines/mint/MintBrass.png";
        }
        if (this.ingotId == MetallurgyMetals.preciousSet.getOreInfo((String)"Electrum").ingot.field_77779_bT) {
            return "metallurgy:textures/blocks/machines/mint/MintElectrum.png";
        }
        if (this.ingotId == MetallurgyMetals.preciousSet.getOreInfo((String)"Platinum").ingot.field_77779_bT) {
            return "metallurgy:textures/blocks/machines/mint/MintPlatinum.png";
        }
        if (this.ingotId == Item.field_77717_p.field_77779_bT) {
            return "metallurgy:textures/blocks/machines/mint/MintGold.png";
        }
        if (!MintRecipes.minting().getImage(this.ingotId).equals("")) {
            return MintRecipes.minting().getImage(this.ingotId);
        }
        return "metallurgy:textures/blocks/machines/mint/MintBrass.png";
    }
}

