/*
 * Decompiled with CFR 0.152.
 */
package rebelkeithy.mods.metallurgy.metals;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import rebelkeithy.mods.keithyutils.metablock.ICollisionListener;
import rebelkeithy.mods.keithyutils.metablock.IDisplayListener;
import rebelkeithy.mods.metallurgy.core.MetalInfoDatabase;
import rebelkeithy.mods.metallurgy.core.MetallurgyCore;
import rebelkeithy.mods.metallurgy.core.MetallurgyTabs;
import rebelkeithy.mods.metallurgy.core.metalsets.ISwordHitListener;
import rebelkeithy.mods.metallurgy.core.metalsets.ItemMetallurgy;
import rebelkeithy.mods.metallurgy.core.metalsets.MetalSet;
import rebelkeithy.mods.metallurgy.integration.ComputerCraftIntegration;
import rebelkeithy.mods.metallurgy.integration.IndustrialCraftIntegration;
import rebelkeithy.mods.metallurgy.integration.RailcraftIntegration;
import rebelkeithy.mods.metallurgy.integration.ThaumcraftIntegration;
import rebelkeithy.mods.metallurgy.integration.TreeCapitatorIntegration;
import rebelkeithy.mods.metallurgy.metals.CommonProxy;
import rebelkeithy.mods.metallurgy.metals.DisplayListenerOreParticles;
import rebelkeithy.mods.metallurgy.metals.DisplayListenerVulcaniteOreParticles;
import rebelkeithy.mods.metallurgy.metals.DisplayListenerVyroxeresOreParticles;
import rebelkeithy.mods.metallurgy.metals.FantasySwordHitListener;
import rebelkeithy.mods.metallurgy.metals.ItemOreFinder;
import rebelkeithy.mods.metallurgy.metals.NetherSwordHitListener;
import rebelkeithy.mods.metallurgy.metals.VyroxeresCollisionListener;
import rebelkeithy.mods.metallurgy.metals.utilityItems.ItemFertilizer;
import rebelkeithy.mods.metallurgy.metals.utilityItems.ItemIgniter;
import rebelkeithy.mods.metallurgy.metals.utilityItems.tnt.BlockLargeTNT;
import rebelkeithy.mods.metallurgy.metals.utilityItems.tnt.BlockMinersTNT;
import rebelkeithy.mods.metallurgy.metals.utilityItems.tnt.EntityLargeTNTPrimed;
import rebelkeithy.mods.metallurgy.metals.utilityItems.tnt.EntityMinersTNTPrimed;

@Mod(modid="Metallurgy3Base", name="Metallurgy 3 Base", version="3.2", dependencies="required-after:Metallurgy3Core")
@NetworkMod(channels={"MetallurgyBase"}, clientSideRequired=true, serverSideRequired=false)
public class MetallurgyMetals {
    public boolean isRelease = true;
    public static MetalSet baseSet;
    public static MetalSet preciousSet;
    public static MetalSet netherSet;
    public static MetalSet fantasySet;
    public static MetalSet enderSet;
    public static MetalSet utilitySet;
    public static CreativeTabs baseTab;
    public static CreativeTabs preciousTab;
    public static CreativeTabs netherTab;
    public static CreativeTabs fantasyTab;
    public static CreativeTabs enderTab;
    public static CreativeTabs utilityTab;
    public static Configuration baseConfig;
    public static Configuration utilityConfig;
    public static Configuration fantasyConfig;
    public static Item dustIron;
    public static Item dustGold;
    public static Item magnesiumIgniter;
    public static Item match;
    public static Item fertilizer;
    public static Item tar;
    public static Item debug;
    public static Block largeTNT;
    public static Block minersTNT;
    @SidedProxy(clientSide="rebelkeithy.mods.metallurgy.metals.ClientProxy", serverSide="rebelkeithy.mods.metallurgy.metals.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="Metallurgy3Base")
    public static MetallurgyMetals instance;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        baseConfig = this.initConfig("Base");
        baseConfig.load();
        utilityConfig = this.initConfig("Utility");
        utilityConfig.load();
        fantasyConfig = this.initConfig("Fantasy");
        baseTab = this.isSetEnabled("Base") ? new MetallurgyTabs("Metallurgy: Base") : CreativeTabs.field_78030_b;
        if (this.isSetEnabled("Precious")) {
            preciousTab = new MetallurgyTabs("Metallurgy: Precious");
        }
        if (this.isSetEnabled("Nether")) {
            netherTab = new MetallurgyTabs("Metallurgy: Nether");
        }
        if (this.isSetEnabled("Fantasy")) {
            fantasyTab = new MetallurgyTabs("Metallurgy: Fantasy");
        }
        if (this.isSetEnabled("Ender")) {
            enderTab = new MetallurgyTabs("Metallurgy: Ender");
        }
        if (this.isSetEnabled("Utility")) {
            utilityTab = new MetallurgyTabs("Metallurgy: Utility");
        }
        LanguageRegistry.instance().addStringLocalization("itemGroup.Metallurgy: Base", "Metallurgy: Base");
        LanguageRegistry.instance().addStringLocalization("itemGroup.Metallurgy: Precious", "Metallurgy: Precious");
        LanguageRegistry.instance().addStringLocalization("itemGroup.Metallurgy: Nether", "Metallurgy: Nether");
        LanguageRegistry.instance().addStringLocalization("itemGroup.Metallurgy: Fantasy", "Metallurgy: Fantasy");
        LanguageRegistry.instance().addStringLocalization("itemGroup.Metallurgy: Utility", "Metallurgy: Utility");
        LanguageRegistry.instance().addStringLocalization("itemGroup.Metallurgy: Ender", "Metallurgy: Ender");
        String filepath = event.getSourceFile().getAbsolutePath();
        if (!this.isRelease) {
            filepath = "C:/Users/Keithy/Documents/Metallurgy 3 1.5/source/Metallurgy 3/resources/mods/Metallurgy.jar";
            MetalInfoDatabase.readMetalDataFromFile("C:/Users/Keithy/Documents/Metallurgy 3 1.5/source/Metallurgy 3/resources/spreadsheet.csv");
            MetalInfoDatabase.readItemDataFromFile(utilityConfig, "C:/Users/Keithy/Documents/Metallurgy 3 1.5/source/Metallurgy 3/resources/Items.csv", utilityTab);
        } else {
            MetalInfoDatabase.readMetalDataFromJar("spreadsheet.csv", filepath);
            MetalInfoDatabase.readItemDataFromJar(utilityConfig, "Items.csv", filepath, utilityTab);
        }
        utilityConfig.save();
        baseSet = new MetalSet("Base", MetalInfoDatabase.getSpreadsheetDataForSet("Base"), baseTab);
        preciousSet = new MetalSet("Precious", MetalInfoDatabase.getSpreadsheetDataForSet("Precious"), preciousTab);
        netherSet = new MetalSet("Nether", MetalInfoDatabase.getSpreadsheetDataForSet("Nether"), netherTab);
        fantasySet = new MetalSet("Fantasy", MetalInfoDatabase.getSpreadsheetDataForSet("Fantasy"), fantasyTab);
        enderSet = new MetalSet("Ender", MetalInfoDatabase.getSpreadsheetDataForSet("Ender"), enderTab);
        utilitySet = new MetalSet("Utility", MetalInfoDatabase.getSpreadsheetDataForSet("Utility"), utilityTab);
        dustIron = new ItemMetallurgy(5100).setTextureName("Metallurgy:Vanilla/IronDust").func_77655_b("Metallurgy:Vanilla/IronDust").func_77637_a(CreativeTabs.field_78035_l);
        dustGold = new ItemMetallurgy(5101).setTextureName("Metallurgy:Vanilla/GoldDust").func_77655_b("Metallurgy:Vanilla/GoldDust").func_77637_a(CreativeTabs.field_78035_l);
        if (this.isSetEnabled("Utility")) {
            utilityConfig.load();
            this.createUtilityItems();
            utilityConfig.save();
        }
    }

    @Mod.Init
    public void Init(FMLInitializationEvent event) {
        FurnaceRecipes.func_77602_a().addSmelting(MetallurgyMetals.dustIron.field_77779_bT, 0, new ItemStack(Item.field_77703_o), 0.7f);
        FurnaceRecipes.func_77602_a().addSmelting(MetallurgyMetals.dustGold.field_77779_bT, 0, new ItemStack(Item.field_77717_p), 0.7f);
        LanguageRegistry.addName((Object)dustIron, (String)"Iron Dust");
        LanguageRegistry.addName((Object)dustGold, (String)"Gold Dust");
        OreDictionary.registerOre((String)"dustIron", (Item)dustIron);
        OreDictionary.registerOre((String)"dustGold", (Item)dustGold);
        debug = new ItemOreFinder(5102).func_77655_b("stick").func_77637_a(CreativeTabs.field_78040_i);
        if (MetallurgyMetals.fantasySet.getOreInfo((String)"Atral Silver").ore != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Astral Silver").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("FantasyOre", 0.6, 0.8, 0.95));
        }
        if (MetallurgyMetals.fantasySet.getOreInfo((String)"Carmot").ore != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Carmot").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("FantasyOre", 0.8, 0.8, 0.4));
        }
        if (MetallurgyMetals.fantasySet.getOreInfo((String)"Mithril").ore != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Mithril").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("FantasyOre", 0.6, 0.9, 0.95));
        }
        if (MetallurgyMetals.fantasySet.getOreInfo((String)"Orichalcum").ore != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Orichalcum").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("FantasyOre", 0.3, 0.5, 0.15));
        }
        if (MetallurgyMetals.fantasySet.getOreInfo((String)"Adamantine").ore != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Adamantine").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("FantasyOre", 0.5, 0.2, 0.2));
        }
        if (MetallurgyMetals.fantasySet.getOreInfo((String)"Atlarus").ore != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Atlarus").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("FantasyOre", 0.8, 0.8, 0.2));
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Midasium").ore != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Midasium").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("NetherOre", 1.0, 0.8, 0.25));
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Vyroxeres").ore != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Vyroxeres").ore.addDisplayListener((IDisplayListener)new DisplayListenerVyroxeresOreParticles());
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Ceruclase").ore != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Ceruclase").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("NetherOre", 0.35, 0.6, 0.9));
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Kalendrite").ore != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Kalendrite").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("NetherOre", 0.8, 0.4, 0.8));
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Vulcanite").ore != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Vulcanite").ore.addDisplayListener((IDisplayListener)new DisplayListenerVulcaniteOreParticles());
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").ore != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").ore.addDisplayListener((IDisplayListener)new DisplayListenerOreParticles("NetherOre", 0.85, 0.0, 0.0));
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").ore != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Vyroxeres").ore.addCollisionListener((ICollisionListener)new VyroxeresCollisionListener());
        }
        this.addRailRecipes();
        this.addSwordEffects();
        proxy.registerParticles();
        TreeCapitatorIntegration.init();
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        if (this.isSetEnabled("Base") && MetallurgyMetals.baseSet.getOreInfo((String)"Steel").helmet != null) {
            ((MetallurgyTabs)baseTab).setIconItem(MetallurgyMetals.baseSet.getOreInfo((String)"Steel").helmet.field_77779_bT);
        }
        if (this.isSetEnabled("Precious") && MetallurgyMetals.preciousSet.getOreInfo((String)"Platinum").helmet != null) {
            ((MetallurgyTabs)preciousTab).setIconItem(MetallurgyMetals.preciousSet.getOreInfo((String)"Platinum").helmet.field_77779_bT);
        }
        if (this.isSetEnabled("Nether") && MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").helmet != null) {
            ((MetallurgyTabs)netherTab).setIconItem(MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").helmet.field_77779_bT);
        }
        if (this.isSetEnabled("Fantasy") && MetallurgyMetals.fantasySet.getOreInfo((String)"Tartarite").helmet != null) {
            ((MetallurgyTabs)fantasyTab).setIconItem(MetallurgyMetals.fantasySet.getOreInfo((String)"Tartarite").helmet.field_77779_bT);
        }
        if (this.isSetEnabled("Ender") && MetallurgyMetals.enderSet.getOreInfo((String)"Desichalkos").helmet != null) {
            ((MetallurgyTabs)enderTab).setIconItem(MetallurgyMetals.enderSet.getOreInfo((String)"Desichalkos").helmet.field_77779_bT);
        }
        this.createMidasiumRecipes();
        ThaumcraftIntegration.init();
        IndustrialCraftIntegration.init();
        RailcraftIntegration.init();
        try {
            Class<?> a = Class.forName("dan200.turtle.api.TurtleAPI");
            Class<?> b = Class.forName("dan200.turtle.shared.TurtleTool");
            ComputerCraftIntegration.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isSetEnabled(String setName) {
        File fileDir = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3");
        fileDir.mkdir();
        File cfgFile = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3/Metallurgy" + setName + ".cfg");
        try {
            cfgFile.createNewFile();
            System.out.println("[Metallurgy3] Successfully created/read configuration file for Metallurgy 3's metal set " + setName);
        }
        catch (IOException e) {
            System.out.println("[Metallurgy3] Could not create configuration file for Metallurgy 3 metal set " + setName + ". Reason:");
            System.out.println(e);
        }
        Configuration config = new Configuration(cfgFile);
        config.load();
        boolean enabled = config.get("!Enable", "Enable " + setName + " Set", true).getBoolean(true);
        config.save();
        return enabled;
    }

    public void createUtilityItems() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Item.field_77731_bo), new Object[]{"I", "I", Character.valueOf('I'), "ingotVulcanite"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(dustIron, 2), new Object[]{"dustShadow Iron", "dustIgnatius"}));
        int id = utilityConfig.get("Item IDs", "HE TNT", 920).getInt();
        if (id != 0) {
            largeTNT = new BlockLargeTNT(id).func_71864_b("M3HETNT").func_71849_a(utilityTab);
            GameRegistry.registerBlock((Block)largeTNT, (String)"M3HETNT");
            EntityRegistry.registerModEntity(EntityLargeTNTPrimed.class, (String)"LargeTNTEntity", (int)113, (Object)this, (int)64, (int)10, (boolean)true);
            LanguageRegistry.addName((Object)largeTNT, (String)"HE TNT");
            if (utilityConfig.get("Recipes", "Enable HE TNT", true).getBoolean(true)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(largeTNT, 4), new Object[]{"MPM", "PTP", "MPM", Character.valueOf('M'), "dustMagnesium", Character.valueOf('P'), "dustPhosphorus", Character.valueOf('T'), Block.field_72091_am}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(largeTNT, 4), new Object[]{"PMP", "MTM", "PMP", Character.valueOf('M'), "dustMagnesium", Character.valueOf('P'), "dustPhosphorus", Character.valueOf('T'), Block.field_72091_am}));
            }
        }
        if ((id = utilityConfig.get("Item IDs", "LE TNT", 921).getInt()) != 0) {
            minersTNT = new BlockMinersTNT(id).func_71864_b("M3LETNT").func_71849_a(utilityTab);
            GameRegistry.registerBlock((Block)minersTNT, (String)"M3LETNT");
            EntityRegistry.registerModEntity(EntityMinersTNTPrimed.class, (String)"MinersTNTEntity", (int)113, (Object)this, (int)64, (int)10, (boolean)true);
            LanguageRegistry.addName((Object)minersTNT, (String)"LE TNT");
            if (utilityConfig.get("Recipes", "Enable LE TNT", true).getBoolean(true)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(minersTNT, 4), new Object[]{"MPM", "PTP", "MPM", Character.valueOf('M'), "dustSaltpeter", Character.valueOf('P'), "dustSulfur", Character.valueOf('T'), Block.field_72091_am}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(minersTNT, 4), new Object[]{"MPM", "PTP", "MPM", Character.valueOf('P'), "dustSaltpeter", Character.valueOf('M'), "dustSulfur", Character.valueOf('T'), Block.field_72091_am}));
            }
        }
        id = utilityConfig.get("Item IDs", "Magnesium Igniter", 29007).getInt();
        magnesiumIgniter = new ItemIgniter(id).setTextureName("Metallurgy:Utility/Igniter").func_77655_b("Metallurgy:Utility/Igniter").func_77637_a(utilityTab);
        LanguageRegistry.addName((Object)magnesiumIgniter, (String)"Magnesium Igniter");
        if (utilityConfig.get("Recipes", "Enable Magnesium Igniter", true).getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(magnesiumIgniter), new Object[]{"X ", " F", Character.valueOf('X'), "dustMagnesium", Character.valueOf('F'), Item.field_77709_i}));
        }
        id = utilityConfig.get("Item IDs", "Match", 29008).getInt();
        match = new ItemIgniter(id).setTextureName("Metallurgy:Utility/Match").func_77655_b("Metallurgy:Utility/Match").func_77637_a(utilityTab);
        LanguageRegistry.addName((Object)match, (String)"Match");
        if (utilityConfig.get("Recipes", "Enable Match", true).getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(match), new Object[]{"X", "|", Character.valueOf('X'), "dustPhosphorus", Character.valueOf('|'), Item.field_77669_D}));
        }
        id = utilityConfig.get("Item IDs", "Fertilizer", 29009).getInt();
        fertilizer = new ItemFertilizer(id).setTextureName("Metallurgy:Utility/Fertilizer").func_77655_b("Metallurgy:Utility/Fertilizer").func_77637_a(utilityTab);
        LanguageRegistry.addName((Object)fertilizer, (String)"Fertilizer");
        if (utilityConfig.get("Recipes", "Enable Fertilizer", true).getBoolean(true)) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(fertilizer, 8), new Object[]{"dustPhosphorus", "dustMagnesium", "dustPotash"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(fertilizer, 8), new Object[]{"dustPhosphorus", "dustMagnesium", "dustSaltpeter"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(fertilizer, 8), new Object[]{"dustPhosphorus", "dustSaltpeter", "dustPotash"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(fertilizer, 8), new Object[]{"dustSaltpeter", "dustMagnesium", "dustPotash"}));
        }
        OreDictionary.registerOre((String)"itemFertilizer", (Item)fertilizer);
        id = utilityConfig.get("Item IDs", "Tar", 29010).getInt();
        tar = new ItemMetallurgy(id).setTextureName("Metallurgy:Utility/Tar").func_77655_b("Metallurgy:Utility/Tar").func_77637_a(utilityTab);
        LanguageRegistry.addName((Object)tar, (String)"Tar");
        OreDictionary.registerOre((String)"itemTar", (Item)tar);
        GameRegistry.addSmelting((int)MetalInfoDatabase.getItem((String)"Bitumen").field_77993_c, (ItemStack)new ItemStack(tar), (float)0.1f);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Item.field_77677_M, new Object[]{new ItemStack(Item.field_77705_m, 1, 1), "dustSulfur", "dustSaltpeter"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(Item.field_77725_bx, new Object[]{"itemTar", Item.field_77722_bw}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)Block.field_71956_V, new Object[]{"T", "P", Character.valueOf('T'), "itemTar", Character.valueOf('P'), Block.field_71963_Z}));
        if (this.isSetEnabled("Utility")) {
            ((MetallurgyTabs)utilityTab).setIconItem(MetallurgyMetals.fertilizer.field_77779_bT);
        }
    }

    private void addRailRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72056_aG, 4), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotCopper", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72056_aG, 10), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotBronze", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72056_aG, 14), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotHepatizon", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72056_aG, 26), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotDamascus Steel", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72056_aG, 22), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotAngmallen", Character.valueOf('S'), Item.field_77669_D}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Block.field_72056_aG, 32), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), "ingotAngmallen", Character.valueOf('S'), Item.field_77669_D}));
    }

    public Configuration initConfig(String name) {
        File fileDir = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3");
        fileDir.mkdir();
        File cfgFile = new File(MetallurgyCore.proxy.getMinecraftDir() + "/config/Metallurgy3/Metallurgy" + name + ".cfg");
        try {
            cfgFile.createNewFile();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return new Configuration(cfgFile);
    }

    public void createMidasiumRecipes() {
        String[] ores = OreDictionary.getOreNames();
        System.out.println("Searching for dust for midsasium recipes");
        int count = 0;
        for (String name : ores) {
            if (!name.contains("dust") || name.toLowerCase().contains("tiny") || name.toLowerCase().contains("clay") || name.toLowerCase().contains("quartz")) continue;
            System.out.println("Adding recipe for " + name + " midasium = gold");
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(dustGold), new Object[]{"dustMidasium", name}));
            ++count;
        }
    }

    public void addSwordEffects() {
        ISwordHitListener swordEffects = new NetherSwordHitListener();
        MinecraftForge.EVENT_BUS.register((Object)swordEffects);
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Ignatius").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Ignatius").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Ignatius").sword.setSubText("cIgnite I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Shadow Iron").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Shadow Iron").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Shadow Iron").sword.setSubText("cWeakness I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Shadow Steel").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Shadow Steel").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Shadow Steel").sword.setSubText("7Weakness II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Midasium").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Midasium").sword.setSubText("7Looting I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Vyroxeres").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Vyroxeres").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Vyroxeres").sword.setSubText("cPoison I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Ceruclase").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Ceruclase").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Ceruclase").sword.setSubText("cSlowness");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Inolashite").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Inolashite").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Inolashite").sword.setSubText("7Poison, Slowness");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Kalendrite").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Kalendrite").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Kalendrite").sword.setSubText("7Regen");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Amordrine").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Amordrine").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Amordrine").sword.setSubText("7Healing");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Vulcanite").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Vulcanite").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Vulcanite").sword.setSubText("cIgnite II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").sword != null) {
            MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").sword.addHitListener(swordEffects);
            MetallurgyMetals.netherSet.getOreInfo((String)"Sanguinite").sword.setSubText("cWither I");
        }
        swordEffects = new FantasySwordHitListener();
        MinecraftForge.EVENT_BUS.register((Object)swordEffects);
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Deep Iron").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Deep Iron").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Deep Iron").sword.setSubText("cBlindness I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Black Steel").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Black Steel").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Black Steel").sword.setSubText("cBlindness II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Oureclase").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Oureclase").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Oureclase").sword.setSubText("7Resistance I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Astral Silver").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Astral Silver").sword.setSubText("7Looting I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Carmot").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Carmot").sword.setSubText("7Looting II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Mithril").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Mithril").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Mithril").sword.setSubText("7Haste I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Quicksilver").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Quicksilver").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Quicksilver").sword.setSubText("7Speed I");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Haderoth").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Haderoth").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Haderoth").sword.setSubText("cHaste I, Ignite II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Orichalcum").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Orichalcum").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Orichalcum").sword.setSubText("cResistance II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Celenegil").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Celenegil").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Celenegil").sword.setSubText("7Resistance III");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Adamantine").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Adamantine").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Adamantine").sword.setSubText("7Fire Resist I, Ignite II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Atlarus").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Atlarus").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Atlarus").sword.setSubText("7Strength II");
        }
        if (MetallurgyMetals.netherSet.getOreInfo((String)"Tartarite").sword != null) {
            MetallurgyMetals.fantasySet.getOreInfo((String)"Tartarite").sword.addHitListener(swordEffects);
            MetallurgyMetals.fantasySet.getOreInfo((String)"Tartarite").sword.setSubText("cWither, Igntite II");
        }
    }
}

