/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.darktower;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFCreatures;
import twilightforest.item.TFItems;
import twilightforest.structures.ComponentTFTowerRoof;
import twilightforest.structures.ComponentTFTowerRoofAttachedSlab;
import twilightforest.structures.ComponentTFTowerRoofFence;
import twilightforest.structures.ComponentTFTowerRoofGableForwards;
import twilightforest.structures.ComponentTFTowerRoofSlabForwards;
import twilightforest.structures.ComponentTFTowerWing;
import twilightforest.structures.EnumDarkTowerDoor;
import twilightforest.structures.StructureDecoratorDarkTower;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.StructureTFDecorator;
import twilightforest.structures.darktower.ComponentTFDarkTowerBalcony;
import twilightforest.structures.darktower.ComponentTFDarkTowerBeard;
import twilightforest.structures.darktower.ComponentTFDarkTowerBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoof;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofAntenna;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofCactus;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofFourPost;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofRings;

public class ComponentTFDarkTowerWing
extends ComponentTFTowerWing {
    protected boolean keyTower = false;
    protected ArrayList<EnumDarkTowerDoor> openingTypes = new ArrayList();

    protected ComponentTFDarkTowerWing(int i, int x, int y, int z2, int pSize, int pHeight, int direction) {
        super(i, x, y, z2, pSize, pHeight, direction);
    }

    @Override
    public void a(aiq parent, List list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, 2);
        this.makeARoof(parent, list, rand);
        this.makeABeard(parent, list, rand);
        if (this.size > 10) {
            for (int direction = 0; direction < 4; ++direction) {
                int[] dest = this.getValidOpening(rand, direction);
                int childSize = this.size - 2;
                int childHeight = this.validateChildHeight(this.height - 4 + rand.nextInt(10) - rand.nextInt(10), childSize);
                boolean madeWing = this.makeTowerWing(list, rand, this.c(), dest[0], dest[1], dest[2], this.size - 2, childHeight, direction);
                if (madeWing || direction != 2 && !rand.nextBoolean()) continue;
                this.makeTowerBalcony(list, rand, this.c(), dest[0], dest[1], dest[2], direction);
            }
        } else if (rand.nextInt(4) == 0) {
            int direction = rand.nextInt(4);
            int[] dest = this.getValidOpening(rand, direction);
            this.makeTowerBalcony(list, rand, this.c(), dest[0], dest[1], dest[2], direction);
        }
    }

    protected int validateChildHeight(int childHeight, int childSize) {
        return childHeight / 4 * 4 + 1;
    }

    @Override
    public void makeARoof(aiq parent, List list, Random rand) {
        ComponentTFDarkTowerRoof roof;
        int index = this.c();
        switch (rand.nextInt(5)) {
            default: {
                roof = new ComponentTFDarkTowerRoofAntenna(index, this);
                break;
            }
            case 2: {
                roof = new ComponentTFDarkTowerRoofCactus(index, this);
                break;
            }
            case 3: {
                roof = new ComponentTFDarkTowerRoofRings(index, this);
                break;
            }
            case 4: {
                roof = new ComponentTFDarkTowerRoofFourPost(index, this);
            }
        }
        list.add(roof);
        roof.a(this, list, rand);
        this.roofType = ((Object)((Object)roof)).getClass();
    }

    @Override
    protected void makeAttachedRoof(List list, Random rand) {
        ComponentTFTowerRoof roof;
        int index = this.c();
        if (this.roofType == null && rand.nextInt(32) != 0) {
            this.tryToFitRoof(list, rand, new ComponentTFTowerRoofGableForwards(index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(8) != 0) {
            this.tryToFitRoof(list, rand, new ComponentTFTowerRoofSlabForwards(index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(32) != 0) {
            roof = new ComponentTFTowerRoofAttachedSlab(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new ComponentTFTowerRoofFence(index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
    }

    @Override
    public void makeABeard(aiq parent, List list, Random rand) {
        ComponentTFDarkTowerBeard beard = new ComponentTFDarkTowerBeard(this.c() + 1, this);
        list.add(beard);
        beard.a(this, list, rand);
    }

    @Override
    public boolean makeTowerWing(List list, Random rand, int index, int x, int y, int z2, int wingSize, int wingHeight, int rotation) {
        if (wingHeight < 8) {
            return false;
        }
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z2, 5, direction);
        if (dx[1] + wingHeight > 250) {
            return false;
        }
        ComponentTFDarkTowerBridge bridge = new ComponentTFDarkTowerBridge(index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        aiq intersect = aiq.a((List)list, (age)bridge.b());
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = aiq.a((List)list, (age)bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.add(bridge);
            bridge.a(this, list, rand);
            this.addOpening(x, y, z2, rotation);
            return true;
        }
        return false;
    }

    protected boolean makeTowerBalcony(List list, Random rand, int index, int x, int y, int z2, int rotation) {
        int direction = (this.getCoordBaseMode() + rotation) % 4;
        int[] dx = this.offsetTowerCoords(x, y, z2, 5, direction);
        ComponentTFDarkTowerBalcony balcony = new ComponentTFDarkTowerBalcony(index, dx[0], dx[1], dx[2], direction);
        aiq intersect = aiq.a((List)list, (age)balcony.b());
        if (intersect == null || intersect == this) {
            list.add(balcony);
            balcony.a(this, list, rand);
            this.addOpening(x, y, z2, rotation, EnumDarkTowerDoor.REAPPEARING);
            return true;
        }
        return false;
    }

    @Override
    public boolean a(abv world, Random rand, age sbb) {
        Random decoRNG = new Random(world.H() + (long)(this.f.a * 321534781) ^ (long)(this.f.c * 756839));
        this.makeEncasedWalls(world, rand, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        this.a(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        this.nullifySkyLightForBoundingBox(world);
        if (this.size > 9) {
            this.addHalfFloors(world, decoRNG, sbb, 4, this.height - 1);
        } else if (decoRNG.nextInt(3) == 0) {
            this.addSmallTimberBeams(world, decoRNG, sbb, 4, this.height - 1);
        } else {
            this.addHalfFloors(world, decoRNG, sbb, 4, this.height - 1);
        }
        this.makeOpenings(world, sbb);
        if (decoRNG.nextBoolean() && !this.isKeyTower() && this.height > 8) {
            int blobs = 1;
            if (this.size > 9 && decoRNG.nextBoolean()) {
                ++blobs;
            }
            for (int i = 0; i < blobs; ++i) {
                int x = decoRNG.nextInt(this.size);
                int y = decoRNG.nextInt(this.height - 7) + 2;
                int z2 = decoRNG.nextInt(this.size);
                this.destroyTower(world, decoRNG, x, y, z2, 3, sbb);
            }
        }
        return true;
    }

    protected void destroyTower(abv world, Random decoRNG, int x, int y, int z2, int amount, age sbb) {
        int initialRadius = decoRNG.nextInt(amount) + amount;
        this.drawBlob(world, x, y, z2, initialRadius, 0, 0, sbb);
        for (int i = 0; i < 3; ++i) {
            int dx = x + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            int dy = y + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            int dz2 = z2 + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            this.netherTransformBlob(world, decoRNG, dx, dy, dz2, initialRadius - 1, sbb);
            this.drawBlob(world, dx, dy, dz2, initialRadius - 2, 0, 0, sbb);
        }
    }

    private void netherTransformBlob(abv world, Random inRand, int sx, int sy, int sz, int rad, age sbb) {
        Random rand = new Random(inRand.nextLong());
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz2 = 0; dz2 <= rad; dz2 = (int)((byte)(dz2 + 1))) {
                    byte dist = 0;
                    dist = dx >= dy && dx >= dz2 ? (byte)(dx + (byte)((double)Math.max(dy, dz2) * 0.5 + (double)Math.min(dy, dz2) * 0.25)) : (dy >= dx && dy >= dz2 ? (byte)(dy + (byte)((double)Math.max(dx, dz2) * 0.5 + (double)Math.min(dx, dz2) * 0.25)) : (byte)(dz2 + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > rad) continue;
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz + dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz + dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz - dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy + dy, sz + dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy + dy, sz - dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy - dy, sz + dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy - dy, sz - dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy - dy, sz + dz2, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy - dy, sz - dz2, sbb);
                }
            }
        }
    }

    private void testAndChangeToNetherrack(abv world, Random rand, int x, int y, int z2, age sbb) {
        if (this.a(world, x, y, z2, sbb) > 0) {
            this.a(world, aqw.bg.cF, 0, x, y, z2, sbb);
            if (this.a(world, x, y + 1, z2, sbb) == 0 && rand.nextBoolean()) {
                this.a(world, aqw.aw.cF, 0, x, y + 1, z2, sbb);
            }
        }
    }

    public void drawBlob(abv world, int sx, int sy, int sz, int rad, int blockValue, int metaValue, age sbb) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz2 = 0; dz2 <= rad; dz2 = (int)((byte)(dz2 + 1))) {
                    byte dist = 0;
                    dist = dx >= dy && dx >= dz2 ? (byte)(dx + (byte)((double)Math.max(dy, dz2) * 0.5 + (double)Math.min(dy, dz2) * 0.25)) : (dy >= dx && dy >= dz2 ? (byte)(dy + (byte)((double)Math.max(dx, dz2) * 0.5 + (double)Math.min(dx, dz2) * 0.25)) : (byte)(dz2 + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > rad) continue;
                    this.a(world, blockValue, metaValue, sx + dx, sy + dy, sz + dz2, sbb);
                    this.a(world, blockValue, metaValue, sx + dx, sy + dy, sz - dz2, sbb);
                    this.a(world, blockValue, metaValue, sx - dx, sy + dy, sz + dz2, sbb);
                    this.a(world, blockValue, metaValue, sx - dx, sy + dy, sz - dz2, sbb);
                    this.a(world, blockValue, metaValue, sx + dx, sy - dy, sz + dz2, sbb);
                    this.a(world, blockValue, metaValue, sx + dx, sy - dy, sz - dz2, sbb);
                    this.a(world, blockValue, metaValue, sx - dx, sy - dy, sz + dz2, sbb);
                    this.a(world, blockValue, metaValue, sx - dx, sy - dy, sz - dz2, sbb);
                }
            }
        }
    }

    protected void addHalfFloors(abv world, Random rand, age sbb, int bottom, int top) {
        int spacing = 4;
        int rotation = (this.f.b + bottom) % 3;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            rotation += 2;
            rotation %= 4;
            if (y >= top - spacing) {
                this.makeFullFloor(world, sbb, rotation, y, spacing);
                if (this.isDeadEnd()) {
                    this.decorateTreasureRoom(world, sbb, rotation, y, 4, this.deco);
                }
            } else {
                this.makeHalfFloor(world, sbb, rotation, y, spacing);
                switch (rand.nextInt(8)) {
                    case 0: {
                        if (this.size < 11) {
                            this.decorateReappearingFloor(world, rand, sbb, rotation, y);
                            break;
                        }
                    }
                    case 1: {
                        this.decorateSpawner(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 2: {
                        this.decorateLounge(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 3: {
                        this.decorateLibrary(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 4: {
                        this.decorateExperimentPulser(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 5: {
                        this.decorateExperimentLamp(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 6: {
                        this.decoratePuzzleChest(world, rand, sbb, rotation, y);
                    }
                }
            }
            this.addStairsDown(world, sbb, rotation, y, this.size - 2, spacing);
            if (this.size <= 9) continue;
            this.addStairsDown(world, sbb, rotation, y, this.size - 3, spacing);
        }
        rotation += 2;
        this.addStairsDown(world, sbb, rotation %= 4, this.height - 1, this.size - 2, spacing);
    }

    protected void makeHalfFloor(abv world, age sbb, int rotation, int y, int spacing) {
        this.fillBlocksRotated(world, sbb, this.size / 2, y, 1, this.size - 2, y, this.size - 2, this.deco.blockID, this.deco.blockMeta, rotation);
        this.fillBlocksRotated(world, sbb, this.size / 2 - 1, y, 1, this.size / 2 - 1, y, this.size - 2, this.deco.accentID, this.deco.accentMeta, rotation);
    }

    protected void makeFullFloor(abv world, age sbb, int rotation, int y, int spacing) {
        this.a(world, sbb, 1, y, 1, this.size - 2, y, this.size - 2, this.deco.blockID, this.deco.blockMeta, 0, 0, false);
        this.a(world, sbb, this.size / 2, y, 1, this.size / 2, y, this.size - 2, this.deco.accentID, this.deco.accentMeta, 0, 0, true);
    }

    protected void decorateTreasureRoom(abv world, age sbb, int rotation, int y, int spacing, StructureTFDecorator myDeco) {
        int dy;
        int x = this.size / 2;
        int z2 = this.size / 2;
        for (dy = 1; dy < spacing; ++dy) {
            this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x - 1, y + dy, z2 - 1, rotation, sbb);
            this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x + 1, y + dy, z2 - 1, rotation, sbb);
            this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x - 1, y + dy, z2 + 1, rotation, sbb);
            this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x + 1, y + dy, z2 + 1, rotation, sbb);
        }
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(1 + rotation), x + 0, y + 1, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(0 + rotation), x - 1, y + 1, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(2 + rotation), x + 1, y + 1, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(3 + rotation), x + 0, y + 1, z2 + 1, rotation, sbb);
        for (dy = 2; dy < spacing - 1; ++dy) {
            this.placeBlockRotated(world, myDeco.fenceID, myDeco.fenceMeta, x + 0, y + dy, z2 - 1, rotation, sbb);
            this.placeBlockRotated(world, myDeco.fenceID, myDeco.fenceMeta, x - 1, y + dy, z2 + 0, rotation, sbb);
            this.placeBlockRotated(world, myDeco.fenceID, myDeco.fenceMeta, x + 1, y + dy, z2 + 0, rotation, sbb);
            this.placeBlockRotated(world, myDeco.fenceID, myDeco.fenceMeta, x + 0, y + dy, z2 + 1, rotation, sbb);
        }
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(1 + rotation) + 4, x + 0, y + spacing - 1, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(0 + rotation) + 4, x - 1, y + spacing - 1, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(2 + rotation) + 4, x + 1, y + spacing - 1, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(3 + rotation) + 4, x + 0, y + spacing - 1, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, myDeco.platformID, myDeco.platformMeta, x, y + 1, z2, rotation, sbb);
        this.placeTreasureAtCurrentPosition(world, null, x, y + 2, z2, this.isKeyTower() ? TFTreasure.darktower_key : TFTreasure.darktower_cache, sbb);
        if (this.isKeyTower()) {
            this.putItemInTreasure(world, x, y + 2, z2, new yd(TFItems.towerKey), sbb);
        }
    }

    private void decorateSpawner(abv world, Random rand, age sbb, int rotation, int y) {
        int z2;
        int x = this.size > 9 ? 4 : 3;
        int n = z2 = this.size > 9 ? 5 : 4;
        String mobID = this.size > 9 ? (rand.nextBoolean() ? TFCreatures.getSpawnerNameFor("Tower Golem") : TFCreatures.getSpawnerNameFor("Redscale Broodling")) : TFCreatures.getSpawnerNameFor("Redscale Broodling");
        this.makePillarFrame(world, sbb, this.deco, rotation, x, y, z2, true);
        this.placeSpawnerRotated(world, x + 1, y + 2, z2 + 1, rotation, mobID, sbb);
    }

    private void decorateLounge(abv world, Random rand, age sbb, int rotation, int y) {
        int cx = this.size > 9 ? 9 : 7;
        int cz = this.size > 9 ? 4 : 3;
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation), cx, y + 1, cz + 0, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation), cx, y + 1, cz + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation), cx, y + 1, cz + 2, rotation, sbb);
        cx = this.size > 9 ? 5 : 3;
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation) + 4, cx, y + 1, cz + 0, rotation, sbb);
        this.placeBlockRotated(world, aqw.bT.cF, 9, cx, y + 1, cz + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation) + 4, cx, y + 1, cz + 2, rotation, sbb);
    }

    private void decorateReappearingFloor(abv world, Random rand, age sbb, int rotation, int y) {
        this.fillBlocksRotated(world, sbb, 4, y, 3, 7, y, 5, TFBlocks.towerDevice.cF, 0, rotation);
        this.fillBlocksRotated(world, sbb, 4, y + 1, 2, 7, y + 1, 2, aqw.aR.cF, 0, rotation);
        this.fillBlocksRotated(world, sbb, 4, y + 1, 6, 7, y + 1, 6, aqw.aR.cF, 0, rotation);
    }

    private void decorateExperimentLamp(abv world, Random rand, age sbb, int rotation, int y) {
        int cx = this.size > 9 ? 5 : 3;
        int cz = this.size > 9 ? 5 : 4;
        this.placeBlockRotated(world, aqw.aa.cF, 1, cx, y + 1, cz, rotation, sbb);
        this.placeBlockRotated(world, aqw.bQ.cF, 0, cx, y + 2, cz, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, cx, y + 1, cz + 1, rotation, sbb);
        this.placeBlockRotated(world, aqw.aO.cF, this.getLeverMeta(rotation, 3), cx, y + 1, cz + 2, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, cx, y + 3, cz - 1, rotation, sbb);
        this.placeBlockRotated(world, aqw.aO.cF, this.getLeverMeta(rotation, 2) + 8, cx, y + 3, cz - 2, rotation, sbb);
    }

    private void decorateExperimentPulser(abv world, Random rand, age sbb, int rotation, int y) {
        int cx = this.size > 9 ? 6 : 5;
        int cz = this.size > 9 ? 4 : 3;
        this.placeBlockRotated(world, aqw.aa.cF, 5 - this.getStairMeta(3 + rotation), cx, y + 1, cz + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, cx, y + 1, cz, rotation, sbb);
        this.placeBlockRotated(world, aqw.aA.cF, 0, cx + 1, y + 1, cz, rotation, sbb);
        this.placeBlockRotated(world, aqw.aR.cF, 0, cx + 2, y + 1, cz, rotation, sbb);
        this.placeBlockRotated(world, aqw.bm.cF, (rotation + 1) % 4 + 4, cx - 1, y + 1, cz, rotation, sbb);
        this.placeBlockRotated(world, aqw.aA.cF, 0, cx - 2, y + 1, cz, rotation, sbb);
        this.placeBlockRotated(world, aqw.aA.cF, 0, cx - 2, y + 1, cz + 1, rotation, sbb);
        this.placeBlockRotated(world, aqw.aA.cF, 0, cx - 1, y + 1, cz + 1, rotation, sbb);
    }

    private void decorateLibrary(abv world, Random rand, age sbb, int rotation, int y) {
        int bx2 = this.size > 9 ? 4 : 3;
        int bz = this.size > 9 ? 3 : 2;
        this.makeSmallBookshelf(world, sbb, rotation, y, bx2, bz);
        bx2 = this.size > 9 ? 9 : 7;
        bz = this.size > 9 ? 3 : 2;
        this.makeSmallBookshelf(world, sbb, rotation, y, bx2, bz);
    }

    protected void makeSmallBookshelf(abv world, age sbb, int rotation, int y, int bx2, int bz) {
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation) + 0, bx2, y + 1, bz + 0, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(1 + rotation) + 4, bx2, y + 2, bz + 0, rotation, sbb);
        this.placeBlockRotated(world, aqw.as.cF, 0, bx2, y + 1, bz + 1, rotation, sbb);
        this.placeBlockRotated(world, aqw.as.cF, 0, bx2, y + 2, bz + 1, rotation, sbb);
        this.placeBlockRotated(world, aqw.as.cF, 0, bx2, y + 1, bz + 2, rotation, sbb);
        this.placeBlockRotated(world, aqw.as.cF, 0, bx2, y + 2, bz + 2, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation) + 0, bx2, y + 1, bz + 3, rotation, sbb);
        this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(3 + rotation) + 4, bx2, y + 2, bz + 3, rotation, sbb);
    }

    private void decoratePuzzleChest(abv world, Random rand, age sbb, int rotation, int y) {
        int x = this.size > 9 ? 4 : 3;
        int z2 = this.size > 9 ? 5 : 4;
        this.makePillarFrame(world, sbb, this.deco, rotation, x, y, z2, true);
        this.placeBlockRotated(world, this.deco.platformID, this.deco.platformMeta, x + 1, y + 1, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 2, y + 1, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 0, y + 1, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 1, y + 1, z2 + 2, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 1, y + 1, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 2, y + 3, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 0, y + 3, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 1, y + 3, z2 + 2, rotation, sbb);
        this.placeBlockRotated(world, 0, 0, x + 1, y + 3, z2 + 0, rotation, sbb);
        this.placeBlockRotated(world, this.deco.blockID, this.deco.blockMeta, x + 1, y + 3, z2 + 1, rotation, sbb);
        this.placeBlockRotated(world, aqw.aa.cF, 5 - this.getStairMeta(1 + rotation), x + 1, y + 3, z2 - 1, rotation, sbb);
        this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, x + 1, y + 3, z2 - 2, rotation, sbb);
        this.placeBlockRotated(world, aqw.aO.cF, this.getLeverMeta(rotation, 5), x + 2, y + 3, z2 - 2, rotation, sbb);
        this.placeTreasureRotated(world, x + 1, y + 2, z2 + 1, rotation, TFTreasure.darktower_cache, sbb);
    }

    protected void makePillarFrame(abv world, age sbb, StructureTFDecorator myDeco, int rotation, int x, int y, int z2, boolean fenced) {
        this.makePillarFrame(world, sbb, myDeco, rotation, x, y, z2, 3, 3, 3, fenced);
    }

    protected void makePillarFrame(abv world, age sbb, StructureTFDecorator myDeco, int rotation, int x, int y, int z2, int width, int height, int length, boolean fenced) {
        for (int dx = 0; dx < width; ++dx) {
            for (int dz2 = 0; dz2 < length; ++dz2) {
                if (!(dx % 3 != 0 && dx != width - 1 || dz2 % 3 != 0 && dz2 != length - 1)) {
                    for (int py = 1; py <= height; ++py) {
                        this.placeBlockRotated(world, myDeco.pillarID, myDeco.pillarMeta, x + dx, y + py, z2 + dz2, rotation, sbb);
                    }
                    continue;
                }
                if (dx == 0) {
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(0 + rotation), x + dx, y + 1, z2 + dz2, rotation, sbb);
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(0 + rotation) + 4, x + dx, y + height, z2 + dz2, rotation, sbb);
                } else if (dx == width - 1) {
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(2 + rotation), x + dx, y + 1, z2 + dz2, rotation, sbb);
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(2 + rotation) + 4, x + dx, y + height, z2 + dz2, rotation, sbb);
                } else if (dz2 == 0) {
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(1 + rotation), x + dx, y + 1, z2 + dz2, rotation, sbb);
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(1 + rotation) + 4, x + dx, y + height, z2 + dz2, rotation, sbb);
                } else if (dz2 == length - 1) {
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(3 + rotation), x + dx, y + 1, z2 + dz2, rotation, sbb);
                    this.placeBlockRotated(world, myDeco.stairID, this.getStairMeta(3 + rotation) + 4, x + dx, y + height, z2 + dz2, rotation, sbb);
                }
                if (!fenced || dx != 0 && dx != width - 1 && dz2 != 0 && dz2 != length - 1) continue;
                for (int fy = 2; fy <= height - 1; ++fy) {
                    this.placeBlockRotated(world, myDeco.fenceID, myDeco.fenceMeta, x + dx, y + fy, z2 + dz2, rotation, sbb);
                }
            }
        }
    }

    protected void putItemInTreasure(abv world, int x, int y, int z2, yd itemToAdd, age sbb) {
        asm tileEntity;
        int dz2;
        int dy;
        int dx = this.a(x, z2);
        if (sbb.b(dx, dy = this.a(y), dz2 = this.b(x, z2)) && (tileEntity = world.r(dx, dy, dz2)) != null && tileEntity instanceof mn) {
            mn inventory = (mn)tileEntity;
            boolean alreadyPresent = false;
            int emptySlots = 0;
            for (int i = 0; i < inventory.j_(); ++i) {
                yd inSlot = inventory.a(i);
                if (inSlot == null) {
                    ++emptySlots;
                    continue;
                }
                if (!yd.b((yd)inSlot, (yd)itemToAdd)) continue;
                alreadyPresent = true;
                break;
            }
            if (!alreadyPresent && emptySlots > 0) {
                int slotsUntilPlaced = world.s.nextInt(emptySlots);
                for (int i = 0; i < inventory.j_(); ++i) {
                    yd inSlot = inventory.a(i);
                    if (inSlot != null) continue;
                    if (slotsUntilPlaced == 0) {
                        inventory.a(i, itemToAdd);
                        break;
                    }
                    --slotsUntilPlaced;
                }
            }
        }
    }

    protected void addStairsDown(abv world, age sbb, int rotation, int y, int sz, int spacing) {
        for (int i = 0; i < spacing; ++i) {
            int sx = this.size - 3 - i;
            this.placeBlockRotated(world, this.deco.stairID, this.getStairMeta(0 + rotation), sx, y - i, sz, rotation, sbb);
            this.placeBlockRotated(world, this.deco.accentID, this.deco.accentMeta, sx, y - 1 - i, sz, rotation, sbb);
            this.placeBlockRotated(world, 0, 0, sx, y + 1 - i, sz, rotation, sbb);
            this.placeBlockRotated(world, 0, 0, sx, y + 2 - i, sz, rotation, sbb);
            this.placeBlockRotated(world, 0, 0, sx - 1, y + 2 - i, sz, rotation, sbb);
            this.placeBlockRotated(world, 0, 0, sx, y + 3 - i, sz, rotation, sbb);
            this.placeBlockRotated(world, 0, 0, sx - 1, y + 3 - i, sz, rotation, sbb);
        }
    }

    protected void addSmallTimberBeams(abv world, Random rand, age sbb, int bottom, int top) {
        int spacing = 4;
        int rotation = 0;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            ++rotation;
            rotation %= 4;
            if (y >= top - spacing && this.isDeadEnd()) {
                this.makeTimberFloor(world, rand, sbb, rotation, y, spacing);
                StructureDecoratorDarkTower logDeco = new StructureDecoratorDarkTower();
                logDeco.pillarID = TFBlocks.log.cF;
                logDeco.pillarMeta = 3;
                logDeco.platformID = TFBlocks.log.cF;
                logDeco.pillarMeta = 3;
                this.decorateTreasureRoom(world, sbb, rotation, y, 4, logDeco);
                continue;
            }
            this.makeSmallTimberBeams(world, rand, sbb, rotation, y, y == bottom && bottom != spacing, y >= top - spacing);
        }
    }

    protected void makeTimberFloor(abv world, Random rand, age sbb, int rotation, int y, int spacing) {
        int beamID = TFBlocks.log.cF;
        int beamMetaBase = 3;
        int beamMetaNS = (this.g + rotation) % 2 == 0 ? 4 : 8;
        int beamMetaEW = beamMetaNS == 4 ? 8 : 4;
        int beamMetaUD = 0;
        for (int z2 = 1; z2 < this.size - 1; ++z2) {
            for (int x = 1; x < this.size - 1; ++x) {
                if (x < z2) {
                    this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaNS, x, y, z2, rotation, sbb);
                    continue;
                }
                this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaEW, x, y, z2, rotation, sbb);
            }
        }
        for (int by = 1; by < 4; ++by) {
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, 2, y - by, 2, rotation, sbb);
            this.placeBlockRotated(world, aqw.aK.cF, this.getLadderMeta(2 + rotation), 3, y - by, 2, rotation, sbb);
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, 6, y - by, 6, rotation, sbb);
            this.placeBlockRotated(world, aqw.aK.cF, this.getLadderMeta(4 + rotation), 5, y - by, 6, rotation, sbb);
        }
        this.placeBlockRotated(world, 0, 0, 3, y, 2, rotation, sbb);
        this.placeBlockRotated(world, 0, 0, 5, y, 6, rotation, sbb);
    }

    protected void makeSmallTimberBeams(abv world, Random rand, age sbb, int rotation, int y, boolean bottom, boolean top) {
        int z2;
        int beamID = TFBlocks.log.cF;
        int beamMetaBase = 3;
        int beamMetaNS = (this.g + rotation) % 2 == 0 ? 4 : 8;
        int beamMetaEW = beamMetaNS == 4 ? 8 : 4;
        int beamMetaUD = 0;
        for (z2 = 1; z2 < this.size - 1; ++z2) {
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaEW, 2, y, z2, rotation, sbb);
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaEW, 6, y, z2, rotation, sbb);
        }
        z2 = this.pickBetweenExcluding(3, this.size - 3, rand, 2, 2, 6);
        for (int x = 3; x < 6; ++x) {
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaNS, x, y, z2, rotation, sbb);
        }
        int x1 = 2;
        int z1 = rand.nextBoolean() ? 2 : 6;
        int x3 = 6;
        int z3 = rand.nextBoolean() ? 2 : 6;
        for (int by = 1; by < 4; ++by) {
            if (!bottom || this.checkPost(world, x1, y - 4, z1, rotation, sbb)) {
                this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, x1, y - by, z1, rotation, sbb);
                this.placeBlockRotated(world, aqw.aK.cF, this.getLadderMeta(2 + rotation), x1 + 1, y - by, z1, rotation, sbb);
            }
            if (bottom && !this.checkPost(world, x3, y - 4, z3, rotation, sbb)) continue;
            this.placeBlockRotated(world, beamID, beamMetaBase + beamMetaUD, x3, y - by, z3, rotation, sbb);
            this.placeBlockRotated(world, aqw.aK.cF, this.getLadderMeta(4 + rotation), x3 - 1, y - by, z3, rotation, sbb);
        }
    }

    protected int pickBetweenExcluding(int low, int high, Random rand, int k, int l, int m) {
        int result;
        while ((result = rand.nextInt(high - low) + low) == k || result == l || result == m) {
        }
        return result;
    }

    protected int pickFrom(Random rand, int i, int j, int k) {
        switch (rand.nextInt(3)) {
            default: {
                return i;
            }
            case 1: {
                return j;
            }
            case 2: 
        }
        return k;
    }

    protected boolean checkPost(abv world, int x, int y, int z2, int rotation, age sbb) {
        int worldZ;
        int worldY;
        int worldX = this.getXWithOffsetAsIfRotated(x, z2, rotation);
        int blockID = sbb.b(worldX, worldY = this.a(y), worldZ = this.getZWithOffsetAsIfRotated(x, z2, rotation)) ? world.a(worldX, worldY, worldZ) : 0;
        return blockID != 0 && (blockID != this.deco.accentID || world.h(worldX, worldY, worldZ) != this.deco.accentMeta);
    }

    protected void makeEncasedWalls(abv world, Random rand, age sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z2 != minZ && z2 != maxZ) continue;
                    if (!((x != minY && x != maxX || y != minY && y != maxY && z2 != minZ && z2 != maxZ) && (y != minY && y != maxY || x != minY && x != maxX && z2 != minZ && z2 != maxZ) && (z2 != minZ && z2 != maxZ || x != minY && x != maxX && y != minY && y != maxY))) {
                        this.a(world, this.deco.accentID, this.deco.accentMeta, x, y, z2, sbb);
                        continue;
                    }
                    air blocker = StructureTFComponent.getTowerWoods();
                    blocker.a(rand, x, y, z2, true);
                    this.a(world, blocker.a(), blocker.b(), x, y, z2, sbb);
                }
            }
        }
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, minY + 1, minZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, minY + 1, maxZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, minY + 1, minZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, minY + 1, maxZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, maxY - 1, minZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, maxY - 1, maxZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, maxY - 1, minZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, maxY - 1, maxZ, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX, minY + 1, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX, minY + 1, maxZ - 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX, minY + 1, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX, minY + 1, maxZ - 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX, maxY - 1, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX, maxY - 1, maxZ - 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX, maxY - 1, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX, maxY - 1, maxZ - 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, minY, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, minY, maxZ - 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, minY, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, minY, maxZ - 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, maxY, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, minX + 1, maxY, maxZ - 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, maxY, minZ + 1, sbb);
        this.a(world, this.deco.accentID, this.deco.accentMeta, maxX - 1, maxY, maxZ - 1, sbb);
    }

    @Override
    public int[] getValidOpening(Random rand, int direction) {
        int verticalOffset;
        int n = verticalOffset = this.size == 19 ? 5 : 4;
        if (direction == 0 || direction == 2) {
            int rx2 = direction == 0 ? this.size - 1 : 0;
            int rz = this.size / 2;
            int ry2 = this.height - verticalOffset;
            return new int[]{rx2, ry2, rz};
        }
        if (direction == 1 || direction == 3) {
            int rx3 = this.size / 2;
            int rz = direction == 1 ? this.size - 1 : 0;
            int ry3 = this.height - verticalOffset;
            return new int[]{rx3, ry3, rz};
        }
        return new int[]{0, 0, 0};
    }

    @Override
    public void addOpening(int dx, int dy, int dz2, int direction) {
        this.addOpening(dx, dy, dz2, direction, EnumDarkTowerDoor.VANISHING);
    }

    protected void addOpening(int dx, int dy, int dz2, int direction, EnumDarkTowerDoor type) {
        super.addOpening(dx, dy, dz2, direction);
        this.openingTypes.add(this.openings.indexOf(new t(dx, dy, dz2)), type);
    }

    @Override
    protected void makeOpenings(abv world, age sbb) {
        block4: for (int i = 0; i < this.openings.size(); ++i) {
            t doorCoords = (t)this.openings.get(i);
            EnumDarkTowerDoor doorType = this.openingTypes.get(i);
            switch (doorType) {
                default: {
                    this.makeDoorOpening(world, doorCoords.a, doorCoords.b, doorCoords.c, sbb);
                    continue block4;
                }
                case REAPPEARING: {
                    this.makeReappearingDoorOpening(world, doorCoords.a, doorCoords.b, doorCoords.c, sbb);
                    continue block4;
                }
                case LOCKED: {
                    this.makeLockedDoorOpening(world, doorCoords.a, doorCoords.b, doorCoords.c, sbb);
                }
            }
        }
    }

    @Override
    protected void makeDoorOpening(abv world, int dx, int dy, int dz2, age sbb) {
        this.nullifySkyLightAtCurrentPosition(world, dx - 3, dy - 1, dz2 - 3, dx + 3, dy + 3, dz2 + 3);
        if (dx == 0 || dx == this.size - 1) {
            this.a(world, sbb, dx, dy - 1, dz2 - 2, dx, dy + 3, dz2 + 2, this.deco.accentID, this.deco.accentMeta, 0, 0, false);
            this.a(world, sbb, dx, dy, dz2 - 1, dx, dy + 2, dz2 + 1, TFBlocks.towerDevice.cF, 2, 0, 0, false);
        }
        if (dz2 == 0 || dz2 == this.size - 1) {
            this.a(world, sbb, dx - 2, dy - 1, dz2, dx + 2, dy + 3, dz2, this.deco.accentID, this.deco.accentMeta, 0, 0, false);
            this.a(world, sbb, dx - 1, dy, dz2, dx + 1, dy + 2, dz2, TFBlocks.towerDevice.cF, 2, 0, 0, false);
        }
    }

    protected void makeReappearingDoorOpening(abv world, int dx, int dy, int dz2, age sbb) {
        this.nullifySkyLightAtCurrentPosition(world, dx - 3, dy - 1, dz2 - 3, dx + 3, dy + 3, dz2 + 3);
        if (dx == 0 || dx == this.size - 1) {
            this.a(world, sbb, dx, dy - 1, dz2 - 2, dx, dy + 3, dz2 + 2, this.deco.accentID, this.deco.accentMeta, 0, 0, false);
            this.a(world, sbb, dx, dy, dz2 - 1, dx, dy + 2, dz2 + 1, TFBlocks.towerDevice.cF, 0, 0, 0, false);
        }
        if (dz2 == 0 || dz2 == this.size - 1) {
            this.a(world, sbb, dx - 2, dy - 1, dz2, dx + 2, dy + 3, dz2, this.deco.accentID, this.deco.accentMeta, 0, 0, false);
            this.a(world, sbb, dx - 1, dy, dz2, dx + 1, dy + 2, dz2, TFBlocks.towerDevice.cF, 0, 0, 0, false);
        }
    }

    protected void makeLockedDoorOpening(abv world, int dx, int dy, int dz2, age sbb) {
        this.nullifySkyLightAtCurrentPosition(world, dx - 3, dy - 1, dz2 - 3, dx + 3, dy + 3, dz2 + 3);
        if (dx == 0 || dx == this.size - 1) {
            this.a(world, sbb, dx, dy - 1, dz2 - 2, dx, dy + 3, dz2 + 2, this.deco.accentID, this.deco.accentMeta, 0, 0, false);
            this.a(world, sbb, dx, dy, dz2 - 1, dx, dy + 2, dz2 + 1, TFBlocks.towerDevice.cF, 2, 0, 0, false);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx, dy + 0, dz2 + 1, sbb);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx, dy + 0, dz2 - 1, sbb);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx, dy + 2, dz2 + 1, sbb);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx, dy + 2, dz2 - 1, sbb);
        }
        if (dz2 == 0 || dz2 == this.size - 1) {
            this.a(world, sbb, dx - 2, dy - 1, dz2, dx + 2, dy + 3, dz2, this.deco.accentID, this.deco.accentMeta, 0, 0, false);
            this.a(world, sbb, dx - 1, dy, dz2, dx + 1, dy + 2, dz2, TFBlocks.towerDevice.cF, 2, 0, 0, false);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx + 1, dy + 0, dz2, sbb);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx - 1, dy + 0, dz2, sbb);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx + 1, dy + 2, dz2, sbb);
            this.a(world, TFBlocks.towerDevice.cF, 4, dx - 1, dy + 2, dz2, sbb);
        }
    }

    @Override
    public boolean isDeadEnd() {
        int nonBalconies = 0;
        for (EnumDarkTowerDoor type : this.openingTypes) {
            if (type == EnumDarkTowerDoor.REAPPEARING) continue;
            ++nonBalconies;
        }
        return nonBalconies <= 1;
    }

    public boolean isKeyTower() {
        return this.keyTower;
    }

    public void setKeyTower(boolean keyTower) {
        this.keyTower = keyTower;
    }

    protected int getLeverMeta(int rotation, int direction) {
        if (direction == 0) {
            return 0;
        }
        if (direction == 1) {
            return 5;
        }
        rotation += this.getCoordBaseMode();
        if ((rotation %= 4) == 0) {
            switch (direction) {
                case 2: {
                    return 4;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 1;
                }
            }
        } else if (rotation == 1) {
            switch (direction) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 3;
                }
            }
        } else if (rotation == 2) {
            switch (direction) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
            }
        } else if (rotation == 3) {
            switch (direction) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
            }
        }
        return -1;
    }
}

