/*
 * Decompiled with CFR 0.152.
 */
package tconstruct;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.common.TContent;
import tconstruct.common.TProxyCommon;
import tconstruct.landmine.logic.behavior.Behavior;
import tconstruct.landmine.logic.behavior.stackCombo.SpecialStackHandler;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.Detailing;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.util.TabTools;
import tconstruct.util.PHConstruct;
import tconstruct.util.TCraftingHandler;
import tconstruct.util.TEventHandler;
import tconstruct.util.network.TPacketHandler;
import tconstruct.util.player.TPlayerHandler;
import tconstruct.worldgen.SlimeIslandGen;
import tconstruct.worldgen.TBaseWorldGenerator;
import tconstruct.worldgen.TerrainGenEventHandler;
import tconstruct.worldgen.village.TVillageTrades;
import tconstruct.worldgen.village.VillageSmelteryHandler;
import tconstruct.worldgen.village.VillageToolStationHandler;

@Mod(modid="TConstruct", name="TConstruct", version="1.6.2_1.4.dev.27", dependencies="required-after:Forge@[7.7.1.687,)")
@NetworkMod(serverSideRequired=false, clientSideRequired=true, channels={"TConstruct"}, packetHandler=TPacketHandler.class)
public class TConstruct {
    public static final int ingotLiquidValue = 144;
    public static final int liquidUpdateAmount = 6;
    @Mod.Instance(value="TConstruct")
    public static TConstruct instance;
    @SidedProxy(clientSide="tconstruct.client.TProxyClient", serverSide="tconstruct.common.TProxyCommon")
    public static TProxyCommon proxy;
    public static TContent content;
    public static TEventHandler events;
    public static TPlayerHandler playerTracker;
    public static LiquidCasting tableCasting;
    public static LiquidCasting basinCasting;
    public static Detailing chiselDetailing;

    public TConstruct() {
        if (Loader.isModLoaded((String)"Natura")) {
            System.out.println("[TConstruct] Natura, what are we going to do tomorrow night?");
            System.out.println("[Natura] TConstruct, we're going to take over the world!");
        } else {
            System.out.println("[TConstruct] Preparing to take over the world");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PHConstruct.initProps(event.getModConfigurationDirectory());
        TConstructRegistry.materialTab = new TabTools("TConstructMaterials");
        TConstructRegistry.toolTab = new TabTools("TConstructTools");
        TConstructRegistry.blockTab = new TabTools("TConstructBlocks");
        tableCasting = new LiquidCasting();
        basinCasting = new LiquidCasting();
        chiselDetailing = new Detailing();
        content = new TContent();
        events = new TEventHandler();
        events.unfuxOreDictionary();
        MinecraftForge.EVENT_BUS.register((Object)events);
        content.oreRegistry();
        proxy.registerRenderer();
        proxy.registerTickHandler();
        proxy.addNames();
        proxy.readManuals();
        proxy.registerKeys();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TBaseWorldGenerator());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TerrainGenEventHandler());
        GameRegistry.registerFuelHandler((IFuelHandler)content);
        GameRegistry.registerCraftingHandler((ICraftingHandler)new TCraftingHandler());
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        VillagerRegistry.instance().registerVillageTradeHandler(78943, (VillagerRegistry.IVillageTradeHandler)new TVillageTrades());
        if (PHConstruct.addToVillages) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageToolStationHandler());
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageSmelteryHandler());
        }
        playerTracker = new TPlayerHandler();
        GameRegistry.registerPlayerTracker((IPlayerTracker)playerTracker);
        MinecraftForge.EVENT_BUS.register((Object)playerTracker);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        content.intermodCommunication();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new SlimeIslandGen(TContent.slimePool.field_71990_ca, 0));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Behavior.registerBuiltInBehaviors();
        SpecialStackHandler.registerBuiltInStackHandlers();
        content.modIntegration();
        content.createEntities();
        content.modRecipes();
    }

    public static LiquidCasting getTableCasting() {
        return tableCasting;
    }

    public static LiquidCasting getBasinCasting() {
        return basinCasting;
    }

    public static Detailing getChiselDetailing() {
        return chiselDetailing;
    }
}

