/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.GlowstoneAggregator;
import tconstruct.common.TProxyCommon;
import tconstruct.crystal.TheftValueTracker;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.blocks.InventoryBlock;

public class Aggregator
extends InventoryBlock {
    public String[] textureNames = new String[]{"glowstone_top", "glowstone_top_inactive", "glowstone_side", "glowstone_bottom"};
    public Icon[] icons;

    public Aggregator(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(2.0f);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71900_a(1.0f);
    }

    @Override
    public int func_71899_b(int meta) {
        return meta;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:machines/aggregator_" + this.textureNames[i]);
        }
    }

    public Icon func_71895_b(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        if (side == 1) {
            GlowstoneAggregator logic = (GlowstoneAggregator)iblockaccess.func_72796_p(x, y, z);
            if (logic.getActive()) {
                return this.icons[0];
            }
            return this.icons[1];
        }
        return this.func_71858_a(side, iblockaccess.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (side == 0) {
            return this.icons[3];
        }
        if (side == 1) {
            return this.icons[1];
        }
        return this.icons[2];
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.func_71860_a(world, x, y, z, entityliving, stack);
        if (!world.field_72995_K) {
            TheftValueTracker.updateCrystallinity(world.field_73011_w.field_76574_g, x, z, 4);
        }
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        super.func_71852_a(world, x, y, z, par5, par6);
        TheftValueTracker.updateCrystallinity(world.field_73011_w.field_76574_g, x, z, -4);
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack(id, 1, 0));
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new GlowstoneAggregator();
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return TProxyCommon.glowstoneAggregatorGui;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    @Override
    public String[] getTextureNames() {
        return this.textureNames;
    }

    public void updateCrystalValue(World world, int x, int y, int z) {
        GlowstoneAggregator logic = (GlowstoneAggregator)world.func_72796_p(x, y, z);
        logic.updateCrystalValue();
    }
}

