/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.inventory.DrawbridgeContainer;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.blocks.InventoryLogic;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;
import tconstruct.util.player.FakePlayerLogic;

public class DrawbridgeLogic
extends InventoryLogic
implements IFacingLogic,
IActiveLogic {
    boolean active;
    boolean working;
    int ticks;
    byte extension;
    byte direction;
    byte placementDirection = (byte)4;
    FakePlayerLogic fakePlayer;

    public DrawbridgeLogic() {
        super(2);
    }

    public void func_70308_a(World par1World) {
        this.field_70331_k = par1World;
        this.fakePlayer = new FakePlayerLogic(this.field_70331_k, "Player.Drawbridge", this);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean flag) {
        this.active = flag;
        this.working = true;
    }

    @Override
    public byte getRenderDirection() {
        return this.direction;
    }

    @Override
    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Override
    public void setDirection(int side) {
    }

    @Override
    public boolean canDropInventorySlot(int slot) {
        return false;
    }

    @Override
    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void setPlacementDirection(byte keycode) {
        if (keycode == 4) {
            this.fakePlayer.field_70177_z = 0.0f;
            this.fakePlayer.field_70125_A = 0.0f;
        } else if (this.direction == 0 || this.direction == 1) {
            switch (keycode) {
                case 0: {
                    this.fakePlayer.field_70177_z = 0.0f;
                    break;
                }
                case 1: {
                    this.fakePlayer.field_70177_z = 90.0f;
                    break;
                }
                case 2: {
                    this.fakePlayer.field_70177_z = 180.0f;
                    break;
                }
                case 3: {
                    this.fakePlayer.field_70177_z = 270.0f;
                }
            }
            this.fakePlayer.field_70125_A = this.direction == 0 ? -90.0f : 90.0f;
        } else if (keycode == 0) {
            this.fakePlayer.field_70177_z = this.mapDirection() * 90;
            this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
        } else if (keycode == 2) {
            int face = this.mapDirection() + 2;
            if (face > 3) {
                face -= 4;
            }
            this.fakePlayer.field_70177_z = face * 90;
            this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
        } else {
            this.fakePlayer.field_70125_A = 0.0f;
            int facing = this.mapDirection();
            facing = keycode == 1 ? ++facing : --facing;
            if (facing >= 4) {
                facing = 0;
            }
            if (facing < 0) {
                facing = 3;
            }
            this.fakePlayer.field_70177_z = facing * 90;
        }
        this.placementDirection = keycode;
    }

    int mapDirection() {
        if (this.direction == 2) {
            return 0;
        }
        if (this.direction == 5) {
            return 1;
        }
        if (this.direction == 3) {
            return 2;
        }
        return 3;
    }

    public byte getPlacementDirection() {
        return this.placementDirection;
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new DrawbridgeContainer(inventoryplayer, this);
    }

    @Override
    protected String getDefaultName() {
        return "tinker.drawbridge";
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        if (slot == 1) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        if (slot == 1) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return stack;
    }

    public void func_70316_g() {
        if (this.working) {
            ++this.ticks;
            if (this.ticks == 5) {
                this.ticks = 0;
                if (this.active) {
                    if (this.inventory[0] != null && this.inventory[0].field_77994_a > 1 && this.extension < 15) {
                        this.extension = (byte)(this.extension + 1);
                        int xPos = this.field_70329_l;
                        int yPos = this.field_70330_m;
                        int zPos = this.field_70327_n;
                        switch (this.direction) {
                            case 0: {
                                yPos -= this.extension;
                                break;
                            }
                            case 1: {
                                yPos += this.extension;
                                break;
                            }
                            case 2: {
                                zPos -= this.extension;
                                break;
                            }
                            case 3: {
                                zPos += this.extension;
                                break;
                            }
                            case 4: {
                                xPos -= this.extension;
                                break;
                            }
                            case 5: {
                                xPos += this.extension;
                            }
                        }
                        Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                        if (block == null || block.isAirBlock(this.field_70331_k, xPos, yPos, zPos) || block.isBlockReplaceable(this.field_70331_k, xPos, yPos, zPos)) {
                            int blockToItem = TConstructRegistry.blockToItemMapping[this.inventory[0].field_77993_c];
                            if (blockToItem == 0) {
                                if (this.inventory[0].field_77993_c >= 4096 || Block.field_71973_m[this.inventory[0].field_77993_c] == null) {
                                    return;
                                }
                                Block placeBlock = Block.field_71973_m[this.inventory[0].field_77993_c];
                                this.placeBlockAt(this.inventory[0], (EntityPlayer)this.fakePlayer, this.field_70331_k, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.inventory[0].func_77960_j(), placeBlock);
                            } else {
                                Block placeBlock = Block.field_71973_m[blockToItem];
                                this.placeBlockAt(this.inventory[0], (EntityPlayer)this.fakePlayer, this.field_70331_k, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.inventory[0].func_77960_j(), placeBlock);
                            }
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.out", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.6f);
                            --this.inventory[0].field_77994_a;
                        } else {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                        }
                    } else {
                        this.working = false;
                    }
                } else if ((this.inventory[0] == null || this.inventory[0].field_77994_a < this.inventory[0].func_77976_d()) && this.extension > 0) {
                    int xPos = this.field_70329_l;
                    int yPos = this.field_70330_m;
                    int zPos = this.field_70327_n;
                    switch (this.direction) {
                        case 0: {
                            yPos -= this.extension;
                            break;
                        }
                        case 1: {
                            yPos += this.extension;
                            break;
                        }
                        case 2: {
                            zPos -= this.extension;
                            break;
                        }
                        case 3: {
                            zPos += this.extension;
                            break;
                        }
                        case 4: {
                            xPos -= this.extension;
                            break;
                        }
                        case 5: {
                            xPos += this.extension;
                        }
                    }
                    Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                    if (block != null) {
                        int meta = this.field_70331_k.func_72805_g(xPos, yPos, zPos);
                        if (this.inventory[0] != null && this.validBlock(block) && this.validMetadata(block.field_71990_ca, meta)) {
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.in", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.15f + 0.6f);
                            if (this.field_70331_k.func_94575_c(xPos, yPos, zPos, 0)) {
                                ++this.inventory[0].field_77994_a;
                            }
                        } else {
                            this.working = false;
                        }
                    }
                    this.extension = (byte)(this.extension - 1);
                } else {
                    this.working = false;
                }
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata, Block block) {
        if (!world.func_72832_d(x, y, z, block.field_71990_ca, metadata, 3)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == block.field_71990_ca) {
            block.func_71860_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_85105_g(world, x, y, z, metadata);
        }
        return true;
    }

    boolean validBlock(Block block) {
        int type = TConstructRegistry.interchangableBlockMapping[block.field_71990_ca];
        if (type != 0 && type == this.inventory[0].field_77993_c) {
            return true;
        }
        int blockToItem = TConstructRegistry.blockToItemMapping[block.field_71990_ca];
        if (blockToItem != 0 && blockToItem == this.inventory[0].field_77993_c) {
            return true;
        }
        return block.field_71990_ca == this.inventory[0].field_77993_c;
    }

    boolean validMetadata(int blockID, int metadata) {
        int type = TConstructRegistry.drawbridgeState[blockID];
        if (type == 0) {
            return metadata == this.inventory[0].func_77960_j();
        }
        if (type == 1) {
            return true;
        }
        if (type == 2) {
            return false;
        }
        if (type == 3) {
            return true;
        }
        if (type == 4) {
            return true;
        }
        if (type == 5) {
            return metadata == this.inventory[0].func_77960_j();
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.active = tags.func_74767_n("Active");
        this.working = tags.func_74767_n("Working");
        this.extension = tags.func_74771_c("Extension");
        this.readCustomNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74757_a("Working", this.working);
        tags.func_74774_a("Extension", this.extension);
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.placementDirection = tags.func_74771_c("Placement");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74774_a("Placement", this.placementDirection);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean hasExtended() {
        return this.extension != 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

