/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import tconstruct.library.tools.ToolCore;

public class ToolCoreRenderer
implements IItemRenderer {
    private static final int toolIcons = 10;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
            default: {
                System.out.println("[TCon] Unhandled render case!");
            }
            case FIRST_PERSON_MAP: 
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return this.handleRenderType(item, type) & helper.ordinal() < IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK.ordinal();
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int i;
        EntityPlayer player;
        ItemStack itemInUse;
        ToolCore tool = (ToolCore)item.func_77973_b();
        boolean isInventory = type == IItemRenderer.ItemRenderType.INVENTORY;
        Entity ent = null;
        if (data.length > 1) {
            ent = (Entity)data[1];
        }
        int iconParts = 10;
        Icon[] tempParts = new Icon[iconParts];
        if (!isInventory && ent instanceof EntityPlayer && (itemInUse = (player = (EntityPlayer)ent).func_71011_bu()) != null) {
            int useCount = player.func_71052_bv();
            int i2 = iconParts;
            while (i2-- > 0) {
                tempParts[i2] = tool.getIcon(item, i2, player, itemInUse, useCount);
            }
        } else {
            int i3 = iconParts;
            while (i3-- > 0) {
                tempParts[i3] = tool.getIcon(item, i3);
            }
        }
        int count = 0;
        Icon[] parts = new Icon[iconParts];
        for (int i4 = 0; i4 < iconParts; ++i4) {
            Icon part = tempParts[i4];
            if (part == null || part == ToolCore.blankSprite | part == ToolCore.emptyIcon) {
                ++count;
                continue;
            }
            parts[i4 - count] = part;
        }
        if ((iconParts -= count) <= 0) {
            iconParts = 1;
        }
        Tessellator tess = Tessellator.field_78398_a;
        float[] xMax = new float[iconParts];
        float[] yMin = new float[iconParts];
        float[] xMin = new float[iconParts];
        float[] yMax = new float[iconParts];
        int[] sheetWidth = new int[iconParts];
        int[] sheetHeight = new int[iconParts];
        float depth = 0.0625f;
        float[] width = new float[iconParts];
        float[] height = new float[iconParts];
        float[] xDiff = new float[iconParts];
        float[] yDiff = new float[iconParts];
        for (i = 0; i < iconParts; ++i) {
            Icon icon = parts[i];
            xMin[i] = icon.func_94209_e();
            xMax[i] = icon.func_94212_f();
            yMin[i] = icon.func_94206_g();
            yMax[i] = icon.func_94210_h();
            sheetWidth[i] = icon.func_94211_a();
            sheetHeight[i] = icon.func_94216_b();
            width[i] = (float)sheetWidth[i] * (xMax[i] - xMin[i]);
            height[i] = (float)sheetHeight[i] * (yMax[i] - yMin[i]);
            xDiff[i] = xMin[i] - xMax[i];
            yDiff[i] = yMin[i] - yMax[i];
        }
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glDisable((int)2896);
            tess.func_78382_b();
            for (i = 0; i < iconParts; ++i) {
                tess.func_78374_a(0.0, 16.0, 0.0, (double)xMin[i], (double)yMax[i]);
                tess.func_78374_a(16.0, 16.0, 0.0, (double)xMax[i], (double)yMax[i]);
                tess.func_78374_a(16.0, 0.0, 0.0, (double)xMax[i], (double)yMin[i]);
                tess.func_78374_a(0.0, 0.0, 0.0, (double)xMin[i], (double)yMin[i]);
            }
            tess.func_78381_a();
            GL11.glEnable((int)2896);
        } else {
            int i5;
            float iconPos;
            int k;
            GL11.glEnable((int)32826);
            switch (type) {
                case EQUIPPED_FIRST_PERSON: {
                    break;
                }
                case EQUIPPED: {
                    GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                    break;
                }
                case ENTITY: {
                    GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                    break;
                }
            }
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 0.0f, 1.0f);
            for (i = 0; i < iconParts; ++i) {
                tess.func_78374_a(0.0, 0.0, 0.0, (double)xMax[i], (double)yMax[i]);
                tess.func_78374_a(1.0, 0.0, 0.0, (double)xMin[i], (double)yMax[i]);
                tess.func_78374_a(1.0, 1.0, 0.0, (double)xMin[i], (double)yMin[i]);
                tess.func_78374_a(0.0, 1.0, 0.0, (double)xMax[i], (double)yMin[i]);
            }
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 0.0f, -1.0f);
            for (i = 0; i < iconParts; ++i) {
                tess.func_78374_a(0.0, 1.0, (double)(-depth), (double)xMax[i], (double)yMin[i]);
                tess.func_78374_a(1.0, 1.0, (double)(-depth), (double)xMin[i], (double)yMin[i]);
                tess.func_78374_a(1.0, 0.0, (double)(-depth), (double)xMin[i], (double)yMax[i]);
                tess.func_78374_a(0.0, 0.0, (double)(-depth), (double)xMax[i], (double)yMax[i]);
            }
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(-1.0f, 0.0f, 0.0f);
            for (int i6 = 0; i6 < iconParts; ++i6) {
                k = 0;
                while ((float)k < width[i6]) {
                    float pos = (float)k / width[i6];
                    iconPos = xMax[i6] + xDiff[i6] * pos - 0.5f / (float)sheetWidth[i6];
                    tess.func_78374_a((double)pos, 0.0, (double)(-depth), (double)iconPos, (double)yMax[i6]);
                    tess.func_78374_a((double)pos, 0.0, 0.0, (double)iconPos, (double)yMax[i6]);
                    tess.func_78374_a((double)pos, 1.0, 0.0, (double)iconPos, (double)yMin[i6]);
                    tess.func_78374_a((double)pos, 1.0, (double)(-depth), (double)iconPos, (double)yMin[i6]);
                    ++k;
                }
            }
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(1.0f, 0.0f, 0.0f);
            for (i5 = 0; i5 < iconParts; ++i5) {
                k = 0;
                while ((float)k < width[i5]) {
                    float pos = (float)k / width[i5];
                    iconPos = xMax[i5] + xDiff[i5] * pos - 0.5f / (float)sheetWidth[i5];
                    float posEnd = pos + 1.0f / width[i5];
                    tess.func_78374_a((double)posEnd, 1.0, (double)(-depth), (double)iconPos, (double)yMin[i5]);
                    tess.func_78374_a((double)posEnd, 1.0, 0.0, (double)iconPos, (double)yMin[i5]);
                    tess.func_78374_a((double)posEnd, 0.0, 0.0, (double)iconPos, (double)yMax[i5]);
                    tess.func_78374_a((double)posEnd, 0.0, (double)(-depth), (double)iconPos, (double)yMax[i5]);
                    ++k;
                }
            }
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(0.0f, 1.0f, 0.0f);
            for (i5 = 0; i5 < iconParts; ++i5) {
                k = 0;
                while ((float)k < height[i5]) {
                    float pos = (float)k / height[i5];
                    iconPos = yMax[i5] + yDiff[i5] * pos - 0.5f / (float)sheetHeight[i5];
                    float posEnd = pos + 1.0f / height[i5];
                    tess.func_78374_a(0.0, (double)posEnd, 0.0, (double)xMax[i5], (double)iconPos);
                    tess.func_78374_a(1.0, (double)posEnd, 0.0, (double)xMin[i5], (double)iconPos);
                    tess.func_78374_a(1.0, (double)posEnd, (double)(-depth), (double)xMin[i5], (double)iconPos);
                    tess.func_78374_a(0.0, (double)posEnd, (double)(-depth), (double)xMax[i5], (double)iconPos);
                    ++k;
                }
            }
            tess.func_78381_a();
            tess.func_78382_b();
            tess.func_78375_b(0.0f, -1.0f, 0.0f);
            for (i5 = 0; i5 < iconParts; ++i5) {
                k = 0;
                while ((float)k < height[i5]) {
                    float pos = (float)k / height[i5];
                    iconPos = yMax[i5] + yDiff[i5] * pos - 0.5f / (float)sheetHeight[i5];
                    tess.func_78374_a(1.0, (double)pos, 0.0, (double)xMin[i5], (double)iconPos);
                    tess.func_78374_a(0.0, (double)pos, 0.0, (double)xMax[i5], (double)iconPos);
                    tess.func_78374_a(0.0, (double)pos, (double)(-depth), (double)xMax[i5], (double)iconPos);
                    tess.func_78374_a(1.0, (double)pos, (double)(-depth), (double)xMin[i5], (double)iconPos);
                    ++k;
                }
            }
            tess.func_78381_a();
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }
}

