/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import tconstruct.blocks.logic.ToolStationLogic;
import tconstruct.client.gui.GuiButtonTool;
import tconstruct.client.gui.NewContainerGui;
import tconstruct.inventory.ActiveContainer;
import tconstruct.inventory.ToolStationContainer;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.client.ToolGuiElement;
import tconstruct.library.tools.ToolCore;

@SideOnly(value=Side.CLIENT)
public class ToolStationGui
extends NewContainerGui {
    public ToolStationLogic logic;
    public ToolStationContainer toolSlots;
    public GuiTextField text;
    public String toolName;
    public int guiType;
    public int[] slotX;
    public int[] slotY;
    public int[] iconX;
    public int[] iconY;
    public boolean active;
    public String title;
    public String body = "";
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/toolstation.png");
    private static final ResourceLocation icons = new ResourceLocation("tinker", "textures/gui/icons.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");

    public ToolStationGui(InventoryPlayer inventoryplayer, ToolStationLogic stationlogic, World world, int x, int y, int z) {
        super((ActiveContainer)stationlogic.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = stationlogic;
        this.toolSlots = (ToolStationContainer)this.container;
        this.text = new GuiTextField(this.field_73886_k, this.xSize / 2 - 5, 8, 30, 12);
        this.text.func_73804_f(40);
        this.text.func_73786_a(false);
        this.text.func_73790_e(true);
        this.text.func_73805_d(false);
        this.text.func_73796_b(true);
        this.text.func_73794_g(0xFFFFFF);
        this.toolName = "";
        this.resetGui();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            int gLeft = this.guiLeft + 68;
            int gTop = this.guiTop + 6;
            int gWidth = 102;
            int gHeight = 12;
            this.active = mouseX > gLeft && mouseX < gLeft + gWidth && mouseY > gTop && mouseY < gTop + gHeight;
        }
    }

    void resetGui() {
        this.text.func_73782_a("");
        this.guiType = 0;
        this.setSlotType(0);
        this.iconX = new int[]{0, 1, 2};
        this.iconY = new int[]{13, 13, 13};
        this.title = "\u00a7nRepair and Modification";
        this.body = "The main way to repair or change your tools. Place a tool and a material on the left to get started.";
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int cornerX = (this.field_73880_f - this.xSize) / 2;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        this.field_73887_h.clear();
        ToolGuiElement repair = TConstructClientRegistry.toolButtons.get(0);
        GuiButtonTool repairButton = new GuiButtonTool(0, cornerX - 110, cornerY, repair.buttonIconX, repair.buttonIconY, repair.domain, repair.texture, repair);
        repairButton.field_73742_g = false;
        this.field_73887_h.add(repairButton);
        for (int iter = 1; iter < TConstructClientRegistry.toolButtons.size(); ++iter) {
            ToolGuiElement element = TConstructClientRegistry.toolButtons.get(iter);
            GuiButtonTool button = new GuiButtonTool(iter, cornerX - 110 + 22 * (iter % 5), cornerY + 22 * (iter / 5), element.buttonIconX, element.buttonIconY, repair.domain, element.texture, element);
            this.field_73887_h.add(button);
        }
    }

    protected void func_73875_a(GuiButton button) {
        ((GuiButton)this.field_73887_h.get((int)this.guiType)).field_73742_g = true;
        this.guiType = button.field_73741_f;
        button.field_73742_g = false;
        ToolGuiElement element = TConstructClientRegistry.toolButtons.get(this.guiType);
        this.setSlotType(element.slotType);
        this.iconX = element.iconsX;
        this.iconY = element.iconsY;
        this.title = "\u00a7n" + element.title;
        this.body = element.body;
    }

    void setSlotType(int type) {
        switch (type) {
            case 0: {
                this.slotX = new int[]{56, 38, 38};
                this.slotY = new int[]{37, 28, 46};
                break;
            }
            case 1: {
                this.slotX = new int[]{56, 56, 56};
                this.slotY = new int[]{19, 55, 37};
                break;
            }
            case 2: {
                this.slotX = new int[]{56, 56, 14};
                this.slotY = new int[]{28, 46, 37};
                break;
            }
            case 3: {
                this.slotX = new int[]{38, 47, 56};
                this.slotY = new int[]{28, 46, 28};
                break;
            }
            case 7: {
                this.slotX = new int[]{56, 56, 56};
                this.slotY = new int[]{19, 37, 55};
            }
        }
        this.toolSlots.resetSlots(this.slotX, this.slotY);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.text.func_73780_a();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"crafters.ToolStation"), 6, 8, 0);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.ySize - 96 + 2, 0);
        this.field_73886_k.func_78276_b(this.toolName + "_", this.xSize / 2 - 18, 8, 0xFFFFFF);
        if (this.logic.isStackInSlot(0)) {
            this.drawToolStats();
        } else {
            this.drawToolInformation();
        }
    }

    void drawToolStats() {
        ItemStack stack = this.logic.func_70301_a(0);
        if (stack.func_77973_b() instanceof ToolCore) {
            ToolCore tool = (ToolCore)stack.func_77973_b();
            NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
            this.func_73732_a(this.field_73886_k, "\u00a7n" + tool.getToolName(), this.xSize + 63, 8, 0xFFFFFF);
            this.drawModularToolStats(stack, tool, tags);
        }
    }

    void drawModularToolStats(ItemStack stack, ToolCore tool, NBTTagCompound tags) {
        List<String> categories = Arrays.asList(tool.toolCategories());
        int durability = tags.func_74762_e("Damage");
        int maxDur = tags.func_74762_e("TotalDurability");
        int availableDurability = maxDur - durability;
        int base = 24;
        int offset = 0;
        if (maxDur > 0) {
            if (maxDur >= 10000) {
                this.field_73886_k.func_78276_b("Durability:", this.xSize + 8, base + offset * 11, 0xFFFFFF);
                this.field_73886_k.func_78276_b("- " + availableDurability + "/" + maxDur, this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
                ++offset;
            } else {
                this.field_73886_k.func_78276_b("Durability: " + availableDurability + "/" + maxDur, this.xSize + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
        }
        float stonebound = tags.func_74760_g("Shoddy");
        if (categories.contains("weapon")) {
            String heart;
            int attack = tags.func_74762_e("Attack");
            float stoneboundDamage = (float)Math.log((float)durability / 72.0f + 1.0f) * -2.0f * stonebound;
            if ((attack = (int)((float)attack + stoneboundDamage)) < 1) {
                attack = 1;
            }
            String string = heart = attack == 2 ? " Heart" : " Hearts";
            if (attack % 2 == 0) {
                this.field_73886_k.func_78276_b("Attack: " + attack / 2 + heart, this.xSize + 8, base + offset * 10, 0xFFFFFF);
            } else {
                this.field_73886_k.func_78276_b("Attack: " + (float)attack / 2.0f + heart, this.xSize + 8, base + offset * 10, 0xFFFFFF);
            }
            ++offset;
            if (stoneboundDamage != 0.0f) {
                heart = stoneboundDamage == 2.0f ? " Heart" : " Hearts";
                String bloss = stoneboundDamage > 0.0f ? "Bonus: " : "Loss: ";
                this.field_73886_k.func_78276_b(bloss + (int)stoneboundDamage / 2 + heart, this.xSize + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
            ++offset;
        }
        if (categories.contains("bow")) {
            DecimalFormat df = new DecimalFormat("##.##");
            df.setRoundingMode(RoundingMode.DOWN);
            int drawSpeed = tags.func_74762_e("DrawSpeed");
            float flightSpeed = tags.func_74760_g("FlightSpeed");
            float trueDraw = (float)drawSpeed / 20.0f * flightSpeed;
            this.field_73886_k.func_78276_b("Draw Speed: " + df.format(trueDraw) + "s", this.xSize + 8, base + offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b("Arrow Speed: " + df.format(flightSpeed) + "x", this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        }
        if (categories.contains("ammo")) {
            String heart;
            DecimalFormat df = new DecimalFormat("##.##");
            df.setRoundingMode(RoundingMode.DOWN);
            int attack = tags.func_74762_e("Attack");
            float mass = tags.func_74760_g("Mass");
            float shatter = tags.func_74760_g("BreakChance");
            float accuracy = tags.func_74760_g("Accuracy");
            this.field_73886_k.func_78276_b("Base Attack:", this.xSize + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            String string = heart = attack == 2 ? " Heart" : " Hearts";
            if (attack % 2 == 0) {
                this.field_73886_k.func_78276_b("- " + attack / 2 + heart, this.xSize + 8, base + offset * 10, 0xFFFFFF);
            } else {
                this.field_73886_k.func_78276_b("- " + (float)attack / 2.0f + heart, this.xSize + 8, base + offset * 10, 0xFFFFFF);
            }
            int minAttack = attack;
            int maxAttack = attack * 2;
            heart = " Hearts";
            this.field_73886_k.func_78276_b("Shortbow Attack:", this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b(df.format((float)minAttack / 2.0f) + "-" + df.format((float)maxAttack / 2.0f) + heart, this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            this.field_73886_k.func_78276_b("Weight: " + df.format(mass), this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b("Accuracy: " + df.format(accuracy - 4.0f) + "%", this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        }
        if (categories.contains("dualharvest")) {
            float mineSpeed = (float)tags.func_74762_e("MiningSpeed") / 100.0f;
            float mineSpeed2 = (float)tags.func_74762_e("MiningSpeed2") / 100.0f;
            float stoneboundSpeed = (float)Math.log((float)durability / 90.0f + 1.0f) * 2.0f * stonebound;
            DecimalFormat df = new DecimalFormat("##.##");
            df.setRoundingMode(RoundingMode.DOWN);
            float trueSpeed = mineSpeed + stoneboundSpeed;
            float trueSpeed2 = mineSpeed + stoneboundSpeed;
            this.field_73886_k.func_78276_b("Mining Speeds: ", this.xSize + 8, base + offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b("- " + df.format(trueSpeed) + ", " + df.format(trueSpeed2), this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            if (stoneboundSpeed != 0.0f) {
                String bloss = stoneboundSpeed > 0.0f ? "Bonus: " : "Loss: ";
                this.field_73886_k.func_78276_b(bloss + df.format(stoneboundSpeed), this.xSize + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
            this.field_73886_k.func_78276_b("Harvest Levels:", this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            this.field_73886_k.func_78276_b("- " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel")) + ", " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel2")), this.xSize + 8, base + ++offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        } else if (categories.contains("harvest")) {
            float mineSpeed = tags.func_74762_e("MiningSpeed");
            int heads = 1;
            if (tags.func_74764_b("MiningSpeed2")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeed2");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedHandle")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedHandle");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedExtra")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedExtra");
                ++heads;
            }
            float trueSpeed = mineSpeed / ((float)heads * 100.0f);
            float stoneboundSpeed = (float)Math.log((float)durability / 90.0f + 1.0f) * 2.0f * stonebound;
            DecimalFormat df = new DecimalFormat("##.##");
            df.setRoundingMode(RoundingMode.DOWN);
            trueSpeed += stoneboundSpeed;
            if (trueSpeed < 0.0f) {
                trueSpeed = 0.0f;
            }
            this.field_73886_k.func_78276_b("Mining Speed: " + df.format(trueSpeed), this.xSize + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            if (stoneboundSpeed != 0.0f) {
                String bloss = stoneboundSpeed > 0.0f ? "Bonus: " : "Loss: ";
                this.field_73886_k.func_78276_b(bloss + df.format(stoneboundSpeed), this.xSize + 8, base + offset * 10, 0xFFFFFF);
                ++offset;
            }
            this.field_73886_k.func_78276_b("Mining Level: " + this.getHarvestLevelName(tags.func_74762_e("HarvestLevel")), this.xSize + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        } else if (categories.contains("utility")) {
            float mineSpeed = tags.func_74762_e("MiningSpeed");
            float trueSpeed = mineSpeed / 100.0f;
            this.field_73886_k.func_78276_b("Usage Speed: " + trueSpeed, this.xSize + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
            ++offset;
        }
        int modifiers = tags.func_74762_e("Modifiers");
        if (modifiers > 0) {
            this.field_73886_k.func_78276_b("Modifiers remaining: " + tags.func_74762_e("Modifiers"), this.xSize + 8, base + offset * 10, 0xFFFFFF);
            ++offset;
        }
        if (tags.func_74764_b("Tooltip1")) {
            this.field_73886_k.func_78276_b("Modifiers:", this.xSize + 8, base + offset * 10, 0xFFFFFF);
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "ModifierTip" + ++tipNum;
            if (tags.func_74764_b(tooltip)) {
                String tipName = tags.func_74779_i(tooltip);
                this.field_73886_k.func_78276_b("- " + tipName, this.xSize + 8, base + (offset + tipNum) * 10, 0xFFFFFF);
                continue;
            }
            displayToolTips = false;
        }
    }

    void drawToolInformation() {
        this.func_73732_a(this.field_73886_k, this.title, this.xSize + 63, 8, 0xFFFFFF);
        this.field_73886_k.func_78279_b(this.body, this.xSize + 8, 24, 115, 0xFFFFFF);
    }

    String getHarvestLevelName(int num) {
        switch (num) {
            case 0: {
                return "Stone";
            }
            case 1: {
                return "Iron";
            }
            case 2: {
                return "Redstone";
            }
            case 3: {
                return "Obsidian";
            }
            case 4: {
                return "Cobalt";
            }
            case 5: {
                return "Manyullyn";
            }
        }
        return String.valueOf(num);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(background);
        int cornerX = (this.field_73880_f - this.xSize) / 2;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, this.xSize, this.ySize);
        if (this.active) {
            this.func_73729_b(cornerX + 62, cornerY, 0, this.ySize, 112, 22);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(icons);
        for (int i = 0; i < this.slotX.length; ++i) {
            this.func_73729_b(cornerX + this.slotX[i] - 4, cornerY + this.slotY[i] - 4, 140, 212, 28, 28);
            if (this.logic.isStackInSlot(i + 1)) continue;
            this.func_73729_b(cornerX + this.slotX[i], cornerY + this.slotY[i], 18 * this.iconX[i], 18 * this.iconY[i], 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(description);
        cornerX = (this.field_73880_f + this.xSize) / 2;
        cornerY = (this.field_73881_g - this.ySize) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, 126, this.ySize + 30);
    }

    @Override
    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == 1 || !this.active && keyCode == this.field_73882_e.field_71474_y.field_74315_B.field_74512_d) {
            this.logic.setToolname("");
            this.updateServer("");
            Keyboard.enableRepeatEvents((boolean)false);
            this.field_73882_e.field_71439_g.func_71053_j();
        } else if (this.active) {
            this.text.func_73802_a(par1, keyCode);
            this.toolName = this.text.func_73781_b().trim();
            this.logic.setToolname(this.toolName);
            this.updateServer(this.toolName);
        }
    }

    void updateServer(String name) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeByte(1);
            outputStream.writeInt(this.logic.field_70331_k.field_73011_w.field_76574_g);
            outputStream.writeInt(this.logic.field_70329_l);
            outputStream.writeInt(this.logic.field_70330_m);
            outputStream.writeInt(this.logic.field_70327_n);
            outputStream.writeUTF(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "TConstruct";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToServer((Packet)packet);
    }
}

