/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.common;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.common.TContent;
import tconstruct.entity.MiniGardy;
import tconstruct.inventory.ArmorExtendedContainer;
import tconstruct.inventory.KnapsackContainer;
import tconstruct.inventory.MiniGardyContainer;
import tconstruct.landmine.inventory.ContainerLandmine;
import tconstruct.landmine.tileentity.TileEntityLandmine;
import tconstruct.library.blocks.InventoryLogic;
import tconstruct.util.player.TPlayerStats;

public class TProxyCommon
implements IGuiHandler {
    public static int stationGuiID = 0;
    public static int partGuiID = 1;
    public static int pchestGuiID = 2;
    public static int pshaperGuiID = 3;
    public static int frypanGuiID = 4;
    public static int toolForge = 5;
    public static int smelteryGuiID = 7;
    public static int glowstoneAggregatorGui = 8;
    public static int drawbridgeGui = 9;
    public static int landmineGui = 10;
    public static int craftingStationID = 11;
    public static int inventoryGui = 100;
    public static int armorGuiID = 101;
    public static int knapsackGuiID = 102;
    public static int miniGardyGui = 131;
    public static int manualGuiID = -1;
    public static final String[] shardNames = new String[]{"Wood", "Stone Shard", "Iron Chunk", "Flint Shard", "Cactus Shard", "Bone", "Obsidian Shard", "Netherrack Shard", "Slime Crystal Fragment", "Paper", "Cobalt Chunk", "Ardite Chunk", "Manyullyn Chunk", "Copper Chunk", "Bronze Chunk", "Alumite Chunk", "Steel Chunk", "Slime Crystal Fragment"};
    public static final String[] toolMaterialNames = new String[]{"Wood", "Stone", "Iron", "Flint", "Cactus", "Bone", "Obsidian", "Netherrack", "Slime", "Paper", "Cobalt", "Ardite", "Manyullyn", "Copper", "Bronze", "Alumite", "Steel", "Blue Slime", "", "", "", "", "", "", "", "", "", "", "", "", "", "Thaumium"};
    public static final String[] materialTypes = new String[]{"ToolRod", "PickaxeHead", "ShovelHead", "AxeHead", "SwordBlade", "LargeGuard", "MediumGuard", "Crossbar", "Binding", "FrypanHead", "SignHead", "LumberHead", "KnifeBlade", "ChiselHead", "ScytheBlade", "LumberHead", "ThickRod", "ThickBinding", "LargeSwordBlade", "LargePlate", "ExcavatorHead", "HammerHead", "FullGuard", "Bowstring", "Fletching", "Arrowhead"};
    public static final String[] materialNames = new String[]{" Rod", " Pickaxe Head", " Shovel Head", " Axe Head", " Sword Blade", " Wide Guard", " Hand Guard", " Crossbar", " Binding", " Pan", " Board", " Broad Axe Head", " Knife Blade", " Chisel Head", " Scythe Blade", " Broad Axe Head", " Tough Tool Rod", " Tough Binding", " Large Sword Blade", " Large Plate", " Excavator Head", " Hammer Head", " Full Guard", " Bowstring", " Fletching", " Arrowhead"};
    public static final String[] patterns = new String[]{"ingot", "rod", "pickaxe", "shovel", "axe", "swordblade", "largeguard", "mediumguard", "crossbar", "binding", "frypan", "sign", "knifeblade", "chisel", "largerod", "toughbinding", "largeplate", "broadaxe", "scythe", "excavator", "largeblade", "hammerhead", "fullguard", "bowstring", "fletching", "arrowhead"};
    public static final String[] patternNames = new String[]{"Ingot", "Tool Rod", "Pickaxe Head", "Shovel Head", "Axe Head", "Sword Blade", "Wide Guard", "Hand Guard", "Crossbar", "Tool Binding", "Pan", "Board", "Knife Blade", "Chisel Head", "Tough Tool Rod", "Tough Binding", "Large Plate", "Broad Axe Head", "Scythe Head", "Broad Shovel Head", "Large Blade", "Hammer Head", "Full Guard", "Bowstring", "Fletching", "Arrowhead"};

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == landmineGui) {
            return new ContainerLandmine(player, (TileEntityLandmine)world.func_72796_p(x, y, z));
        }
        if (ID < 0) {
            return null;
        }
        if (ID < 100) {
            TileEntity tile = world.func_72796_p(x, y, z);
            if (tile != null && tile instanceof InventoryLogic) {
                return ((InventoryLogic)tile).getGuiContainer(player.field_71071_by, world, x, y, z);
            }
        } else {
            if (ID == inventoryGui) {
                return player.field_71069_bz;
            }
            if (ID == armorGuiID) {
                TPlayerStats stats = TConstruct.playerTracker.getPlayerStats(player.field_71092_bJ);
                return new ArmorExtendedContainer(player.field_71071_by, stats.armor);
            }
            if (ID == knapsackGuiID) {
                TPlayerStats stats = TConstruct.playerTracker.getPlayerStats(player.field_71092_bJ);
                return new KnapsackContainer(player.field_71071_by, stats.knapsack);
            }
            if (ID == miniGardyGui) {
                for (Object o : world.field_72996_f) {
                    Entity entity = (Entity)o;
                    if (entity.field_70157_k != x) continue;
                    return new MiniGardyContainer(player.field_71071_by, (MiniGardy)entity);
                }
                return null;
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void registerTickHandler() {
    }

    public void registerRenderer() {
    }

    public void addNames() {
        int i;
        String[] langFiles;
        String langDir = "/assets/tinker/lang/";
        for (String langFile : langFiles = new String[]{"en_US.xml"}) {
            try {
                LanguageRegistry.instance().loadLocalization(langDir + langFile, langFile.substring(langFile.lastIndexOf(47) + 1, langFile.lastIndexOf(46)), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int mat = 0; mat < materialTypes.length; ++mat) {
            for (int type = 0; type < toolMaterialNames.length; ++type) {
                String internalName = "item.tconstruct." + materialTypes[mat] + "." + toolMaterialNames[type] + ".name";
                String visibleName = toolMaterialNames[type] + materialNames[mat];
                LanguageRegistry.instance().addStringLocalization(internalName, "en_US", visibleName);
            }
        }
        for (i = 0; i < shardNames.length; ++i) {
            String internalName = "item.tconstruct.ToolShard." + toolMaterialNames[i] + ".name";
            String visibleName = shardNames[i];
            LanguageRegistry.instance().addStringLocalization(internalName, "en_US", visibleName);
        }
        for (i = 0; i < patterns.length; ++i) {
            String internalName = "item.tconstruct.Pattern." + patterns[i] + ".name";
            String visibleName = patternNames[i] + " Pattern";
            LanguageRegistry.instance().addStringLocalization(internalName, "en_US", visibleName);
            internalName = "item.tconstruct.MetalPattern." + patterns[i] + ".name";
            visibleName = patternNames[i] + " Cast";
            LanguageRegistry.instance().addStringLocalization(internalName, "en_US", visibleName);
        }
        LanguageRegistry.instance().addStringLocalization("item.tconstruct.Pattern.blank_pattern.name", "en_US", "Blank Pattern");
        LanguageRegistry.instance().addStringLocalization("item.tconstruct.Pattern.blank_cast.name", "en_US", "Blank Cast");
        LanguageRegistry.addName((Object)TContent.pickaxe, (String)"Pickaxe");
        LanguageRegistry.addName((Object)TContent.shovel, (String)"Shovel");
        LanguageRegistry.addName((Object)TContent.hatchet, (String)"Hatchet");
        LanguageRegistry.addName((Object)TContent.broadsword, (String)"Broadsword");
        LanguageRegistry.addName((Object)TContent.longsword, (String)"Longsword");
        LanguageRegistry.addName((Object)TContent.rapier, (String)"Rapier");
        LanguageRegistry.addName((Object)TContent.frypan, (String)"Frying Pan");
        LanguageRegistry.addName((Object)TContent.battlesign, (String)"Battlesign");
        LanguageRegistry.addName((Object)TContent.mattock, (String)"Mattock");
        LanguageRegistry.addName((Object)TContent.potionLauncher, (String)"Potion Launcher");
        LanguageRegistry.addName((Object)TContent.dagger, (String)"Dagger");
        LanguageRegistry.addName((Object)TContent.chisel, (String)"Chisel");
        LanguageRegistry.addName((Object)TContent.scythe, (String)"Scythe");
        LanguageRegistry.addName((Object)TContent.lumberaxe, (String)"Lumber Axe");
        LanguageRegistry.addName((Object)TContent.cleaver, (String)"Cleaver");
        LanguageRegistry.addName((Object)TContent.excavator, (String)"Excavator");
        LanguageRegistry.addName((Object)TContent.hammer, (String)"Hammer");
        LanguageRegistry.addName((Object)TContent.battleaxe, (String)"Battleaxe");
        LanguageRegistry.addName((Object)TContent.cutlass, (String)"Cutlass");
        LanguageRegistry.addName((Object)TContent.aggregator, (String)"Glowstone Aggregator");
        LanguageRegistry.addName((Object)TContent.lightCrystalBase, (String)"Lightstone Crystal");
        LanguageRegistry.addName((Object)TContent.knapsack, (String)"Knapsack");
        LanguageRegistry.addName((Object)TContent.shortbow, (String)"Shortbow");
        LanguageRegistry.addName((Object)TContent.arrow, (String)"Arrow");
    }

    public void readManuals() {
    }

    public void registerKeys() {
    }

    public void spawnParticle(String slimeParticle, double xPos, double yPos, double zPos, double velX, double velY, double velZ) {
    }
}

