/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import tconstruct.TConstruct;
import tconstruct.common.TContent;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.ToolCore;

public class BlueSlime
extends EntityLiving
implements IMob,
IBossDisplayData {
    private static final float[] field_100000_e = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public float sizeOffset;
    public float sizeFactor;
    public float sizeHeight;
    protected int slimeJumpDelay = 0;

    public BlueSlime(World world) {
        super(world);
        int offset = this.field_70146_Z.nextInt(299);
        offset = offset < 149 ? 1 : (offset < 298 ? 2 : 3);
        int size = 1 << offset;
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(120) + 40;
        this.setSlimeSize(size);
        this.field_70747_aH = 0.004f * (float)size + 0.01f;
    }

    protected void damageEntity(DamageSource damageSource, int damage) {
        if (damageSource.field_76373_n.equals("arrow")) {
            damage /= 2;
        }
        super.func_70665_d(damageSource, (float)damage);
    }

    public String func_70023_ak() {
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        if (this.getSlimeSize() >= 8) {
            s = "TConstruct.KingSlime";
        }
        return StatCollector.func_74838_a((String)("entity." + s + ".name"));
    }

    public EntityLivingData func_110161_a(EntityLivingData par1EntityLivingData) {
        EntityLivingData par1EntityLivingData1 = super.func_110161_a(par1EntityLivingData);
        if (this.getSlimeSize() == 2 && this.field_70146_Z.nextInt(8) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_110161_a(par1EntityLivingData);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_70078_a((Entity)this);
        }
        if (this.getSlimeSize() == 4 && this.field_70146_Z.nextInt(12) == 0) {
            EntityCreeper creeper = new EntityCreeper(this.field_70170_p);
            creeper.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            creeper.func_110161_a(par1EntityLivingData);
            this.field_70170_p.func_72838_d((Entity)creeper);
            creeper.func_70078_a((Entity)this);
        }
        if (this.getSlimeSize() == 8) {
            for (int i = 0; i < 5; ++i) {
                BlueSlime slime = new BlueSlime(this.field_70170_p);
                slime.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                slime.func_110161_a(par1EntityLivingData);
                this.field_70170_p.func_72838_d((Entity)slime);
            }
            BlueSlime slime = new BlueSlime(this.field_70170_p);
            slime.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            slime.setSlimeSize(2);
            this.field_70170_p.func_72838_d((Entity)slime);
            EntitySkeleton skelton = new EntitySkeleton(this.field_70170_p);
            skelton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            skelton.func_110161_a(par1EntityLivingData);
            this.field_70170_p.func_72838_d((Entity)skelton);
            skelton.func_70078_a((Entity)slime);
        }
        return par1EntityLivingData1;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.3;
    }

    protected void func_70664_aZ() {
        int size;
        this.field_70181_x = 0.05 * (double)this.getSlimeSize() + 0.37;
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        if (this.func_70013_c(1.0f) > 0.9f && this.field_70146_Z.nextInt(5) == 0 && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) && (size = this.getSlimeSize() - 1) < 7) {
            if (size <= 0) {
                this.func_70076_C();
            } else {
                this.setSlimeSize(size);
            }
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void func_70069_a(float par1) {
    }

    protected String getSlimeParticle() {
        return "blueslime";
    }

    public boolean func_70601_bi() {
        return this.isValidLightLevel() && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    protected boolean isValidLightLevel() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (y < 60 && this.field_70146_Z.nextInt(5) != 0) {
            return false;
        }
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, x, y, z) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int light = this.field_70170_p.func_72957_l(x, y, z);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            light = this.field_70170_p.func_72957_l(x, y, z);
            this.field_70170_p.field_73008_k = i1;
        }
        return light <= this.field_70146_Z.nextInt(8);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(1));
    }

    public void setSlimeSize(int size) {
        this.field_70180_af.func_75692_b(16, (Object)new Byte((byte)size));
        this.func_70105_a(0.6f * (float)size, 0.6f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getMaxHealth());
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = size + 2 ^ size;
        if (size >= 8) {
            this.field_70728_aV = 500;
        }
    }

    public int getMaxHealth() {
        int i = this.getSlimeSize();
        if (i == 1) {
            return 4;
        }
        if (i == 8) {
            return 100;
        }
        return Math.min(i * i + 8, 49);
    }

    public int getSlimeSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setSlimeSize(par1NBTTagCompound.func_74762_e("Size") + 1);
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == 0 && this.getSlimeSize() > 0) {
            this.field_70128_L = true;
        }
        this.sizeFactor += (this.sizeOffset - this.sizeFactor) * 0.5f;
        this.sizeHeight = this.sizeFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float offset = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float xPos = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * offset;
                float zPos = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * offset;
                TConstruct.proxy.spawnParticle(this.getSlimeParticle(), this.field_70165_t + (double)xPos, this.field_70121_D.field_72338_b, this.field_70161_v + (double)zPos, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.sizeOffset = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.sizeOffset = 1.0f;
        }
        this.func_70808_l();
        if (this.field_70170_p.field_72995_K) {
            i = this.getSlimeSize();
            this.func_70105_a(0.6f * (float)i, 0.6f * (float)i);
        }
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityplayer != null) {
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        } else if (this.field_70122_E && this.slimeJumpDelay == 1) {
            this.field_70177_z = this.field_70177_z + this.field_70146_Z.nextFloat() * 180.0f - 90.0f;
            if (this.field_70177_z > 360.0f) {
                this.field_70177_z -= 360.0f;
            }
            if (this.field_70177_z < 0.0f) {
                this.field_70177_z += 360.0f;
            }
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 12;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1 * this.getSlimeSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    public boolean func_70072_I() {
        return false;
    }

    protected void func_70808_l() {
        this.sizeOffset *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(120) + 40;
    }

    protected BlueSlime createInstance() {
        return new BlueSlime(this.field_70170_p);
    }

    public void func_70106_y() {
        int size = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && size > 1 && this.func_110143_aJ() <= 0.0f && size < 8) {
            float f = -0.5f * (float)size / 4.0f;
            float f1 = -0.5f * (float)size / 4.0f;
            BlueSlime entityslime = this.createInstance();
            entityslime.setSlimeSize(size / 2);
            entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)entityslime);
        }
        super.func_70106_y();
    }

    protected void func_70628_a(boolean par1, int par2) {
        int size = this.getSlimeSize();
        int j = this.func_70633_aT();
        if (j > 0 && this.field_70146_Z.nextInt(2) == 0 || size >= 8) {
            int k = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(this.getSlimeSize());
            if (par2 > 0) {
                k += this.field_70146_Z.nextInt(par2 + 1);
            }
            for (int l = 0; l < k; ++l) {
                this.func_70025_b(j, 1);
            }
        }
        if (size == 8) {
            ToolCore tool = this.getValidTool();
            Item accessory = tool.getAccessoryItem();
            ItemStack accessoryStack = accessory != null ? new ItemStack(tool.getAccessoryItem(), 1, 17) : null;
            ItemStack toolStack = ToolBuilder.instance.buildTool(new ItemStack(tool.getHeadItem(), 1, 17), new ItemStack(tool.getHandleItem(), 1, 17), accessoryStack, "King Slime " + tool.getToolName());
            NBTTagCompound tags = toolStack.func_77978_p().func_74775_l("InfiTool");
            tags.func_74768_a("Attack", 3 + tool.getDamageVsEntity(null));
            tags.func_74768_a("TotalDurability", 1500);
            tags.func_74768_a("BaseDurability", 1500);
            tags.func_74768_a("MiningSpeed", 800);
            this.func_70099_a(toolStack, 0.0f);
            if (this.field_70146_Z.nextInt(5) == 0) {
                ItemStack dropStack = new ItemStack(TContent.heartCanister, 1, 1);
                this.func_70099_a(dropStack, 0.0f);
            }
        }
    }

    ToolCore getValidTool() {
        ToolCore tool = TConstructRegistry.tools.get(this.field_70146_Z.nextInt(TConstructRegistry.tools.size()));
        if (tool.getAccessoryItem() != null) {
            tool = this.getValidTool();
        }
        return tool;
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (this.canDamagePlayer()) {
            int i = this.getSlimeSize();
            if (this.func_70685_l((Entity)par1EntityPlayer) && this.func_70068_e((Entity)par1EntityPlayer) < 0.6 * (double)i * 0.6 * (double)i && par1EntityPlayer.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
                this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected String func_70621_aR() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected String func_70673_aS() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected int func_70633_aT() {
        return TContent.strangeFood.field_77779_bT;
    }

    protected float func_70599_aP() {
        return Math.min(0.05f * (float)this.getSlimeSize(), 0.3f);
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }
}

