/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class GolemBase
extends EntityCreature
implements IInventory {
    public WeakReference<EntityLivingBase> leader;
    public String ownerName = "";
    public int maxHealth = 20;
    public int baseAttack;
    public boolean paused;
    int useTime;
    protected static Random field_70146_Z = new Random();
    public int targetX;
    public int targetY;
    public int targetZ;
    public boolean targetLock;
    public ItemStack[] inventory;

    public GolemBase(World world) {
        super(world);
        this.setupInventory();
    }

    public void setupInventory() {
        this.inventory = new ItemStack[0];
    }

    public EntityLivingBase getOwner() {
        if (this.leader == null || this.leader.get() == null) {
            return this.field_70170_p.func_72924_a(this.ownerName);
        }
        return (EntityLivingBase)this.leader.get();
    }

    public void setOwner(EntityLivingBase living) {
        if (living instanceof EntityPlayer) {
            this.ownerName = ((EntityPlayer)living).field_71092_bJ;
        } else {
            this.leader = new WeakReference<EntityLivingBase>(living);
        }
    }

    public boolean isOwner(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            return entityplayer.field_71092_bJ.equalsIgnoreCase(this.ownerName);
        }
        return false;
    }

    public float getSpeed() {
        return 0.25f;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_70779_j() {
        if (!this.paused) {
            super.func_70779_j();
        }
    }

    public boolean standby() {
        return false;
    }

    public boolean following() {
        return false;
    }

    public boolean patrolling() {
        return true;
    }

    public void attackEntityAsGolem(Entity target) {
    }

    public void teleport(double x, double y, double z) {
        this.func_70107_b(x, y, z);
        this.field_70170_p.func_72956_a((Entity)this, "mob.endermen.portal", 0.5f, (field_70146_Z.nextFloat() - field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_70620_b(ItemStack par1ItemStack, int par2) {
        Icon icon = super.func_70620_b(par1ItemStack, par2);
        if (par1ItemStack.func_77973_b().func_77623_v()) {
            return par1ItemStack.func_77973_b().getIcon(par1ItemStack, par2);
        }
        return icon;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public boolean isStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return false;
        }
        return this.inventory[slot] != null;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }
        return null;
    }

    public String func_70303_b() {
        return "golem.none";
    }

    public boolean func_94042_c() {
        return false;
    }

    public void func_70296_d() {
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void destroyCurrentEquippedItem() {
        this.field_70170_p.func_72956_a((Entity)this, "random.break", 0.5f, (field_70146_Z.nextFloat() - field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        this.func_70062_b(0, null);
    }

    public void func_70014_b(NBTTagCompound tags) {
        super.func_70014_b(tags);
        tags.func_74778_a("OwnerName", this.ownerName);
        NBTTagList nbttaglist = new NBTTagList();
        for (int iter = 0; iter < this.inventory.length; ++iter) {
            if (this.inventory[iter] == null) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74774_a("Slot", (byte)iter);
            this.inventory[iter].func_77955_b(tagList);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        tags.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70037_a(NBTTagCompound tags) {
        super.func_70037_a(tags);
        this.ownerName = tags.func_74779_i("OwnerName");
        NBTTagList nbttaglist = tags.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int iter = 0; iter < nbttaglist.func_74745_c(); ++iter) {
            NBTTagCompound tagList = (NBTTagCompound)nbttaglist.func_74743_b(iter);
            byte slotID = tagList.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagList);
        }
    }
}

