/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.common.TContent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.HarvestTool;

public class Excavator
extends HarvestTool {
    static Material[] materials = new Material[]{Material.field_76247_b, Material.field_76248_c, Material.field_76251_o, Material.field_76259_v, Material.field_76258_w, Material.field_76267_y};

    public Excavator(int itemID) {
        super(itemID, 2);
        this.func_77655_b("InfiTool.Excavator");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    protected String getHarvestType() {
        return "shovel";
    }

    @Override
    public Item getHeadItem() {
        return TContent.excavatorHead;
    }

    @Override
    public Item getHandleItem() {
        return TContent.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.heavyPlate;
    }

    @Override
    public Item getExtraItem() {
        return TContent.toughBinding;
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public float getDurabilityModifier() {
        return 2.75f;
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_excavator_head";
            }
            case 1: {
                return "_excavator_head_broken";
            }
            case 2: {
                return "_excavator_handle";
            }
            case 3: {
                return "_excavator_binding";
            }
            case 4: {
                return "_excavator_grip";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_excavator_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "excavator";
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        MovingObjectPosition mop;
        World world = player.field_70170_p;
        int blockID = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[blockID];
        if (!stack.func_77942_o()) {
            return false;
        }
        if (block == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        float blockHardness = block.func_71934_m(world, x, y, z);
        boolean validStart = false;
        for (int iter = 0; iter < materials.length; ++iter) {
            if (materials[iter] != block.field_72018_cp) continue;
            validStart = true;
            break;
        }
        if ((mop = AbilityHelper.raytraceFromEntity(world, (Entity)player, true, 5.0)) == null || !validStart) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int xRange = 1;
        int yRange = 1;
        int zRange = 1;
        switch (mop.field_72310_e) {
            case 0: 
            case 1: {
                yRange = 0;
                break;
            }
            case 2: 
            case 3: {
                zRange = 0;
                break;
            }
            case 4: 
            case 5: {
                xRange = 0;
            }
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    float localHardness;
                    if (tags.func_74767_n("Broken")) continue;
                    int localblockID = world.func_72798_a(xPos, yPos, zPos);
                    block = Block.field_71973_m[localblockID];
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
                    float f = localHardness = block == null ? Float.MAX_VALUE : block.func_71934_m(world, xPos, yPos, zPos);
                    if (hlvl > tags.func_74762_e("HarvestLevel") || !((double)localHardness - 1.5 <= (double)blockHardness)) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLivingBase)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest || block == null || localHardness < 0.0f) continue;
                    for (int iter = 0; iter < materials.length; ++iter) {
                        if (materials[iter] != block.field_72018_cp) continue;
                        if (!player.field_71075_bZ.field_75098_d) {
                            block.func_71893_a(world, player, xPos, yPos, zPos, localMeta);
                            block.func_71846_a(world, x, y, z, localMeta, player);
                            if (blockHardness > 0.0f) {
                                this.func_77660_a(stack, world, localblockID, xPos, yPos, zPos, (EntityLivingBase)player);
                            }
                        }
                        world.func_94571_i(xPos, yPos, zPos);
                    }
                }
            }
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, blockID + (meta << 12));
        }
        return true;
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            float mineSpeed = tags.func_74762_e("MiningSpeed");
            int heads = 1;
            if (tags.func_74764_b("MiningSpeed2")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeed2");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedHandle")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedHandle");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedExtra")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedExtra");
                ++heads;
            }
            float trueSpeed = mineSpeed / ((float)heads * 300.0f);
            int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
            int durability = tags.func_74762_e("Damage");
            float stonebound = tags.func_74760_g("Shoddy");
            float bonusLog = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
            trueSpeed += bonusLog;
            if (hlvl <= tags.func_74762_e("HarvestLevel")) {
                return trueSpeed;
            }
            return 0.1f;
        }
        return super.getStrVsBlock(stack, block, meta);
    }
}

