/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.landmine.logic;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import tconstruct.landmine.logic.LandmineSpecialStackLogic;
import tconstruct.landmine.logic.behavior.Behavior;
import tconstruct.landmine.tileentity.TileEntityLandmine;

public class LandmineExplodeLogic {
    private final World worldObj;
    private final Entity triggerer;
    private final TileEntityLandmine tileEntity;
    private final int x;
    private final int y;
    private final int z;

    public LandmineExplodeLogic(World par1World, int par2, int par3, int par4, Entity entity) {
        this.worldObj = par1World;
        this.tileEntity = (TileEntityLandmine)par1World.func_72796_p(par2, par3, par4);
        this.x = par2;
        this.y = par3;
        this.z = par4;
        this.triggerer = entity;
    }

    public void explode() {
        if (this.triggerer == null) {
            return;
        }
        boolean preventExplode = false;
        boolean isOffensive = true;
        boolean cancelDefault = false;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        boolean hasExploded = false;
        if (this.tileEntity == null) {
            return;
        }
        this.tileEntity.isExploding = true;
        for (int i = 0; i < this.tileEntity.getSizeTriggerInventory(); ++i) {
            ItemStack currentStack = this.tileEntity.func_70301_a(i);
            Behavior b = Behavior.getBehaviorFromStack(currentStack);
            if (b == null) continue;
            if (b.doesBehaviorPreventRemovalOfBlock(currentStack)) {
                preventExplode = true;
            }
            if (!b.isBehaviorExchangableWithOffensive(currentStack)) {
                isOffensive = false;
            }
            if (b.overridesDefault()) {
                cancelDefault = true;
            }
            if (!stacks.isEmpty() && Behavior.arrayContainsEqualStack(stacks, currentStack) && b.effectStacks()) {
                stacks.get((int)Behavior.arrayIndexOfStack(stacks, (ItemStack)currentStack)).field_77994_a += currentStack.field_77994_a;
                continue;
            }
            stacks.add(currentStack);
        }
        LandmineSpecialStackLogic specialStacks = new LandmineSpecialStackLogic(this.worldObj, this.x, this.y, this.z, this.triggerer, isOffensive, stacks);
        specialStacks.handleSpecialStacks();
        for (ItemStack currentStack : stacks) {
            Behavior b = Behavior.getBehaviorFromStack(currentStack);
            if (b == null || !isOffensive && b.isOffensive(currentStack)) continue;
            b.executeLogic(this.worldObj, this.x, this.y, this.z, currentStack, this.triggerer, !preventExplode);
            if (!b.shouldItemBeRemoved(currentStack, !preventExplode)) continue;
            if (b.effectStacks()) {
                for (int i = 0; i < this.tileEntity.getSizeTriggerInventory(); ++i) {
                    if (this.tileEntity.func_70301_a(i) == null || !this.tileEntity.func_70301_a(i).func_77969_a(currentStack)) continue;
                    this.tileEntity.func_70299_a(i, null);
                }
                continue;
            }
            boolean hasRemoved = false;
            for (int i = 0; i < this.tileEntity.getSizeTriggerInventory() && !hasRemoved; ++i) {
                if (this.tileEntity.func_70301_a(i) == null || !this.tileEntity.func_70301_a(i).func_77969_a(currentStack)) continue;
                this.tileEntity.func_70299_a(i, null);
                hasRemoved = true;
            }
        }
        Behavior defBeh = Behavior.getDefaulBehavior();
        if (defBeh != null && isOffensive && !cancelDefault) {
            defBeh.executeLogic(this.worldObj, this.x, this.y, this.z, null, this.triggerer, !preventExplode);
        }
        if (hasExploded || defBeh != null && !preventExplode) {
            this.worldObj.func_72932_q(this.x, this.y, this.z);
            this.worldObj.func_94571_i(this.x, this.y, this.z);
        } else {
            this.tileEntity.isExploding = false;
        }
    }
}

