/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.CastingRecipe;

public class LiquidCasting {
    private ArrayList<CastingRecipe> casts = new ArrayList();

    public void addCastingRecipe(ItemStack output, FluidStack metal, ItemStack cast, boolean consume, int delay) {
        this.casts.add(new CastingRecipe(output, metal, cast, consume, delay));
    }

    public void addCastingRecipe(ItemStack output, FluidStack metal, ItemStack cast, int delay) {
        this.addCastingRecipe(output, metal, cast, false, delay);
    }

    public void addCastingRecipe(ItemStack output, FluidStack metal, int delay) {
        this.addCastingRecipe(output, metal, null, false, delay);
    }

    public void addCustomCastingRecipe(CastingRecipe recipe) {
        this.casts.add(recipe);
    }

    public int getCastingDelay(FluidStack metal, ItemStack cast) {
        CastingRecipe recipe = this.getCastingRecipe(metal, cast);
        if (recipe != null) {
            return recipe.coolTime;
        }
        return -1;
    }

    public int getCastingAmount(FluidStack metal, ItemStack cast) {
        CastingRecipe recipe = this.getCastingRecipe(metal, cast);
        if (recipe != null) {
            return recipe.castingMetal.amount;
        }
        return 0;
    }

    public CastingRecipe getCastingRecipe(FluidStack metal, ItemStack cast) {
        for (CastingRecipe recipe : this.casts) {
            if (!recipe.matches(metal, cast)) continue;
            return recipe;
        }
        return null;
    }

    public ArrayList<CastingRecipe> getCastingRecipes() {
        return this.casts;
    }
}

