/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;

public abstract class HarvestTool
extends ToolCore {
    public HarvestTool(int itemID, int baseDamage) {
        super(itemID, baseDamage);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        World world = player.field_70170_p;
        int bID = player.field_70170_p.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[bID];
        if (block == null || bID < 1) {
            return false;
        }
        int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
        if (hlvl <= tags.func_74762_e("HarvestLevel")) {
            boolean cancelHarvest = false;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                if (!mod.beforeBlockBreak(this, stack, x, y, z, (EntityLivingBase)player)) continue;
                cancelHarvest = true;
            }
            return cancelHarvest;
        }
        world.func_94571_i(x, y, z);
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_77660_a(stack, world, bID, x, y, z, (EntityLivingBase)player);
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, bID + (meta << 12));
        }
        return true;
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            float mineSpeed = tags.func_74762_e("MiningSpeed");
            int heads = 1;
            if (tags.func_74764_b("MiningSpeed2")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeed2");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedHandle")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedHandle");
                ++heads;
            }
            if (tags.func_74764_b("MiningSpeedExtra")) {
                mineSpeed += (float)tags.func_74762_e("MiningSpeedExtra");
                ++heads;
            }
            float trueSpeed = mineSpeed / ((float)heads * 100.0f);
            int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
            int durability = tags.func_74762_e("Damage");
            float stonebound = tags.func_74760_g("Shoddy");
            float bonusLog = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
            trueSpeed += bonusLog;
            if (hlvl <= tags.func_74762_e("HarvestLevel")) {
                return trueSpeed;
            }
            return 0.1f;
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    public boolean func_77641_a(Block block) {
        if (block.field_72018_cp.func_76229_l()) {
            return true;
        }
        for (Material m : this.getEffectiveMaterials()) {
            if (m != block.field_72018_cp) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"harvest"};
    }

    protected abstract Material[] getEffectiveMaterials();

    protected abstract String getHarvestType();
}

