/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.TConstruct;
import tconstruct.common.TContent;
import tconstruct.crystal.TheftValueTracker;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.ValueCoordTuple;
import tconstruct.modifiers.ModAttack;
import tconstruct.util.PHConstruct;
import tconstruct.util.player.TPlayerStats;

public class TEventHandler {
    Random random = new Random();
    private Object evt;

    @ForgeSubscribe
    public void craftTool(ToolCraftEvent.NormalTool event) {
        int modifiers;
        int accessory;
        int handle;
        int head;
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        if (PHConstruct.denyMattock && event.tool == TContent.mattock && !this.allowCrafting(head = toolTag.func_74762_e("Head"), handle = toolTag.func_74762_e("Handle"), accessory = toolTag.func_74762_e("Accessory"))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        int thaum = 0;
        if (toolTag.func_74762_e("Head") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Handle") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Accessory") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Extra") == 31) {
            ++thaum;
        }
        if (thaum >= 3 || !toolTag.func_74764_b("Accessory") && thaum >= 2) {
            modifiers = toolTag.func_74762_e("Modifiers");
            toolTag.func_74768_a("Modifiers", modifiers += 2);
        } else if (thaum >= 1) {
            modifiers = toolTag.func_74762_e("Modifiers");
            toolTag.func_74768_a("Modifiers", ++modifiers);
        }
        if (event.tool == TContent.shortbow) {
            BowMaterial top = TConstructRegistry.getBowMaterial(toolTag.func_74762_e("Head"));
            BowMaterial bottom = TConstructRegistry.getBowMaterial(toolTag.func_74762_e("Accessory"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(toolTag.func_74762_e("Handle"), BowstringMaterial.class);
            if (top != null && bottom != null && string != null) {
                if (toolTag.func_74762_e("Handle") == 1) {
                    int modifiers2 = toolTag.func_74762_e("Modifiers");
                    toolTag.func_74768_a("Modifiers", ++modifiers2);
                }
                int durability = (int)((float)((top.durability + bottom.durability) / 2) * string.durabilityModifier);
                toolTag.func_74768_a("TotalDurability", durability);
                toolTag.func_74768_a("BaseDurability", durability);
                int drawSpeed = (int)((float)((top.drawspeed + bottom.drawspeed) / 2) * string.drawspeedModifier);
                toolTag.func_74768_a("DrawSpeed", drawSpeed);
                toolTag.func_74768_a("BaseDrawSpeed", drawSpeed);
                float flightSpeed = (top.flightSpeedMax + bottom.flightSpeedMax) / 2.0f * string.flightSpeedModifier;
                toolTag.func_74776_a("FlightSpeed", flightSpeed);
            }
        }
        if (event.tool == TContent.arrow) {
            ArrowMaterial head2 = TConstructRegistry.getArrowMaterial(toolTag.func_74762_e("Head"));
            ArrowMaterial shaft = TConstructRegistry.getArrowMaterial(toolTag.func_74762_e("Handle"));
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(toolTag.func_74762_e("Accessory"), FletchingMaterial.class);
            if (head2 != null && shaft != null && fletching != null) {
                float mass = head2.mass / 5.0f + shaft.mass + fletching.mass;
                float shatter = (head2.breakChance + shaft.breakChance + fletching.breakChance) / 4.0f;
                float accuracy = (head2.accuracy + shaft.accuracy + fletching.accuracy) / 3.0f;
                ItemStack arrow = new ItemStack((Item)event.tool, 4);
                toolTag.func_74768_a("TotalDurability", 0);
                toolTag.func_74776_a("Mass", mass);
                toolTag.func_74776_a("BreakChance", shatter);
                toolTag.func_74776_a("Accuracy", accuracy);
                toolTag.func_74768_a("Unbreaking", 10);
                arrow.func_77982_d(event.toolTag);
                event.overrideResult(arrow);
            }
        }
    }

    private boolean allowCrafting(int head, int handle, int accessory) {
        int[] nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17};
        for (int i = 0; i < nonMetals.length; ++i) {
            if (head != nonMetals[i] && handle != nonMetals[i] && accessory != nonMetals[i]) continue;
            return false;
        }
        return true;
    }

    @ForgeSubscribe
    public void craftPart(PartBuilderEvent.NormalPart event) {
        ItemStack result;
        if (event.pattern.func_77973_b() == TContent.woodPattern && event.pattern.func_77960_j() == 23 && (result = TEventHandler.craftBowString(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
        if (event.pattern.func_77973_b() == TContent.woodPattern && event.pattern.func_77960_j() == 24 && (result = TEventHandler.craftFletching(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
    }

    public static ItemStack craftBowString(ItemStack stack) {
        if (stack.field_77994_a < 3) {
            return null;
        }
        BowstringMaterial mat = (BowstringMaterial)TConstructRegistry.getCustomMaterial(stack, BowstringMaterial.class);
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    public static ItemStack craftFletching(ItemStack stack) {
        if (TEventHandler.matchesLeaves(stack)) {
            FletchingMaterial leaves = (FletchingMaterial)TConstructRegistry.getCustomMaterial(new ItemStack((Block)Block.field_71952_K), FletchingMaterial.class);
            return leaves.craftingItem.func_77946_l();
        }
        FletchingMaterial mat = (FletchingMaterial)TConstructRegistry.getCustomMaterial(stack, FletchingMaterial.class);
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    public static boolean matchesLeaves(ItemStack stack) {
        Block block = Block.field_71973_m[stack.field_77993_c];
        return block != null && block.isLeaves(null, 0, 0, 0);
    }

    @ForgeSubscribe
    public void onLivingDrop(LivingDropsEvent event) {
        int beheading;
        ItemStack stack;
        EntityItem entityitem;
        ItemStack dropStack;
        if (this.random.nextInt(500) == 0 && event.entityLiving instanceof IMob && event.entityLiving.field_71093_bK == 0) {
            dropStack = new ItemStack(TContent.heartCanister, 1, 1);
            entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_70293_c = 10;
            event.drops.add(entityitem);
        }
        if (event.entityLiving instanceof EntityWither && this.random.nextInt(5) == 0) {
            dropStack = new ItemStack(TContent.heartCanister, 1, 1);
            entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_70293_c = 10;
            event.drops.add(entityitem);
        }
        if (!event.entityLiving.func_70631_g_()) {
            if (event.entityLiving.getClass() == EntityCow.class) {
                int amount = this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + 1;
                for (int iter = 0; iter < amount; ++iter) {
                    this.addDrops(event, new ItemStack(Item.field_77770_aF, 1));
                }
            } else if (event.entityLiving.getClass() == EntityChicken.class) {
                int amount = this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + 1;
                for (int iter = 0; iter < amount; ++iter) {
                    this.addDrops(event, new ItemStack(Item.field_77676_L, 1));
                }
            }
        }
        if (event.recentlyHit) {
            if (event.entityLiving.getClass() == EntitySkeleton.class) {
                EntityPlayer player;
                EntitySkeleton enemy = (EntitySkeleton)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 10) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, enemy.func_82202_m()));
                    }
                }
                if (enemy.func_82202_m() == 1 && this.random.nextInt(Math.max(1, 5 - event.lootingLevel)) == 0) {
                    this.addDrops(event, new ItemStack(TContent.materials, 1, 8));
                }
            }
            if (event.entityLiving.getClass() == EntityZombie.class) {
                EntityPlayer player;
                EntityZombie enemy = (EntityZombie)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 10) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 2));
                    }
                }
            }
            if (event.entityLiving.getClass() == EntityCreeper.class) {
                EntityPlayer player;
                EntityCreeper enemy = (EntityCreeper)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 5) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 4));
                    }
                }
            }
        }
        if (event.entityLiving.getClass() == EntityGhast.class) {
            if (PHConstruct.uhcGhastDrops) {
                for (EntityItem o : event.drops) {
                    if (o.func_92059_d().field_77993_c != Item.field_77732_bp.field_77779_bT) continue;
                    o.func_92058_a(new ItemStack(Item.field_77717_p, 1));
                }
            } else {
                this.addDrops(event, new ItemStack(Item.field_77732_bp, 1));
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer source;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (PHConstruct.dropPlayerHeads) {
                ItemStack dropStack2 = new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 3);
                NBTTagCompound nametag = new NBTTagCompound();
                nametag.func_74778_a("SkullOwner", player.field_71092_bJ);
                this.addDrops(event, dropStack2);
            } else if (event.source.field_76373_n.equals("player") && (stack = (source = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                if (stack.func_77973_b() == TContent.cleaver) {
                    beheading += 2;
                }
                if (beheading > 0 && this.random.nextInt(100) < beheading * 50) {
                    ItemStack dropStack3 = new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 3);
                    NBTTagCompound nametag = new NBTTagCompound();
                    nametag.func_74778_a("SkullOwner", player.field_71092_bJ);
                    this.addDrops(event, dropStack3);
                }
            }
        }
    }

    @ForgeSubscribe
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                TPlayerStats stats = TConstruct.playerTracker.getPlayerStats(player.field_71092_bJ);
                stats.armor.dropItems();
                stats.knapsack.dropItems();
            }
        }
    }

    void addDrops(LivingDropsEvent event, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
        entityitem.field_70293_c = 10;
        event.drops.add(entityitem);
    }

    @ForgeSubscribe
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.entityLiving.getClass() == EntitySpider.class && this.random.nextInt(100) == 0) {
            EntityCreeper creeper = new EntityCreeper(event.entityLiving.field_70170_p);
            TEventHandler.spawnEntity(event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + 1.0, event.entityLiving.field_70161_v, (Entity)creeper, event.entityLiving.field_70170_p);
            creeper.func_70078_a((Entity)event.entityLiving);
        }
    }

    public static void spawnEntity(double x, double y, double z, Entity entity, World world) {
    }

    @ForgeSubscribe
    public void chunkDataLoad(ChunkDataEvent.Load event) {
        Chunk chunk = event.getChunk();
        int worldID = chunk.field_76637_e.field_73011_w.field_76574_g;
        ValueCoordTuple coord = new ValueCoordTuple(worldID, chunk.field_76635_g, chunk.field_76647_h);
        TheftValueTracker.crystallinity.put(coord, event.getData().func_74762_e("TConstruct.Crystallinity"));
    }

    @ForgeSubscribe
    public void chunkDataSave(ChunkDataEvent.Save event) {
        Chunk chunk = event.getChunk();
        int worldID = chunk.field_76637_e.field_73011_w.field_76574_g;
        ValueCoordTuple coord = new ValueCoordTuple(worldID, chunk.field_76635_g, chunk.field_76647_h);
        if (TheftValueTracker.crystallinity.containsKey(coord)) {
            int crystal = TheftValueTracker.crystallinity.get(coord);
            event.getData().func_74768_a("TConstruct.Crystallinity", crystal);
            if (!event.getChunk().field_76636_d) {
                TheftValueTracker.crystallinity.remove(worldID);
            }
        }
    }

    @ForgeSubscribe
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        String ingot = evt.Name.toLowerCase();
        if (ingot.contains("ingot")) {
            TConstruct.tableCasting.addCastingRecipe(new ItemStack(TContent.metalPattern, 1, 0), new FluidStack(TContent.moltenAlubrassFluid, 144), evt.Ore, false, 50);
            TConstruct.tableCasting.addCastingRecipe(new ItemStack(TContent.metalPattern, 1, 0), new FluidStack(TContent.moltenGoldFluid, 288), evt.Ore, false, 50);
        }
        if (evt.Name == "battery") {
            TContent.modE.batteries.add(evt.Ore);
        } else if (evt.Name == "basicCircuit") {
            TContent.modE.circuits.add(evt.Ore);
        } else if (evt.Name == "plankWood") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Wood");
        } else if (evt.Name == "crystalQuartz") {
            ToolBuilder.registerToolMod(new ModAttack("Quartz", new ItemStack[]{evt.Ore}, 11, 2));
        } else if (evt.Name == "crystalCerusQuartz") {
            ToolBuilder.registerToolMod(new ModAttack("Quartz", new ItemStack[]{evt.Ore}, 11, 24));
        } else if (evt.Name == "ingotCopper") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Copper");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenCopperFluid, 144));
        } else if (evt.Name == "ingotTin") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new FluidStack(TContent.moltenTinFluid, 144));
        } else if (evt.Name == "ingotBronze") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Bronze");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new FluidStack(TContent.moltenBronzeFluid, 144));
        } else if (evt.Name == "ingotCobalt") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Cobalt");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new FluidStack(TContent.moltenCobaltFluid, 144));
        } else if (evt.Name == "ingotArdite") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Ardite");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new FluidStack(TContent.moltenArditeFluid, 144));
        } else if (evt.Name == "ingotManyullyn") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Manyullyn");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new FluidStack(TContent.moltenManyullynFluid, 144));
        } else if (evt.Name == "ingotNaturalAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 144));
        } else if (evt.Name == "naturalAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 144));
        } else if (evt.Name == "ingotAluminumBrass") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new FluidStack(TContent.moltenAlubrassFluid, 144));
        } else if (evt.Name == "ingotAlumite") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Alumite");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new FluidStack(TContent.moltenAlumiteFluid, 144));
        } else if (evt.Name == "ingotSteel") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Steel");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenSteelFluid, 144));
        } else if (evt.Name == "ingotNickel") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenNickelFluid, 144));
        } else if (evt.Name == "ingotLead") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenLeadFluid, 144));
        } else if (evt.Name == "ingotSilver") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenSilverFluid, 144));
        } else if (evt.Name == "ingotPlatinum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenShinyFluid, 144));
        } else if (evt.Name == "ingotInvar") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenInvarFluid, 144));
        } else if (evt.Name == "ingotElectrum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenElectrumFluid, 144));
        } else if (evt.Name == "oreCopper") {
            Smeltery.addMelting(evt.Ore, 550, new FluidStack(TContent.moltenCopperFluid, 288));
        } else if (evt.Name == "oreTin") {
            Smeltery.addMelting(evt.Ore, 275, new FluidStack(TContent.moltenTinFluid, 288));
        } else if (evt.Name == "oreNaturalAluminum") {
            Smeltery.addMelting(evt.Ore, 350, new FluidStack(TContent.moltenAluminumFluid, 288));
        } else if (evt.Name == "oreCobalt") {
            Smeltery.addMelting(evt.Ore, 750, new FluidStack(TContent.moltenCobaltFluid, 288));
        } else if (evt.Name == "oreArdite") {
            Smeltery.addMelting(evt.Ore, 750, new FluidStack(TContent.moltenArditeFluid, 288));
        } else if (evt.Name == "oreNickel") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenNickelFluid, 288));
        } else if (evt.Name == "oreLead") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenLeadFluid, 288));
        } else if (evt.Name == "oreSilver") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenSilverFluid, 288));
        } else if (evt.Name == "orePlatinum") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenShinyFluid, 288));
        } else if (evt.Name == "oreInvar") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenInvarFluid, 288));
        } else if (evt.Name == "oreElectrum") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenElectrumFluid, 288));
        } else if (evt.Name == "blockCopper") {
            Smeltery.addMelting(evt.Ore, 550, new FluidStack(TContent.moltenCopperFluid, 1296));
        } else if (evt.Name == "blockTin") {
            Smeltery.addMelting(evt.Ore, 275, new FluidStack(TContent.moltenTinFluid, 1296));
        } else if (evt.Name == "blockBronze") {
            Smeltery.addMelting(evt.Ore, 500, new FluidStack(TContent.moltenBronzeFluid, 1296));
        } else if (evt.Name == "blockNaturalAluminum") {
            Smeltery.addMelting(evt.Ore, 350, new FluidStack(TContent.moltenAluminumFluid, 1296));
        } else if (evt.Name == "blockCobalt") {
            Smeltery.addMelting(evt.Ore, 750, new FluidStack(TContent.moltenCobaltFluid, 1296));
        } else if (evt.Name == "blockArdite") {
            Smeltery.addMelting(evt.Ore, 750, new FluidStack(TContent.moltenArditeFluid, 1296));
        } else if (evt.Name == "blockManyullyn") {
            Smeltery.addMelting(evt.Ore, 800, new FluidStack(TContent.moltenManyullynFluid, 1296));
        } else if (evt.Name == "blockAluminumBrass") {
            Smeltery.addMelting(evt.Ore, 350, new FluidStack(TContent.moltenAlubrassFluid, 1296));
        } else if (evt.Name == "blockAlumite") {
            Smeltery.addMelting(evt.Ore, 500, new FluidStack(TContent.moltenAlumiteFluid, 1296));
        } else if (evt.Name == "blockSteel") {
            Smeltery.addMelting(evt.Ore, 500, new FluidStack(TContent.moltenSteelFluid, 1296));
        } else if (evt.Name == "blockNickel") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenNickelFluid, 1296));
        } else if (evt.Name == "blockLead") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenLeadFluid, 1296));
        } else if (evt.Name == "blockSilver") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenSilverFluid, 1296));
        } else if (evt.Name == "blockPlatinum") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenShinyFluid, 1296));
        } else if (evt.Name == "blockInvar") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenInvarFluid, 1296));
        } else if (evt.Name == "blockElectrum") {
            Smeltery.addMelting(evt.Ore, 400, new FluidStack(TContent.moltenElectrumFluid, 1296));
        } else if (evt.Name == "dustIron") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenIronFluid, 144));
        } else if (evt.Name == "dustGold") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenGoldFluid, 144));
        } else if (evt.Name == "dustCopper") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenCopperFluid, 144));
        } else if (evt.Name == "dustTin") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new FluidStack(TContent.moltenTinFluid, 144));
        } else if (evt.Name == "dustBronze") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new FluidStack(TContent.moltenBronzeFluid, 144));
        } else if (evt.Name == "dustCobalt") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new FluidStack(TContent.moltenCobaltFluid, 144));
        } else if (evt.Name == "dustArdite") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new FluidStack(TContent.moltenArditeFluid, 144));
        } else if (evt.Name == "dustManyullyn") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new FluidStack(TContent.moltenManyullynFluid, 144));
        } else if (evt.Name == "dustAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 144));
        } else if (evt.Name == "dustNaturalAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 144));
        } else if (evt.Name == "dustAluminumBrass") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new FluidStack(TContent.moltenAlubrassFluid, 144));
        } else if (evt.Name == "dustAlumite") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new FluidStack(TContent.moltenAlumiteFluid, 144));
        } else if (evt.Name == "dustSteel") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenSteelFluid, 144));
        } else if (evt.Name == "dustNickel") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenNickelFluid, 144));
        } else if (evt.Name == "dustLead") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenLeadFluid, 144));
        } else if (evt.Name == "dustSilver") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenSilverFluid, 144));
        } else if (evt.Name == "dustPlatinum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenShinyFluid, 144));
        } else if (evt.Name == "dustInvar") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenInvarFluid, 144));
        } else if (evt.Name == "dustElectrum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenElectrumFluid, 144));
        }
    }

    public void unfuxOreDictionary() {
        ArrayList ores = OreDictionary.getOres((String)"ingotCopper");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Copper");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenCopperFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new FluidStack(TContent.moltenTinFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotBronze");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Bronze");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new FluidStack(TContent.moltenBronzeFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotCobalt");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Cobalt");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new FluidStack(TContent.moltenCobaltFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotArdite");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Ardite");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new FluidStack(TContent.moltenArditeFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotManyullyn");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Manyullyn");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new FluidStack(TContent.moltenManyullynFluid, 144));
        }
        ores = OreDictionary.getOres((String)"naturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotAluminumBrass");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new FluidStack(TContent.moltenAlubrassFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotAlumite");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Alumite");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new FluidStack(TContent.moltenAlumiteFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotSteel");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Steel");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenSteelFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenNickelFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenLeadFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenSilverFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenShinyFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenInvarFluid, 144));
        }
        ores = OreDictionary.getOres((String)"ingotElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenElectrumFluid, 144));
        }
        ores = OreDictionary.getOres((String)"oreCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 550, new FluidStack(TContent.moltenCopperFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 275, new FluidStack(TContent.moltenTinFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 350, new FluidStack(TContent.moltenAluminumFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreCobalt");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new FluidStack(TContent.moltenCobaltFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreArdite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new FluidStack(TContent.moltenArditeFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenNickelFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenLeadFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenSilverFluid, 288));
        }
        ores = OreDictionary.getOres((String)"orePlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenShinyFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenInvarFluid, 288));
        }
        ores = OreDictionary.getOres((String)"oreElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenElectrumFluid, 288));
        }
        ores = OreDictionary.getOres((String)"blockCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 550, new FluidStack(TContent.moltenCopperFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 275, new FluidStack(TContent.moltenTinFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockBronze");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 500, new FluidStack(TContent.moltenBronzeFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 350, new FluidStack(TContent.moltenAluminumFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockCobalt");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new FluidStack(TContent.moltenCobaltFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockArdite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new FluidStack(TContent.moltenArditeFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockManyullyn");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 800, new FluidStack(TContent.moltenManyullynFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockAluminumBrass");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 350, new FluidStack(TContent.moltenAlubrassFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockAlumite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 500, new FluidStack(TContent.moltenAlumiteFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockSteel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 500, new FluidStack(TContent.moltenSteelFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenNickelFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenLeadFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenSilverFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenShinyFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenInvarFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"blockElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new FluidStack(TContent.moltenElectrumFluid, 1296));
        }
        ores = OreDictionary.getOres((String)"dustIron");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenIronFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustGold");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenGoldFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenCopperFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new FluidStack(TContent.moltenTinFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustBronze");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new FluidStack(TContent.moltenBronzeFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustCobalt");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new FluidStack(TContent.moltenCobaltFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustArdite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new FluidStack(TContent.moltenArditeFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustManyullyn");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new FluidStack(TContent.moltenManyullynFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustAluminumBrass");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new FluidStack(TContent.moltenAlubrassFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustAlumite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new FluidStack(TContent.moltenAlumiteFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustSteel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new FluidStack(TContent.moltenSteelFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenNickelFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenLeadFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenSilverFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenShinyFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenInvarFluid, 144));
        }
        ores = OreDictionary.getOres((String)"dustElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenElectrumFluid, 144));
        }
        ores = OreDictionary.getOres((String)"nuggetIron");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenIronFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new FluidStack(TContent.moltenCopperFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new FluidStack(TContent.moltenTinFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new FluidStack(TContent.moltenAluminumFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenNickelFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenLeadFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenSilverFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenShinyFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenInvarFluid, 16));
        }
        ores = OreDictionary.getOres((String)"nuggetElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new FluidStack(TContent.moltenElectrumFluid, 16));
        }
    }

    @ForgeSubscribe
    public void bucketFill(FillBucketEvent evt) {
        if (evt.current.func_77973_b() == Item.field_77788_aw && evt.target.field_72313_a == EnumMovingObjectType.TILE) {
            int hitX = evt.target.field_72311_b;
            int hitY = evt.target.field_72312_c;
            int hitZ = evt.target.field_72309_d;
            if (evt.entityPlayer != null && !evt.entityPlayer.func_82247_a(hitX, hitY, hitZ, evt.target.field_72310_e, evt.current)) {
                return;
            }
            int bID = evt.world.func_72798_a(hitX, hitY, hitZ);
            for (int id = 0; id < TContent.fluidBlocks.length; ++id) {
                int localID;
                int posZ;
                int posX;
                if (bID != TContent.fluidBlocks[id].field_71990_ca) continue;
                if (evt.entityPlayer.field_71075_bZ.field_75098_d) {
                    evt.world.func_94571_i(hitX, hitY, hitZ);
                    continue;
                }
                int quanta = 0;
                for (posX = -1; posX <= 1; ++posX) {
                    for (posZ = -1; posZ <= 1; ++posZ) {
                        localID = evt.world.func_72798_a(hitX + posX, hitY, hitZ + posZ);
                        if (localID != bID) continue;
                        quanta += evt.world.func_72805_g(hitX + posX, hitY, hitZ + posZ) + 1;
                    }
                }
                if (quanta >= 8) {
                    while (quanta > 0) {
                        for (posX = -1; posX <= 1; ++posX) {
                            for (posZ = -1; posZ <= 1; ++posZ) {
                                localID = evt.world.func_72798_a(hitX + posX, hitY, hitZ + posZ);
                                if (localID != bID) continue;
                                --quanta;
                                int meta = evt.world.func_72805_g(hitX + posX, hitY, hitZ + posZ);
                                if (meta > 0) {
                                    evt.world.func_72921_c(hitX + posX, hitY, hitZ + posZ, meta - 1, 3);
                                    continue;
                                }
                                evt.world.func_94571_i(hitX + posX, hitY, hitZ + posZ);
                            }
                        }
                    }
                }
                evt.setResult(Event.Result.ALLOW);
            }
        }
    }
}

