/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.DrawbridgeLogic;
import tconstruct.blocks.logic.ToolForgeLogic;
import tconstruct.blocks.logic.ToolStationLogic;
import tconstruct.common.TProxyCommon;
import tconstruct.library.blocks.InventoryLogic;

public class TPacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (packet.field_73630_a.equals("TConstruct")) {
            if (side == Side.SERVER) {
                this.handleServerPacket(packet, (EntityPlayerMP)player);
            } else {
                this.handleClientPacket(packet, (EntityPlayer)player);
            }
        }
    }

    void handleClientPacket(Packet250CustomPayload packet, EntityPlayer player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte packetID = inputStream.readByte();
        }
        catch (Exception e) {
            System.out.println("Failed at reading client packet for TConstruct.");
            e.printStackTrace();
            return;
        }
    }

    void handleServerPacket(Packet250CustomPayload packet, EntityPlayerMP player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte packetID = inputStream.readByte();
            if (packetID == 1) {
                int dimension = inputStream.readInt();
                WorldServer world = DimensionManager.getWorld((int)dimension);
                int x = inputStream.readInt();
                int y = inputStream.readInt();
                int z = inputStream.readInt();
                TileEntity te = world.func_72796_p(x, y, z);
                String toolName = inputStream.readUTF();
                if (te instanceof ToolStationLogic) {
                    ((ToolStationLogic)te).setToolname(toolName);
                }
                if (te instanceof ToolForgeLogic) {
                    ((ToolForgeLogic)te).setToolname(toolName);
                }
            } else if (packetID == 2) {
                int dimension = inputStream.readInt();
                WorldServer world = DimensionManager.getWorld((int)dimension);
                int x = inputStream.readInt();
                int y = inputStream.readInt();
                int z = inputStream.readInt();
                TileEntity te = world.func_72796_p(x, y, z);
                Short itemID = inputStream.readShort();
                Short itemDamage = inputStream.readShort();
                if (te instanceof InventoryLogic) {
                    ((InventoryLogic)te).func_70299_a(1, new ItemStack((int)itemID.shortValue(), 1, (int)itemDamage.shortValue()));
                }
            } else if (packetID == 3) {
                switch (inputStream.readByte()) {
                    case 0: {
                        player.openGui((Object)TConstruct.instance, TProxyCommon.inventoryGui, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                        break;
                    }
                    case 1: {
                        player.openGui((Object)TConstruct.instance, TProxyCommon.armorGuiID, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                        break;
                    }
                    case 2: {
                        player.openGui((Object)TConstruct.instance, TProxyCommon.knapsackGuiID, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    }
                }
            } else if (packetID == 5) {
                int dimension = inputStream.readInt();
                WorldServer world = DimensionManager.getWorld((int)dimension);
                int x = inputStream.readInt();
                int y = inputStream.readInt();
                int z = inputStream.readInt();
                TileEntity te = world.func_72796_p(x, y, z);
                byte direction = inputStream.readByte();
                if (te instanceof DrawbridgeLogic) {
                    ((DrawbridgeLogic)te).setPlacementDirection(direction);
                }
            } else if (packetID == 10) {
                player.field_70143_R = 0.0f;
            }
        }
        catch (IOException e) {
            System.out.println("Failed at reading server packet for TConstruct.");
            e.printStackTrace();
            return;
        }
    }

    Entity getEntity(World world, int id) {
        for (Object o : world.field_72996_f) {
            if (((Entity)o).field_70157_k != id) continue;
            return (Entity)o;
        }
        return null;
    }
}

