/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import tconstruct.util.PHConstruct;

public class SurfaceOreGen
extends WorldGenerator {
    private int minableBlockId;
    private int minableBlockMeta = 0;
    private int numberOfBlocks;
    private int[] replaceBlocks;
    private boolean alterSize;

    public SurfaceOreGen(int id, int meta, int number, boolean changeSize) {
        this(id, meta, number, changeSize, Block.field_71981_t.field_71990_ca, Block.field_71980_u.field_71990_ca, Block.field_71979_v.field_71990_ca, Block.field_71943_B.field_71990_ca, Block.field_71939_E.field_71990_ca, Block.field_71940_F.field_71990_ca, Block.field_72037_aS.field_71990_ca);
    }

    public SurfaceOreGen(int id, int meta, int number, boolean changeSize, int ... target) {
        this.minableBlockId = id;
        this.numberOfBlocks = number;
        this.replaceBlocks = target;
        this.alterSize = changeSize;
        this.minableBlockMeta = meta;
    }

    int findGround(World world, int x, int y, int z) {
        int returnHeight = -1;
        int blockID = world.func_72798_a(x, y - 1, z);
        if (!(Block.field_71970_n[world.func_72798_a(x, y, z)] || blockID != Block.field_71979_v.field_71990_ca && blockID != Block.field_71980_u.field_71990_ca)) {
            return y;
        }
        int height = PHConstruct.seaLevel + 64;
        while (height >= PHConstruct.seaLevel - 30) {
            int bID = world.func_72798_a(x, height, z);
            if (bID == Block.field_71979_v.field_71990_ca || bID == Block.field_71980_u.field_71990_ca) {
                if (Block.field_71970_n[world.func_72798_a(x, height + 1, z)]) break;
                returnHeight = height + 1;
                break;
            }
            if (--height > 0) continue;
        }
        return returnHeight;
    }

    public boolean func_76484_a(World world, Random random, int startX, int startY, int startZ) {
        if (this.alterSize && (startY = this.findGround(world, startX, startY, startZ)) == -1) {
            return false;
        }
        float f = random.nextFloat() * (float)Math.PI;
        int blockNumber = this.numberOfBlocks;
        if (this.alterSize) {
            blockNumber = this.numberOfBlocks * 2 / 5 + random.nextInt(this.numberOfBlocks * 3 / 5);
        }
        double d0 = (float)(startX + 8) + MathHelper.func_76126_a((float)f) * (float)blockNumber / 8.0f;
        double d1 = (float)(startX + 8) - MathHelper.func_76126_a((float)f) * (float)blockNumber / 8.0f;
        double d2 = (float)(startZ + 8) + MathHelper.func_76134_b((float)f) * (float)blockNumber / 8.0f;
        double d3 = (float)(startZ + 8) - MathHelper.func_76134_b((float)f) * (float)blockNumber / 8.0f;
        double d4 = startY + random.nextInt(3) - 2;
        double d5 = startY + random.nextInt(3) - 2;
        for (int l = 0; l <= blockNumber; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)blockNumber;
            double d7 = d4 + (d5 - d4) * (double)l / (double)blockNumber;
            double d8 = d2 + (d3 - d2) * (double)l / (double)blockNumber;
            double d9 = random.nextDouble() * (double)blockNumber / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)blockNumber)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)blockNumber)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    block3: for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        Block block = Block.field_71973_m[world.func_72798_a(k2, l2, i3)];
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        if (block == null || !Block.field_71970_n[world.func_72798_a(k2, l2, i3)]) {
                            world.func_72832_d(k2, l2, i3, this.minableBlockId, this.minableBlockMeta, 2);
                            continue;
                        }
                        for (int iter = 0; iter < this.replaceBlocks.length; ++iter) {
                            if (!block.isGenMineableReplaceable(world, k2, l2, i3, this.replaceBlocks[iter])) continue;
                            world.func_72832_d(k2, l2, i3, this.minableBlockId, this.minableBlockMeta, 2);
                            continue block3;
                        }
                    }
                }
            }
        }
        return true;
    }
}

