/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.worldgen;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import tconstruct.common.TContent;
import tconstruct.util.PHConstruct;
import tconstruct.worldgen.SurfaceOreGen;

public class TerrainGenEventHandler {
    private final SurfaceOreGen ironSurface;
    private final SurfaceOreGen goldSurface;
    private final SurfaceOreGen copperSurface;
    private final SurfaceOreGen tinSurface;
    private final SurfaceOreGen aluminumSurface;
    private final SurfaceOreGen cobaltSurface;
    private static ImmutableCollection<BiomeGenBase> EXTRA_ORE_BIOMES = ImmutableList.of((Object)BiomeGenBase.field_76770_e, (Object)BiomeGenBase.field_76783_v);

    public TerrainGenEventHandler() {
        this.ironSurface = new SurfaceOreGen(TContent.oreGravel.field_71990_ca, 0, 12, true);
        this.goldSurface = new SurfaceOreGen(TContent.oreGravel.field_71990_ca, 1, 20, true);
        this.copperSurface = new SurfaceOreGen(TContent.oreGravel.field_71990_ca, 2, 12, true);
        this.tinSurface = new SurfaceOreGen(TContent.oreGravel.field_71990_ca, 3, 12, true);
        this.aluminumSurface = new SurfaceOreGen(TContent.oreGravel.field_71990_ca, 4, 12, true);
        this.cobaltSurface = new SurfaceOreGen(TContent.oreGravel.field_71990_ca, 5, 30, true);
    }

    @ForgeSubscribe
    public void onDecorateEvent(DecorateBiomeEvent.Decorate e) {
        if (e.type != DecorateBiomeEvent.Decorate.EventType.SAND) {
            return;
        }
        BiomeGenBase biome = e.world.func_72959_q().func_76935_a(e.chunkX, e.chunkZ);
        int iterations = EXTRA_ORE_BIOMES.contains((Object)biome) ? 2 : 1;
        for (int i = 0; i < iterations; ++i) {
            this.generateSurfaceOres(e.rand, e.chunkX, e.chunkZ, e.world);
        }
    }

    private void generateSurfaceOres(Random random, int xChunk, int zChunk, World world) {
        int zPos;
        int yPos;
        int xPos;
        if (PHConstruct.generateIronSurface && random.nextInt(PHConstruct.ironsRarity) == 0) {
            xPos = xChunk + random.nextInt(16);
            yPos = 64 + PHConstruct.seaLevel;
            zPos = zChunk + random.nextInt(16);
            this.ironSurface.func_76484_a(world, random, xPos, yPos, zPos);
        }
        if (PHConstruct.generateGoldSurface && random.nextInt(PHConstruct.goldsRarity) == 0) {
            xPos = xChunk + random.nextInt(16);
            yPos = 64 + PHConstruct.seaLevel;
            zPos = zChunk + random.nextInt(16);
            this.goldSurface.func_76484_a(world, random, xPos, yPos, zPos);
        }
        if (PHConstruct.generateCopperSurface && random.nextInt(PHConstruct.coppersRarity) == 0) {
            xPos = xChunk + random.nextInt(16);
            yPos = 64 + PHConstruct.seaLevel;
            zPos = zChunk + random.nextInt(16);
            this.copperSurface.func_76484_a(world, random, xPos, yPos, zPos);
        }
        if (PHConstruct.generateTinSurface && random.nextInt(PHConstruct.tinsRarity) == 0) {
            xPos = xChunk + random.nextInt(16);
            yPos = 64 + PHConstruct.seaLevel;
            zPos = zChunk + random.nextInt(16);
            this.tinSurface.func_76484_a(world, random, xPos, yPos, zPos);
        }
        if (PHConstruct.generateAluminumSurface && random.nextInt(PHConstruct.aluminumsRarity) == 0) {
            xPos = xChunk + random.nextInt(16);
            yPos = 64 + PHConstruct.seaLevel;
            zPos = zChunk + random.nextInt(16);
            this.aluminumSurface.func_76484_a(world, random, xPos, yPos, zPos);
        }
        if (PHConstruct.generateCobaltSurface && random.nextInt(PHConstruct.cobaltsRarity) == 0) {
            xPos = xChunk + random.nextInt(16);
            yPos = 64 + PHConstruct.seaLevel;
            zPos = zChunk + random.nextInt(16);
            this.cobaltSurface.func_76484_a(world, random, xPos, yPos, zPos);
        }
    }
}

