/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.power;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IPowerReceptor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public final class PowerHandler {
    public static final PerditionCalculator DEFAULT_PERDITION = new PerditionCalculator();
    private float minEnergyReceived;
    private float maxEnergyReceived;
    private float maxEnergyStored;
    private float activationEnergy;
    private float energyStored = 0.0f;
    private final SafeTimeTracker doWorkTracker = new SafeTimeTracker();
    private final SafeTimeTracker sourcesTracker = new SafeTimeTracker();
    private final SafeTimeTracker perditionTracker = new SafeTimeTracker();
    public final int[] powerSources = new int[6];
    public final IPowerReceptor receptor;
    private PerditionCalculator perdition;
    private final PowerReceiver receiver;
    private final Type type;

    public PowerHandler(IPowerReceptor receptor, Type type) {
        this.receptor = receptor;
        this.type = type;
        this.receiver = new PowerReceiver();
        this.perdition = DEFAULT_PERDITION;
    }

    public PowerReceiver getPowerReceiver() {
        return this.receiver;
    }

    public float getMinEnergyReceived() {
        return this.minEnergyReceived;
    }

    public float getMaxEnergyReceived() {
        return this.maxEnergyReceived;
    }

    public float getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    public float getActivationEnergy() {
        return this.activationEnergy;
    }

    public float getEnergyStored() {
        return this.energyStored;
    }

    public void configure(float minEnergyReceived, float maxEnergyReceived, float activationEnergy, float maxStoredEnergy) {
        if (minEnergyReceived > maxEnergyReceived) {
            maxEnergyReceived = minEnergyReceived;
        }
        this.minEnergyReceived = minEnergyReceived;
        this.maxEnergyReceived = maxEnergyReceived;
        this.maxEnergyStored = maxStoredEnergy;
        this.activationEnergy = activationEnergy;
    }

    public void configurePowerPerdition(int powerLoss, int powerLossRegularity) {
        if (powerLoss == 0 || powerLossRegularity == 0) {
            this.perdition = new PerditionCalculator(0.0f);
            return;
        }
        this.perdition = new PerditionCalculator((float)powerLoss / (float)powerLossRegularity);
    }

    public void setPerdition(PerditionCalculator perdition) {
        if (perdition == null) {
            perdition = DEFAULT_PERDITION;
        }
        this.perdition = perdition;
    }

    public PerditionCalculator getPerdition() {
        if (this.perdition == null) {
            return DEFAULT_PERDITION;
        }
        return this.perdition;
    }

    public void update() {
        this.applyPerdition();
        this.applyWork();
        this.validateEnergy();
    }

    private void applyPerdition() {
        if (this.perditionTracker.markTimeIfDelay(this.receptor.getWorld(), 1L) && this.energyStored > 0.0f) {
            float newEnergy = this.getPerdition().applyPerdition(this, this.energyStored, this.perditionTracker.durationOfLastDelay());
            this.energyStored = newEnergy == 0.0f || newEnergy < this.energyStored ? newEnergy : DEFAULT_PERDITION.applyPerdition(this, this.energyStored, this.perditionTracker.durationOfLastDelay());
            this.validateEnergy();
        }
    }

    private void applyWork() {
        if (this.energyStored >= this.activationEnergy && this.doWorkTracker.markTimeIfDelay(this.receptor.getWorld(), 1L)) {
            this.receptor.doWork(this);
        }
    }

    private void updateSources(ForgeDirection source) {
        if (this.sourcesTracker.markTimeIfDelay(this.receptor.getWorld(), 1L)) {
            for (int i = 0; i < 6; ++i) {
                int n = i;
                this.powerSources[n] = (int)((long)this.powerSources[n] - this.sourcesTracker.durationOfLastDelay());
                if (this.powerSources[i] >= 0) continue;
                this.powerSources[i] = 0;
            }
        }
        if (source != null) {
            this.powerSources[source.ordinal()] = 10;
        }
    }

    public float useEnergy(float min, float max, boolean doUse) {
        this.applyPerdition();
        float result = 0.0f;
        if (this.energyStored >= min) {
            if (this.energyStored <= max) {
                result = this.energyStored;
                if (doUse) {
                    this.energyStored = 0.0f;
                }
            } else {
                result = max;
                if (doUse) {
                    this.energyStored -= max;
                }
            }
        }
        this.validateEnergy();
        return result;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.readFromNBT(data, "powerProvider");
    }

    public void readFromNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = data.func_74775_l(tag);
        this.energyStored = nbt.func_74760_g("storedEnergy");
    }

    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBT(data, "powerProvider");
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("storedEnergy", this.energyStored);
        data.func_74766_a(tag, nbt);
    }

    public float addEnergy(float quantity) {
        this.energyStored += quantity;
        if (this.energyStored > this.maxEnergyStored) {
            quantity -= this.energyStored - this.maxEnergyStored;
            this.energyStored = this.maxEnergyStored;
        } else if (this.energyStored < 0.0f) {
            quantity -= this.energyStored;
            this.energyStored = 0.0f;
        }
        this.applyPerdition();
        return quantity;
    }

    public void setEnergy(float quantity) {
        this.energyStored = quantity;
        this.validateEnergy();
    }

    public boolean isPowerSource(ForgeDirection from) {
        return this.powerSources[from.ordinal()] != 0;
    }

    private void validateEnergy() {
        if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
        if (this.energyStored > this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    public final class PowerReceiver {
        private PowerReceiver() {
        }

        public float getMinEnergyReceived() {
            return PowerHandler.this.minEnergyReceived;
        }

        public float getMaxEnergyReceived() {
            return PowerHandler.this.maxEnergyReceived;
        }

        public float getMaxEnergyStored() {
            return PowerHandler.this.maxEnergyStored;
        }

        public float getActivationEnergy() {
            return PowerHandler.this.activationEnergy;
        }

        public float getEnergyStored() {
            return PowerHandler.this.energyStored;
        }

        public Type getType() {
            return PowerHandler.this.type;
        }

        public void update() {
            PowerHandler.this.update();
        }

        public float powerRequest() {
            this.update();
            return Math.min(PowerHandler.this.maxEnergyReceived, PowerHandler.this.maxEnergyStored - PowerHandler.this.energyStored);
        }

        public float receiveEnergy(Type source, float quantity, ForgeDirection from) {
            float used = quantity;
            if (source == Type.ENGINE) {
                if (used < PowerHandler.this.minEnergyReceived) {
                    return 0.0f;
                }
                if (used > PowerHandler.this.maxEnergyReceived) {
                    used = PowerHandler.this.maxEnergyReceived;
                }
            }
            PowerHandler.this.updateSources(from);
            used -= used * PowerHandler.this.getPerdition().getTaxPercent();
            used = PowerHandler.this.addEnergy(used);
            PowerHandler.this.applyWork();
            if (source == Type.ENGINE && PowerHandler.this.type.eatsEngineExcess()) {
                used = Math.min(quantity, PowerHandler.this.maxEnergyReceived);
            }
            return used;
        }
    }

    public static class PerditionCalculator {
        public static final float DEFAULT_POWERLOSS = 1.0f;
        public static final float MIN_POWERLOSS = 0.01f;
        private final float powerLoss;

        public PerditionCalculator() {
            this.powerLoss = 1.0f;
        }

        public PerditionCalculator(float powerLoss) {
            if (powerLoss < 0.01f) {
                powerLoss = 0.01f;
            }
            this.powerLoss = powerLoss;
        }

        public float applyPerdition(PowerHandler powerHandler, float current, long ticksPassed) {
            if ((current -= this.powerLoss * (float)ticksPassed) < 0.0f) {
                current = 0.0f;
            }
            return current;
        }

        public float getTaxPercent() {
            return 0.0f;
        }
    }

    public static enum Type {
        ENGINE,
        GATE,
        MACHINE,
        PIPE,
        STORAGE;


        public boolean canReceiveFromPipes() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }

        public boolean eatsEngineExcess() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }
    }
}

