/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.HashMap;
import java.util.Map;
import mods.railcraft.client.render.RenderFakeBlock;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidRenderer {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    private static Map flowingRenderCache = new HashMap();
    private static Map stillRenderCache = new HashMap();
    public static final int DISPLAY_STAGES = 100;
    private static final RenderFakeBlock.RenderInfo liquidBlock = new RenderFakeBlock.RenderInfo();

    public static Icon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return FluidRenderer.getSafeIcon(null);
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return FluidRenderer.getSafeIcon(null);
        }
        Icon icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        icon = FluidRenderer.getSafeIcon(icon);
        return icon;
    }

    private static Icon getSafeIcon(Icon icon) {
        if (icon == null) {
            return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static ResourceLocation getFluidSheet(FluidStack liquid) {
        return BLOCK_TEXTURE;
    }

    public static ResourceLocation setupFlowingLiquidTexture(FluidStack liquid, Icon[] texArray) {
        if (liquid == null || liquid.amount <= 0) {
            return null;
        }
        Fluid fluid = liquid.getFluid();
        if (fluid == null) {
            return null;
        }
        Icon top = FluidRenderer.getSafeIcon(fluid.getStillIcon());
        Icon side = FluidRenderer.getSafeIcon(fluid.getFlowingIcon());
        texArray[0] = top;
        texArray[1] = top;
        texArray[2] = side;
        texArray[3] = side;
        texArray[4] = side;
        texArray[5] = side;
        return FluidRenderer.getFluidSheet(liquid);
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static int[] getLiquidDisplayLists(FluidStack fluidStack) {
        return FluidRenderer.getLiquidDisplayLists(fluidStack, false);
    }

    public static int[] getLiquidDisplayLists(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = (int[])cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        FluidRenderer.liquidBlock.texture[0] = null;
        if (fluid.getBlockID() > 0) {
            FluidRenderer.liquidBlock.template = Block.field_71973_m[fluid.getBlockID()];
            FluidRenderer.liquidBlock.texture[0] = FluidRenderer.getFluidTexture(fluidStack, flowing);
        } else {
            FluidRenderer.liquidBlock.template = Block.field_71943_B;
            FluidRenderer.liquidBlock.texture[0] = FluidRenderer.getFluidTexture(fluidStack, flowing);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            FluidRenderer.liquidBlock.minX = 0.01f;
            FluidRenderer.liquidBlock.minY = 0.0f;
            FluidRenderer.liquidBlock.minZ = 0.01f;
            FluidRenderer.liquidBlock.maxX = 0.99f;
            FluidRenderer.liquidBlock.maxY = (float)s / 100.0f;
            FluidRenderer.liquidBlock.maxZ = 0.99f;
            RenderFakeBlock.renderBlockForEntity(liquidBlock, null, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        cache.put(fluid, diplayLists);
        return diplayLists;
    }

    static {
        FluidRenderer.liquidBlock.texture = new Icon[1];
    }
}

