/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.client.render.BlockRenderer;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderEmblemItem;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.blocks.aesthetics.post.BlockPost;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.blocks.aesthetics.post.PostConnectionHelper;
import mods.railcraft.common.blocks.aesthetics.post.TilePostEmblem;
import mods.railcraft.common.emblems.ItemEmblem;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderBlockPost
extends BlockRenderer {
    private static final float PIX = 0.0625f;

    public static BlockRenderer make() {
        RenderBlockPost renderer = new RenderBlockPost(BlockPost.block);
        renderer.addCombinedRenderer(EnumPost.WOOD.ordinal(), new RenderPost());
        renderer.addCombinedRenderer(EnumPost.WOOD_PLATFORM.ordinal(), new RenderPost());
        renderer.addCombinedRenderer(EnumPost.STONE.ordinal(), new RenderPostStone());
        renderer.addCombinedRenderer(EnumPost.STONE_PLATFORM.ordinal(), new RenderPostStone());
        renderer.addCombinedRenderer(EnumPost.METAL.ordinal(), new RenderPost());
        renderer.addCombinedRenderer(EnumPost.METAL_PLATFORM.ordinal(), new RenderPost());
        renderer.addCombinedRenderer(EnumPost.EMBLEM.ordinal(), new RenderPostSign());
        return renderer;
    }

    protected RenderBlockPost(Block block) {
        super(block);
    }

    public static class EmblemPostTESR
    extends TileEntitySpecialRenderer {
        public void func_76894_a(TileEntity tile, double x, double y, double z, float f) {
            TilePostEmblem post = (TilePostEmblem)tile;
            if (post.getEmblem() == null || post.getEmblem().equals("")) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)3042);
            float pix = 0.0625f;
            float shift = 0.5f;
            float scale = 0.6f;
            GL11.glTranslatef((float)((float)x), (float)((float)y + pix), (float)((float)z));
            GL11.glTranslatef((float)shift, (float)0.0f, (float)shift);
            switch (post.getFacing()) {
                case NORTH: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GL11.glTranslatef((float)(-shift), (float)0.0f, (float)(-shift));
            GL11.glTranslatef((float)shift, (float)shift, (float)shift);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)(-shift), (float)(-shift), (float)(-shift));
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.98f);
            RenderEmblemItem.renderIn3D(ItemEmblem.getEmblem(post.getEmblem()), false);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    protected static class RenderPostSign
    extends RenderPost {
        protected RenderPostSign() {
        }

        @Override
        public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            super.renderBlock(renderblocks, world, x, y, z, block);
            this.renderSign(renderblocks, world, x, y, z, block);
        }

        public void renderSign(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            TileEntity tile = world.func_72796_p(x, y, z);
            if (!(tile instanceof TilePostEmblem)) {
                return;
            }
            TilePostEmblem tileEmblem = (TilePostEmblem)tile;
            float pix = 0.0625f;
            float minY = 2.0f * pix;
            float maxY = 1.0f;
            switch (tileEmblem.getFacing()) {
                case NORTH: {
                    block.func_71905_a(pix, minY, 4.0f * pix, 15.0f * pix, maxY, 6.0f * pix);
                    break;
                }
                case SOUTH: {
                    block.func_71905_a(pix, minY, 10.0f * pix, 15.0f * pix, maxY, 12.0f * pix);
                    break;
                }
                case WEST: {
                    block.func_71905_a(4.0f * pix, minY, pix, 6.0f * pix, maxY, 15.0f * pix);
                    break;
                }
                default: {
                    block.func_71905_a(10.0f * pix, minY, pix, 12.0f * pix, maxY, 15.0f * pix);
                }
            }
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            float w = this.getCenterColumnWidth();
            float b1 = (8.0f - w / 2.0f) * pix;
            float b2 = (8.0f + w / 2.0f) * pix;
            minY = 2.0f * pix;
            if (world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP, true) || PostConnectionHelper.connect(world, x, y, z, ForgeDirection.DOWN) != IPostConnection.ConnectStyle.NONE) {
                minY = 0.0f;
            }
            block.func_71905_a(b1, minY, b1, b2, 1.0f, b2);
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        }

        @Override
        public boolean shouldRenderColumn(IBlockAccess world, int x, int y, int z) {
            return false;
        }

        @Override
        public void renderPlatform(RenderBlocks renderblocks, int x, int y, int z, Block block) {
        }

        @Override
        public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
            Icon texture = item.func_77973_b().getIcon(item, 0);
            Block block = Block.field_71973_m[((ItemBlock)item.func_77973_b()).func_77883_f()];
            if (block == null) {
                return;
            }
            GL11.glPushMatrix();
            switch (renderType) {
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            float pix = 0.0625f;
            float w = this.getCenterColumnWidth();
            float b1 = (8.0f - w / 2.0f) * pix;
            float b2 = (8.0f + w / 2.0f) * pix;
            block.func_71905_a(b1, 0.0f, b1, b2, 1.0f, b2);
            RenderTools.renderBlockOnInventory(renderblocks, block, item.func_77960_j(), 1.0f, -1, texture);
            float minY = 2.0f * pix;
            float maxY = 1.0f;
            block.func_71905_a(pix, minY, 10.0f * pix, 15.0f * pix, maxY, 12.0f * pix);
            RenderTools.renderBlockOnInventory(renderblocks, block, item.func_77960_j(), 1.0f, -1, texture);
            this.renderEmblem(ItemPost.getEmblem(item));
            block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            GL11.glPopMatrix();
        }

        private void renderEmblem(String emblem) {
            if (emblem == null || emblem.equals("")) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            float pix = 0.0625f;
            float shift = 0.5f;
            float scale = 0.6f;
            GL11.glTranslatef((float)-0.5f, (float)(-0.5f + pix), (float)0.09f);
            GL11.glTranslatef((float)shift, (float)shift, (float)shift);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)(-shift), (float)(-shift), (float)(-shift));
            RenderEmblemItem.renderIn3D(ItemEmblem.getEmblem(emblem), false);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    protected static class RenderPostStone
    extends RenderPost {
        protected RenderPostStone() {
        }

        @Override
        public float getPlatformThinkness() {
            return 4.0f;
        }

        @Override
        public float getCenterColumnWidth() {
            return 6.0f;
        }

        @Override
        public void renderBlock(RenderBlocks renderblocks, IBlockAccess iBlockAccess, int x, int y, int z, Block block) {
            float f7;
            boolean south;
            BlockPostBase blockPost = (BlockPostBase)block;
            float pix = 0.0625f;
            World world = Game.getWorld();
            int meta = world.func_72805_g(x, y, z);
            TileEntity tile = null;
            if (block.hasTileEntity(meta)) {
                tile = world.func_72796_p(x, y, z);
            }
            this.evaluateCenterColumn(renderblocks, (IBlockAccess)world, x, y, z, blockPost, meta, tile);
            boolean east_west = false;
            boolean north_south = false;
            boolean west = PostConnectionHelper.connect((IBlockAccess)world, x, y, z, ForgeDirection.WEST) != IPostConnection.ConnectStyle.NONE;
            boolean east = PostConnectionHelper.connect((IBlockAccess)world, x, y, z, ForgeDirection.EAST) != IPostConnection.ConnectStyle.NONE;
            boolean north = PostConnectionHelper.connect((IBlockAccess)world, x, y, z, ForgeDirection.NORTH) != IPostConnection.ConnectStyle.NONE;
            boolean bl = south = PostConnectionHelper.connect((IBlockAccess)world, x, y, z, ForgeDirection.SOUTH) != IPostConnection.ConnectStyle.NONE;
            if (east || west) {
                east_west = true;
            }
            if (north || south) {
                north_south = true;
            }
            if (!east_west && !north_south) {
                east_west = true;
            }
            float f = 6.0f * pix;
            float f1 = 10.0f * pix;
            float f2 = 4.0f * pix;
            float f3 = 15.0f * pix;
            float f4 = west ? 0.0f : f;
            float f5 = east ? 1.0f : f1;
            float f6 = north ? 0.0f : f;
            float f8 = f7 = south ? 1.0f : f1;
            if (east_west) {
                block.func_71905_a(f4, f2, f, f5, f3, f1);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            if (north_south) {
                block.func_71905_a(f, f2, f6, f1, f3, f7);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
            Icon texture = item.func_77973_b().func_77617_a(item.func_77960_j());
            Block block = Block.field_71973_m[((ItemBlock)item.func_77973_b()).func_77883_f()];
            if (block == null) {
                return;
            }
            float pix = 0.0625f;
            float pix2 = 2.0f * pix;
            float pix3 = 3.0f * pix;
            int numSections = ((BlockPostBase)block).isPlatform(item.func_77960_j()) ? 4 : 3;
            for (int section = 0; section < numSections; ++section) {
                if (section == 0) {
                    block.func_71905_a(0.5f - pix3, 0.0f, 0.0f, 0.5f + pix3, 1.0f, pix3 * 2.0f);
                }
                if (section == 1) {
                    block.func_71905_a(0.5f - pix3, 0.0f, 1.0f - pix3 * 2.0f, 0.5f + pix3, 1.0f, 1.0f);
                }
                if (section == 2) {
                    block.func_71905_a(0.5f - pix2, 0.5f - pix3, -pix * 2.0f, 0.5f + pix2, 1.0f - pix, 1.0f + pix2);
                }
                if (section == 3) {
                    block.func_71905_a(0.0f, (16.0f - this.getPlatformThinkness()) * pix, 0.0f, 1.0f, 1.0f, 1.0f);
                }
                renderblocks.func_83018_a(block);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                Tessellator tess = Tessellator.field_78398_a;
                tess.func_78382_b();
                tess.func_78375_b(0.0f, -1.0f, 0.0f);
                renderblocks.func_78613_a(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 1.0f, 0.0f);
                renderblocks.func_78617_b(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, -1.0f);
                renderblocks.func_78611_c(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, 1.0f);
                renderblocks.func_78622_d(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(-1.0f, 0.0f, 0.0f);
                renderblocks.func_78573_e(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(1.0f, 0.0f, 0.0f);
                renderblocks.func_78605_f(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    protected static class RenderPost
    implements ICombinedRenderer {
        protected RenderPost() {
        }

        @Override
        public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            BlockPostBase blockPost = (BlockPostBase)block;
            int meta = world.func_72805_g(x, y, z);
            TileEntity tile = null;
            if (block.hasTileEntity(meta)) {
                tile = world.func_72796_p(x, y, z);
            }
            boolean renderColumn = this.evaluateCenterColumn(renderblocks, world, x, y, z, blockPost, meta, tile);
            boolean thinConnected = this.renderTwoThinConnectStyle(renderblocks, world, x, y, z, blockPost);
            this.renderSingleThickConnectStyle(renderblocks, world, x, y, z, blockPost, thinConnected, renderColumn);
            blockPost.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }

        private boolean renderTwoThinConnectStyle(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, BlockPostBase block) {
            float f7;
            boolean south;
            boolean east_west = false;
            boolean north_south = false;
            boolean west = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.WEST) == IPostConnection.ConnectStyle.TWO_THIN;
            boolean east = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.EAST) == IPostConnection.ConnectStyle.TWO_THIN;
            boolean north = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.NORTH) == IPostConnection.ConnectStyle.TWO_THIN;
            boolean bl = south = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.SOUTH) == IPostConnection.ConnectStyle.TWO_THIN;
            if (east || west) {
                east_west = true;
            }
            if (north || south) {
                north_south = true;
            }
            if (!east_west && !north_south) {
                east_west = true;
            }
            float f = 0.4375f;
            float f1 = 0.5625f;
            float f2 = 0.6875f;
            float f3 = 0.875f;
            float f4 = west ? 0.0f : f;
            float f5 = east ? 1.0f : f1;
            float f6 = north ? 0.0f : f;
            float f8 = f7 = south ? 1.0f : f1;
            if (east_west) {
                block.func_71905_a(f4, f2, f, f5, f3, f1);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            if (north_south) {
                block.func_71905_a(f, f2, f6, f1, f3, f7);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            f2 = 0.3125f;
            f3 = 0.5f;
            if (east_west) {
                block.func_71905_a(f4, f2, f, f5, f3, f1);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            if (north_south) {
                block.func_71905_a(f, f2, f6, f1, f3, f7);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            return east || west || north || south;
        }

        private void renderSingleThickConnectStyle(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, BlockPostBase block, boolean thinConnected, boolean renderColumn) {
            float f7;
            boolean south;
            boolean east_west = false;
            boolean north_south = false;
            boolean west = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.WEST) == IPostConnection.ConnectStyle.SINGLE_THICK;
            boolean east = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.EAST) == IPostConnection.ConnectStyle.SINGLE_THICK;
            boolean north = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.NORTH) == IPostConnection.ConnectStyle.SINGLE_THICK;
            boolean bl = south = PostConnectionHelper.connect(world, x, y, z, ForgeDirection.SOUTH) == IPostConnection.ConnectStyle.SINGLE_THICK;
            if (east || west) {
                east_west = true;
            }
            if (north || south) {
                north_south = true;
            }
            if (!east_west && !north_south && thinConnected && !renderColumn) {
                east_west = true;
            }
            float f = 0.376f;
            float f1 = 0.624f;
            float f2 = 0.375f;
            float f3 = 0.75f;
            float f4 = west ? 0.0f : f;
            float f5 = east ? 1.0f : f1;
            float f6 = north ? 0.0f : f;
            float f8 = f7 = south ? 1.0f : f1;
            if (east_west) {
                block.func_71905_a(f4, f2, f, f5, f3, f1);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            if (north_south) {
                block.func_71905_a(f, f2, f6, f1, f3, f7);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
        }

        public boolean evaluateCenterColumn(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, BlockPostBase block, int meta, TileEntity tile) {
            boolean renderPlatform;
            boolean renderColumm = this.shouldRenderColumn(world, x, y, z);
            int aboveId = world.func_72798_a(x, y + 1, z);
            boolean bl = renderPlatform = block.isPlatform(meta) || BlockRailBase.func_72184_d((int)aboveId);
            if (renderColumm) {
                this.renderCenterColumn(renderblocks, x, y, z, block);
            } else if (!world.func_72799_c(x, y + 1, z) && !renderPlatform) {
                this.renderMiniPlatform(renderblocks, x, y, z, block);
            }
            if (renderPlatform) {
                this.renderPlatform(renderblocks, x, y, z, block);
            }
            return renderColumm;
        }

        public boolean shouldRenderColumn(IBlockAccess world, int x, int y, int z) {
            Block below = WorldPlugin.getBlock(world, x, y - 1, z);
            Block above = WorldPlugin.getBlock(world, x, y + 1, z);
            if (below == null || !BlockRailBase.func_72184_d((int)below.field_71990_ca)) {
                if (world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP, true) || PostConnectionHelper.connect(world, x, y, z, ForgeDirection.DOWN) != IPostConnection.ConnectStyle.NONE) {
                    return true;
                }
                if (above instanceof BlockPostBase) {
                    return true;
                }
            }
            return false;
        }

        public void renderPlatform(RenderBlocks renderblocks, int x, int y, int z, Block block) {
            block.func_71905_a(0.0f, (16.0f - this.getPlatformThinkness()) * 0.0625f, 0.0f, 1.0f, 1.0f, 1.0f);
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        }

        public void renderCenterColumn(RenderBlocks renderblocks, int x, int y, int z, Block block) {
            float w = this.getCenterColumnWidth();
            float b1 = (8.0f - w / 2.0f) * 0.0625f;
            float b2 = (8.0f + w / 2.0f) * 0.0625f;
            block.func_71905_a(b1, 0.0f, b1, b2, 1.0f, b2);
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        }

        public void renderMiniPlatform(RenderBlocks renderblocks, int x, int y, int z, Block block) {
            float w = this.getCenterColumnWidth();
            float b1 = (8.0f - w / 2.0f) * 0.0625f;
            float b2 = (8.0f + w / 2.0f) * 0.0625f;
            block.func_71905_a(b1, 0.75f, b1, b2, 1.0f, b2);
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        }

        public float getPlatformThinkness() {
            return 2.0f;
        }

        public float getCenterColumnWidth() {
            return 4.0f;
        }

        @Override
        public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
            Icon texture = item.func_77973_b().getIcon(item, 0);
            Block block = Block.field_71973_m[((ItemBlock)item.func_77973_b()).func_77883_f()];
            if (block == null) {
                return;
            }
            int numSections = ((BlockPostBase)block).isPlatform(item.func_77960_j()) ? 5 : 4;
            for (int section = 0; section < numSections; ++section) {
                float f4 = 0.125f;
                if (section == 0) {
                    block.func_71905_a(0.5f - f4, 0.0f, 0.0f, 0.5f + f4, 1.0f, f4 * 2.0f);
                }
                if (section == 1) {
                    block.func_71905_a(0.5f - f4, 0.0f, 1.0f - f4 * 2.0f, 0.5f + f4, 1.0f, 1.0f);
                }
                f4 = 0.0625f;
                if (section == 2) {
                    block.func_71905_a(0.5f - f4, 1.0f - f4 * 3.0f, -f4 * 2.0f, 0.5f + f4, 1.0f - f4, 1.0f + f4 * 2.0f);
                }
                if (section == 3) {
                    block.func_71905_a(0.5f - f4, 0.5f - f4 * 3.0f, -f4 * 2.0f, 0.5f + f4, 0.5f - f4, 1.0f + f4 * 2.0f);
                }
                if (section == 4) {
                    block.func_71905_a(0.0f, (16.0f - this.getPlatformThinkness()) * 0.0625f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
                renderblocks.func_83018_a(block);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                Tessellator tess = Tessellator.field_78398_a;
                tess.func_78382_b();
                tess.func_78375_b(0.0f, -1.0f, 0.0f);
                renderblocks.func_78613_a(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 1.0f, 0.0f);
                renderblocks.func_78617_b(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, -1.0f);
                renderblocks.func_78611_c(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(0.0f, 0.0f, 1.0f);
                renderblocks.func_78622_d(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(-1.0f, 0.0f, 0.0f);
                renderblocks.func_78573_e(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                tess.func_78382_b();
                tess.func_78375_b(1.0f, 0.0f, 0.0f);
                renderblocks.func_78605_f(block, 0.0, 0.0, 0.0, texture);
                tess.func_78381_a();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

