/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.client.emblems.EmblemPackageManager;
import mods.railcraft.client.render.carts.CartModelManager;
import mods.railcraft.client.render.carts.CartModelRenderer;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LocomotiveRenderer
extends CartModelRenderer {
    @Override
    public boolean render(RenderCart renderer, EntityMinecart cart, float light, float time) {
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        EntityLocomotive loco = (EntityLocomotive)cart;
        ResourceLocation[] textures = loco.getLocomotiveTextures();
        ModelBase model = CartModelManager.getCoreModel(cart.getClass());
        for (int pass = 0; pass < 3; ++pass) {
            renderer.func_110776_a(textures[pass]);
            int color = 0xFFFFFF;
            switch (pass) {
                case 0: {
                    color = EnumColor.fromId(loco.getPrimaryColor()).getHexColor();
                    break;
                }
                case 1: {
                    color = EnumColor.fromId(loco.getSecondaryColor()).getHexColor();
                }
            }
            float dim = light;
            float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
            float c3 = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(c1 * dim), (float)(c2 * dim), (float)(c3 * dim), (float)1.0f);
            model.func_78088_a((Entity)cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            String emblem = loco.getEmblem();
            if (emblem == null || emblem.equals("")) continue;
            renderer.func_110776_a(EmblemPackageManager.getEmblemTexture(emblem).getLocation());
            Tessellator tess = Tessellator.field_78398_a;
            float size = 0.15f;
            float offsetX = 0.47f;
            float offsetY = -0.17f;
            float offsetZ = -0.515f;
            tess.func_78382_b();
            tess.func_78374_a((double)(offsetX - size), (double)(offsetY - size), (double)offsetZ, 0.0, 0.0);
            tess.func_78374_a((double)(offsetX - size), (double)(offsetY + size), (double)offsetZ, 0.0, 1.0);
            tess.func_78374_a((double)(offsetX + size), (double)(offsetY + size), (double)offsetZ, 1.0, 1.0);
            tess.func_78374_a((double)(offsetX + size), (double)(offsetY + -size), (double)offsetZ, 1.0, 0.0);
            tess.func_78374_a((double)(offsetX + size), (double)(offsetY + -size), (double)(-offsetZ), 0.0, 0.0);
            tess.func_78374_a((double)(offsetX + size), (double)(offsetY + size), (double)(-offsetZ), 0.0, 1.0);
            tess.func_78374_a((double)(offsetX - size), (double)(offsetY + size), (double)(-offsetZ), 1.0, 1.0);
            tess.func_78374_a((double)(offsetX - size), (double)(offsetY - size), (double)(-offsetZ), 1.0, 0.0);
            tess.func_78381_a();
        }
        GL11.glPopMatrix();
        return false;
    }
}

