/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.lamp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.lamp.BlockStoneLamp;
import mods.railcraft.common.blocks.aesthetics.slab.EnumSlab;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public enum EnumStoneLamp {
    ABYSSAL,
    BLEACHEDBONE,
    BLOODSTAINED,
    FROSTBOUND,
    INFERNAL,
    NETHER,
    QUARRIED,
    SANDY,
    SANDSTONE,
    STONE;

    public static final EnumStoneLamp[] VALUES;
    public static final Map NAMES;
    public static final List creativeList;
    private ItemStack source;

    public static void initialize() {
        EnumStoneLamp.ABYSSAL.source = EnumSlab.ABYSSAL_BLOCK.getItem();
        EnumStoneLamp.BLEACHEDBONE.source = EnumSlab.BLEACHEDBONE_BLOCK.getItem();
        EnumStoneLamp.BLOODSTAINED.source = EnumSlab.BLOODSTAINED_BLOCK.getItem();
        EnumStoneLamp.FROSTBOUND.source = EnumSlab.FROSTBOUND_BLOCK.getItem();
        EnumStoneLamp.INFERNAL.source = EnumSlab.INFERNAL_BLOCK.getItem();
        EnumStoneLamp.NETHER.source = EnumSlab.NETHER_BLOCK.getItem();
        EnumStoneLamp.QUARRIED.source = EnumSlab.QUARRIED_BLOCK.getItem();
        EnumStoneLamp.SANDY.source = EnumSlab.SANDY_BLOCK.getItem();
        EnumStoneLamp.SANDSTONE.source = new ItemStack((Block)Block.field_72079_ak, 1, 1);
        EnumStoneLamp.STONE.source = new ItemStack((Block)Block.field_72079_ak, 1, 0);
        for (EnumStoneLamp lamp : VALUES) {
            NAMES.put(lamp.name(), lamp);
            if (lamp.isEnabled() && lamp.source != null) {
                CraftingPlugin.addShapedRecipe(lamp.getItem(1), " S ", " T ", " S ", Character.valueOf('S'), lamp.getSource(), Character.valueOf('T'), new ItemStack(Block.field_72069_aq));
            }
            creativeList.add(lamp);
        }
    }

    public static EnumStoneLamp fromOrdinal(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public static EnumStoneLamp fromName(String name) {
        EnumStoneLamp lamp = (EnumStoneLamp)((Object)NAMES.get(name));
        if (lamp != null) {
            return lamp;
        }
        return ABYSSAL;
    }

    public Icon getTexture(int side) {
        return Block.field_71973_m[this.source.field_77993_c].func_71858_a(ForgeDirection.UP.ordinal(), this.source.func_77960_j());
    }

    public Block getBlock() {
        return BlockStoneLamp.getBlock();
    }

    public ItemStack getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.func_77946_l();
    }

    public ItemStack getItem() {
        return this.getItem(1);
    }

    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public String getTag() {
        return "railcraft.stonelamp." + this.name().replace("_", ".").toLowerCase(Locale.ENGLISH);
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && this.getBlock() != null;
    }

    static {
        VALUES = EnumStoneLamp.values();
        NAMES = new HashMap();
        creativeList = new ArrayList();
    }
}

