/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPostMetal;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockPostMetal
extends BlockPostBase {
    public static BlockPostMetal post;
    public static BlockPostMetal platform;
    public static Icon[] textures;
    public final boolean isPlatform;

    private BlockPostMetal(int id, int renderType, boolean isPlatform) {
        super(id, renderType);
        this.func_71884_a(Block.field_71977_i);
        this.isPlatform = isPlatform;
    }

    public static void registerPost() {
        int id;
        if (post == null && (id = RailcraftConfig.getBlockId("block.post.metal")) > 0) {
            post = BlockPostMetal.make(id, "post.metal", Railcraft.getProxy().getRenderId(), false);
        }
    }

    public static void registerPlatform() {
        int id;
        if (platform == null && (id = RailcraftConfig.getBlockId("block.post.metal.platform")) > 0) {
            platform = BlockPostMetal.make(id, "post.metal.platform", Railcraft.getProxy().getRenderId(), true);
        }
    }

    private static BlockPostMetal make(int id, String tag, int renderType, boolean isPlatform) {
        BlockPostMetal block = new BlockPostMetal(id, renderType, isPlatform);
        block.func_71864_b("railcraft." + tag);
        GameRegistry.registerBlock((Block)block, ItemPostMetal.class, (String)block.func_71917_a());
        MinecraftForge.setBlockHarvestLevel((Block)block, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)block, (String)"pickaxe", (int)2);
        ForestryPlugin.addBackpackItem("builder", block);
        for (EnumColor color : EnumColor.values()) {
            ItemStack stack = block.getItem(1, color.ordinal());
            RailcraftLanguage.instance().registerItemName(stack, tag + "." + color.getBasicTag());
            ItemRegistry.registerItemStack(tag + "." + color.getBasicTag(), stack);
        }
        return block;
    }

    @Override
    public boolean isPlatform(int meta) {
        return this.isPlatform;
    }

    public ItemStack getItem() {
        return this.getItem(1, 3);
    }

    public ItemStack getItem(int qty) {
        return this.getItem(qty, 3);
    }

    public ItemStack getItem(int qty, int color) {
        return new ItemStack((Block)this, qty, color);
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumColor color : EnumColor.values()) {
            list.add(this.getItem(1, color.ordinal()));
        }
    }

    protected boolean func_71906_q_() {
        return true;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(EnumPost.METAL.getItem());
        return list;
    }

    public void func_94332_a(IconRegister iconRegister) {
        if (!this.isPlatform) {
            textures = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:post.metal.painted", 16);
        }
    }

    public Icon func_71858_a(int side, int meta) {
        return textures[meta];
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        int c = 15 - colour;
        int meta = world.func_72805_g(x, y, z);
        if (meta != c) {
            world.func_72921_c(x, y, z, c, 3);
            return true;
        }
        return false;
    }
}

